/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.internal.actions;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.gen.eunit.GenPartsXMLFile;
import org.eclipse.edt.gen.eunit.IEUnitGenerationNotifier;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.eunit.internal.actions.EUnitGenerationNotifier;
import org.eclipse.edt.ide.ui.wizards.EGLProjectUtility;
import org.eclipse.edt.ide.ui.wizards.EGLWizardUtilities;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public abstract class GenTestDriverAction
implements IObjectActionDelegate {
    private static final String RUNUNIT_PROPERTIES = "rununit.properties";
    protected static final String RESULTROOT_KEY = "EGLTestResultRoot";
    protected static final String RESULTROOT_DIR_APPEND = "ResultRoot";
    protected static final String GENERATORID_JAVA = "org.eclipse.edt.ide.gen.JavaGenProvider";
    protected static final String GENERATORID_JAVACORE = "org.eclipse.edt.ide.gen.JavaCoreGenProvider";
    protected static final String GENERATORID_JAVASCRIPT = "org.eclipse.edt.ide.gen.JavaScriptGenProvider";
    protected static final String GENERATORID_JAVASCRIPT_DEV = "org.eclipse.edt.ide.gen.JavaScriptDevGenProvider";
    protected static final String token = "eunit_runtime";
    protected static final String[] EUNITRUNTIME_FILE = new String[]{"dataDef.egl", "TestExecutionLib.egl", "WriteResultLib.egl", "ExternalTypes.egl"};
    protected static final String[] EUNITRUNTIME_FILE_MUSTJAVAGEN = new String[]{"TestResultService.egl", "ExternalTypes.egl"};
    protected String[] EUNITRUNTIME_FILE_BYLANG = new String[0];
    protected IStructuredSelection fSelection;
    protected IWorkbenchSite fSite;

    public void run(IAction action) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.fSite.getShell());
        IResource selResource = (IResource)this.fSelection.getFirstElement();
        IProject baseProj = selResource.getProject();
        String baseProjName = baseProj.getName();
        IEGLProject baseEGLProj = EGLCore.create((IProject)baseProj);
        IWorkspaceRoot wsRoot = baseProj.getWorkspace().getRoot();
        try {
            List<WorkspaceModifyOperation> ops = this.getGenTestDriverOperatoins(wsRoot, baseProjName, baseProj, baseEGLProj);
            for (WorkspaceModifyOperation op : ops) {
                progressDialog.run(true, true, (IRunnableWithProgress)op);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract List<WorkspaceModifyOperation> getGenTestDriverOperatoins(IWorkspaceRoot var1, String var2, IProject var3, IEGLProject var4);

    protected WorkspaceModifyOperation getRefreshWSOperation(final IProject baseProj, final IProject driverProj) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("Refresh base project and generated driver project");
                baseProj.refreshLocal(2, monitor);
                driverProj.refreshLocal(2, monitor);
                monitor.worked(2);
            }
        };
        return op;
    }

    protected WorkspaceModifyOperation getCopyECKRuntimeFilesOperation(final IProject driverProject, final String languageToken) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("copying eunit runtime files...");
                GenTestDriverAction.copyFilesToProject(driverProject, "org.eclipse.edt.eunit.runtime", EUNITRUNTIME_FILE, GenTestDriverAction.token, monitor);
                GenTestDriverAction.copyFilesToProject(driverProject, "org.eclipse.edt.eunit.runtime", GenTestDriverAction.this.EUNITRUNTIME_FILE_BYLANG, "eunit_runtime/" + languageToken, monitor);
                monitor.worked(1);
            }
        };
        return op;
    }

    protected WorkspaceModifyOperation getGenDriverOperation(final IWorkspaceRoot wsRoot, final IProject baseProject, final IEGLProject baseEGLProject, final IProject driverProject, IEGLProject driverEGLProject) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    String genPartsFileLocation;
                    EUnitGenerationNotifier eckGenerationNotifier = new EUnitGenerationNotifier(monitor);
                    IPath irRootPath = baseEGLProject.getOutputLocation();
                    ProjectBuildPath projBP = ProjectBuildPathManager.getInstance().getProjectBuildPath(driverProject);
                    IContainer[] eglSrcs = projBP.getSourceLocations();
                    IPath eglSourcePath = eglSrcs[0].getFullPath();
                    ArrayList<String> argList = new ArrayList<String>();
                    argList.add("-output");
                    argList.add(wsRoot.getFolder(eglSourcePath).getLocation().toOSString());
                    argList.add("-root");
                    argList.add(wsRoot.getFolder(irRootPath).getLocation().toOSString());
                    IIDECompiler compiler = ProjectSettingsUtility.getCompiler((IProject)baseProject);
                    if (!GenTestDriverAction.this.isSelectionProject() && (genPartsFileLocation = GenTestDriverAction.this.getGenPartsArgument(wsRoot, baseProject)) != null && genPartsFileLocation.length() > 0) {
                        argList.add("-genParts");
                        argList.add(genPartsFileLocation);
                    }
                    String[] args = argList.toArray(new String[argList.size()]);
                    GenTestDriverAction.this.invokeDriverGenerator(args, compiler, eckGenerationNotifier);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return op;
    }

    protected boolean isSelectionProject() {
        Object sel = this.fSelection.getFirstElement();
        return sel instanceof IProject;
    }

    protected String getGenPartsArgument(IWorkspaceRoot wsRoot, IProject baseProject) {
        String fileLocation = this.getGenFileFullLocation(wsRoot, baseProject);
        try {
            List<IEGLFile> eglFiles = this.getEGLFiles(this.fSelection);
            ArrayList<String> partNameEntries = new ArrayList<String>();
            for (IEGLFile eglFile : eglFiles) {
                IPart[] parts;
                IPart[] iPartArray = parts = eglFile.getParts();
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    IPart part = iPartArray[n2];
                    partNameEntries.add(part.getFullyQualifiedName());
                    ++n2;
                }
            }
            this.writePart2ConfigurationFile(fileLocation, partNameEntries);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return fileLocation;
    }

    protected String getGenFileFullLocation(IWorkspaceRoot wsRoot, IProject baseProject) {
        Date now = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssZ");
        IPath path = baseProject.getFullPath();
        path = path.append("genParts" + String.valueOf(dateFormat.format(now)));
        path = path.addFileExtension("xml");
        return wsRoot.getFolder(path).getLocation().toOSString();
    }

    protected void writePart2ConfigurationFile(String fileName, List<String> entries) {
        GenPartsXMLFile driverXMLFile = new GenPartsXMLFile(fileName);
        try {
            driverXMLFile.saveGenerationEntries("", entries);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getEGLElements(IEGLElement eglElem, List<IEGLFile> result) throws EGLModelException {
        if (eglElem != null) {
            switch (eglElem.getElementType()) {
                case 3: {
                    this.collectEGLFiles((IPackageFragmentRoot)eglElem, result);
                    break;
                }
                case 4: {
                    this.collectEGLFiles((IPackageFragment)eglElem, result);
                    break;
                }
                case 6: {
                    result.add((IEGLFile)eglElem);
                }
            }
        }
    }

    private List<IEGLFile> getEGLFiles(IStructuredSelection selection) throws EGLModelException {
        ArrayList<IEGLFile> result = new ArrayList<IEGLFile>();
        if (selection != null) {
            for (Object element : selection) {
                if (element instanceof IEGLElement) {
                    IEGLElement eglElem = (IEGLElement)element;
                    this.getEGLElements(eglElem, result);
                    continue;
                }
                if (!(element instanceof IResource)) continue;
                IEGLElement eglResourceElem = EGLCore.create((IResource)((IResource)element));
                this.getEGLElements(eglResourceElem, result);
            }
        }
        return result;
    }

    private void collectEGLFiles(IPackageFragment pkg, List<IEGLFile> result) throws EGLModelException {
        IEGLFile[] eglfiles = pkg.getEGLFiles();
        int i = 0;
        while (i < eglfiles.length) {
            result.add(eglfiles[i]);
            ++i;
        }
    }

    private void collectEGLFiles(IPackageFragmentRoot pkgRoot, List<IEGLFile> result) throws EGLModelException {
        if (pkgRoot.getKind() == 1) {
            IEGLElement[] children = pkgRoot.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectEGLFiles((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    protected abstract void invokeDriverGenerator(String[] var1, IIDECompiler var2, IEUnitGenerationNotifier var3);

    protected WorkspaceModifyOperation getSetEGLBuildPathOperation(final IEGLProject eglProj, final String projname, final String dependedProjName) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("Setting EGL build path depends on project " + dependedProjName);
                ArrayList<String> eglDepends = new ArrayList<String>();
                eglDepends.add(dependedProjName);
                List depends = EGLWizardUtilities.getProjectDependencies((String)projname, eglDepends);
                int nEntries = depends.size();
                IEGLPathEntry[] classpath = new IEGLPathEntry[nEntries];
                int i = 0;
                for (PPListElement entry : depends) {
                    classpath[i] = entry.getEGLPathEntry();
                    ++i;
                }
                eglProj.setRawEGLPath(classpath, monitor);
                monitor.worked(1);
            }
        };
        return op;
    }

    protected WorkspaceModifyOperation getSetJavaBuildPathOperation(final IProject javaDriverProject, final IProject dependentProj) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (javaDriverProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    monitor.subTask("Set java build path depends on project " + dependentProj.getName());
                    IJavaProject javaProject = JavaCore.create((IProject)javaDriverProject);
                    IClasspathEntry[] classpath = javaProject.getRawClasspath();
                    boolean javaProjBuildPathAlreadySet = false;
                    int p = 0;
                    while (p < classpath.length && !javaProjBuildPathAlreadySet) {
                        if (classpath[p].getEntryKind() == 2) {
                            IPath dependentProjPath = classpath[p].getPath();
                            if (dependentProj.getFullPath().equals((Object)dependentProjPath)) {
                                javaProjBuildPathAlreadySet = true;
                            }
                        }
                        ++p;
                    }
                    if (!javaProjBuildPathAlreadySet) {
                        ArrayList<IClasspathEntry> additions = new ArrayList<IClasspathEntry>();
                        IClasspathEntry newClsPathEntry = JavaCore.newProjectEntry((IPath)dependentProj.getFullPath());
                        additions.add(newClsPathEntry);
                        if (additions.size() > 0) {
                            IClasspathEntry[] newEntries = new IClasspathEntry[classpath.length + additions.size()];
                            System.arraycopy(classpath, 0, newEntries, 0, classpath.length);
                            int i = 0;
                            while (i < additions.size()) {
                                newEntries[classpath.length + i] = (IClasspathEntry)additions.get(i);
                                ++i;
                            }
                            javaProject.setRawClasspath(newEntries, null);
                        }
                    }
                    monitor.worked(1);
                }
            }
        };
        return op;
    }

    protected WorkspaceModifyOperation getCreateEGLProjectOperation(final IWorkspaceRoot wsRoot, final String newProjName, final String baseProj) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("Creating driver project " + newProjName);
                IProject newProj = wsRoot.getProject(newProjName);
                if (!newProj.exists()) {
                    PartWrapper pw;
                    EGLWizardUtilities.createProject((String)newProjName, (int)0);
                    IProject origProj = wsRoot.getProject(baseProj);
                    if (origProj.exists() && (pw = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)origProj)) != null && pw.getPartPath() != null && pw.getPartPath().length() > 0) {
                        DefaultDeploymentDescriptorUtility.setDefaultDeploymentDescriptor((IResource)newProj, (PartWrapper)pw);
                    }
                }
                monitor.worked(1);
            }
        };
        return op;
    }

    protected WorkspaceModifyOperation getSetGeneratorIDOperation(final IProject driverProject, final String[] generatorIDs) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("set generator id " + generatorIDs[0] + " for project " + driverProject.getName());
                try {
                    ProjectSettingsUtility.setGeneratorIds((IResource)driverProject, (String[])generatorIDs);
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                monitor.worked(1);
            }
        };
        return op;
    }

    protected WorkspaceModifyOperation getCreateRununitPropertyOperation(final IWorkspaceRoot wsRoot, final IProject driverProject) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (driverProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    monitor.subTask("Creating rununit property EGLTestResultRoot");
                    IJavaProject javaProject = JavaCore.create((IProject)driverProject);
                    IClasspathEntry[] classpath = javaProject.getRawClasspath();
                    IClasspathEntry sourceClsPath = null;
                    int i = 0;
                    while (i < classpath.length && sourceClsPath == null) {
                        if (classpath[i].getEntryKind() == 3) {
                            sourceClsPath = classpath[i];
                        }
                        ++i;
                    }
                    if (sourceClsPath != null) {
                        IPath propertyFilePath = sourceClsPath.getPath().append(GenTestDriverAction.RUNUNIT_PROPERTIES);
                        IFile propertyFile = wsRoot.getFile(propertyFilePath);
                        String propertyOSPath = propertyFile.getLocation().toOSString();
                        try {
                            Properties props = new Properties();
                            if (propertyFile.exists()) {
                                FileReader inReader = new FileReader(propertyOSPath);
                                props.load(inReader);
                                inReader.close();
                            }
                            PrintWriter outWriter = new PrintWriter(propertyOSPath);
                            String resultRootFolder = driverProject.getFolder(GenTestDriverAction.RESULTROOT_DIR_APPEND).getLocation().toOSString();
                            props.put(GenTestDriverAction.RESULTROOT_KEY, resultRootFolder);
                            props.store(outWriter, "");
                            outWriter.flush();
                            outWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    monitor.worked(1);
                }
            }
        };
        return op;
    }

    protected static void copyFilesToProject(IProject toProject, String toPackage, String[] files, String resourceLocation, IProgressMonitor monitor) throws CoreException, InterruptedException, InvocationTargetException {
        EGLWizardUtilities.createPackage((String)toPackage, (String)toProject.getName());
        Bundle sourcePlugin = Platform.getBundle((String)"org.eclipse.edt.ide.eunit");
        String[] sourceFileNames = files;
        Path sourceRelative2PluginPath = new Path(resourceLocation);
        IEGLProject eproject = EGLCore.create((IProject)toProject);
        List eglSrcs = EGLProjectUtility.getDefaultClassPath((IEGLProject)eproject);
        IPath eglSourcePath = ((PPListElement)eglSrcs.get(0)).getPath();
        IPackageFragmentRoot root = eproject.findPackageFragmentRoot(eglSourcePath.makeAbsolute());
        IPackageFragment frag = root.getPackageFragment(toPackage);
        IPath targetRelative2ProjectPath = frag.getResource().getProjectRelativePath();
        GenTestDriverAction.copyFiles(sourcePlugin, (IPath)sourceRelative2PluginPath, sourceFileNames, toProject, targetRelative2ProjectPath, monitor);
    }

    protected static void copyFiles(Bundle sourcePlugin, IPath sourceRelative2PluginPath, String[] sourceFileNames, IProject targetProj, IPath targetRelative2ProjPath, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < sourceFileNames.length) {
            IFolder targetFolder = targetProj.getFolder(targetRelative2ProjPath);
            EGLWizardUtilities.createFolderRecursiveIfNeeded((IContainer)targetFolder);
            IPath filepathRelative2Proj = targetRelative2ProjPath.append(sourceFileNames[i]);
            IFile targetFile = targetProj.getFile(filepathRelative2Proj);
            if (!targetFile.exists()) {
                IPath sourceFile = sourceRelative2PluginPath.append(sourceFileNames[i]);
                try {
                    InputStream sourceStream = FileLocator.openStream((Bundle)sourcePlugin, (IPath)sourceFile, (boolean)false);
                    targetFile.create(sourceStream, true, monitor);
                    sourceStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                int x = 0;
                while (x < EUNITRUNTIME_FILE_MUSTJAVAGEN.length) {
                    if (sourceFileNames[i].equals(EUNITRUNTIME_FILE_MUSTJAVAGEN[x])) {
                        ProjectSettingsUtility.setGeneratorIds((IResource)targetFile, (String[])new String[]{GENERATORID_JAVA});
                    }
                    ++x;
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }
}

