/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.project.features.IEGLProjectFeature;

public class EGLProjectFeatureContributionsRegistry {
    private boolean initialized;
    private HashMap contributions = new HashMap();
    private HashMap projectFeatures = new HashMap();
    private List ids = new ArrayList();
    public static final EGLProjectFeatureContributionsRegistry singleton = new EGLProjectFeatureContributionsRegistry();

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("org.eclipse.edt.ide.ui.eglProjectFeature");
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement currentConf = conf[i];
            String id = this.getId(currentConf);
            this.ids.add(id);
            this.contributions.put(id, currentConf);
            ++i;
        }
    }

    private String getId(IConfigurationElement contribution) {
        return contribution.getAttribute("id");
    }

    public List getAllFeatures() {
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<IEGLProjectFeature> result = new ArrayList<IEGLProjectFeature>();
        for (String id : this.ids) {
            result.add(this.getFeature(id));
        }
        return result;
    }

    private IEGLProjectFeature getFeature(String id) {
        IEGLProjectFeature result = null;
        if (this.projectFeatures.get(id) == null) {
            try {
                IConfigurationElement contribution = (IConfigurationElement)this.contributions.get(id);
                if (contribution != null) {
                    result = (IEGLProjectFeature)contribution.createExecutableExtension("projectFeatureClass");
                }
                this.projectFeatures.put(id, result);
            }
            catch (Exception e) {
                EGLLogger.log((Object)"EGLProjectFeatureContributionsRegistry", e.getMessage());
            }
        } else {
            result = (IEGLProjectFeature)this.projectFeatures.get(id);
        }
        return result;
    }
}

