/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.model.event;

import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionChangeEvent
extends CollectionEvent {
    private final Object[] collection;
    private static final long serialVersionUID = 1L;

    public CollectionChangeEvent(Model source, String collectionName, Collection<?> collection) {
        this(source, collectionName, collection.toArray());
    }

    private CollectionChangeEvent(Model source, String collectionName, Object[] collection) {
        super(source, collectionName);
        this.collection = collection;
    }

    public Iterable<?> getCollection() {
        return new ArrayIterable<Object>(this.collection);
    }

    public int getCollectionSize() {
        return this.collection.length;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        StringTools.append(sb, this.collection);
    }

    public CollectionChangeEvent clone(Model newSource) {
        return this.clone(newSource, this.collectionName);
    }

    public CollectionChangeEvent clone(Model newSource, String newCollectionName) {
        return new CollectionChangeEvent(newSource, newCollectionName, this.collection);
    }
}

