/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationPreferences;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JptUiValidationPreferenceMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProblemSeveritiesPage
extends PropertyAndPreferencePage {
    private Map<String, String> severityLevels;
    private Map<String, String> defaultSeverities;
    private List<Combo> combos;
    private List<ExpandableComposite> expandablePanes;
    private static final int ERROR_INDEX = 0;
    private static final int WARNING_INDEX = 1;
    private static final int INFO_INDEX = 2;
    private static final int IGNORE_INDEX = 3;
    private static final String JPT_PREFERENCES_PROBLEM_SEVERITIES_ID = "org.eclipse.jpt.jpa.ui.jpaProblemSeveritiesPreferences";
    private static final String JPT_PROPERTY_PAGES_PROBLEM_SEVERITIES_ID = "org.eclipse.jpt.jpa.ui.jpaProblemSeveritiesProperties";
    private static final String PREFERENCE_KEY = "preferenceKey";
    private ScrolledPageContent scrollable;
    private String[] severityDisplayStrings;
    public static final String SETTINGS_EXPANDED = "expanded";
    public static final String SETTINGS_SECTION_NAME = "JpaProblemSeveritiesPage";
    private Boolean hasProjectSpecificPreferences = null;

    public JpaProblemSeveritiesPage() {
        this.initialize();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(JptJpaUiPlugin.instance().getPreferenceStore());
        this.setDescription(JptUiMessages.JpaProblemSeveritiesPage_Description);
    }

    protected void initialize() {
        this.combos = new ArrayList<Combo>();
        this.expandablePanes = new ArrayList<ExpandableComposite>();
        this.severityDisplayStrings = this.buildSeverityDisplayStrings();
        this.severityLevels = new HashMap<String, String>();
        this.defaultSeverities = this.buildDefaultSeverties();
    }

    protected Map<String, String> buildDefaultSeverties() {
        HashMap<String, String> defaultSeverities = new HashMap<String, String>();
        defaultSeverities.put("PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS", "warning");
        defaultSeverities.put("PROJECT_NO_CONNECTION", "warning");
        defaultSeverities.put("PROJECT_INVALID_CONNECTION", "warning");
        defaultSeverities.put("PROJECT_INACTIVE_CONNECTION", "warning");
        defaultSeverities.put("MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA", "warning");
        defaultSeverities.put("PERSISTENT_TYPE_DUPLICATE_CLASS", "warning");
        defaultSeverities.put("PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING", "warning");
        defaultSeverities.put("PERSISTENT_ATTRIBUTE_INHERITED_ATTRIBUTES_NOT_SUPPORTED", "warning");
        defaultSeverities.put("PERSISTENT_TYPE_ANNOTATED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT", "warning");
        defaultSeverities.put("ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", "warning");
        defaultSeverities.put("PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE", "warning");
        defaultSeverities.put("ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", "warning");
        defaultSeverities.put("ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", "warning");
        defaultSeverities.put("XML_VERSION_NOT_LATEST", "info");
        defaultSeverities.put("PERSISTENCE_UNIT_REDUNDANT_CLASS", "info");
        return defaultSeverities;
    }

    protected Control createPreferenceContent(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.scrollable = new ScrolledPageContent(container);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        this.scrollable.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent = this.scrollable.getBody();
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        parent.setLayout((Layout)layout);
        this.addProjectLevelCategory(parent);
        this.addPersistenceUnitLevelCategory(parent);
        this.addTypeLevelCategory(parent);
        this.addAttributeLevelCategory(parent);
        this.addDatabaseCategory(parent);
        this.addInheritanceStrategyCategory(parent);
        this.addQueriesGeneratorsCategory(parent);
        this.restoreSectionExpansionStates(this.getDialogPreferences());
        return container;
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int index = this.expandablePanes.size();
        while (--index >= 0) {
            ExpandableComposite expandablePane = this.expandablePanes.get(index);
            if (settings == null) {
                expandablePane.setExpanded(index == 0);
                continue;
            }
            expandablePane.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + index));
        }
    }

    public Point computeSize() {
        return this.doComputeSize();
    }

    private void addProjectLevelCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.PROJECT_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.NO_JPA_PROJECT, "NO_JPA_PROJECT");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS, "PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_NO_PERSISTENCE_UNIT, "PERSISTENCE_NO_PERSISTENCE_UNIT");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_XML_INVALID_CONTENT, "PERSISTENCE_XML_INVALID_CONTENT");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_XML_UNSUPPORTED_CONTENT, "PERSISTENCE_XML_UNSUPPORTED_CONTENT");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PROJECT_MULTIPLE_PERSISTENCE_XML, "PROJECT_MULTIPLE_PERSISTENCE_XML");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PROJECT_INACTIVE_CONNECTION, "PROJECT_INACTIVE_CONNECTION");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PROJECT_INVALID_CONNECTION, "PROJECT_INVALID_CONNECTION");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PROJECT_INVALID_LIBRARY_PROVIDER, "PROJECT_INVALID_LIBRARY_PROVIDER");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PROJECT_NO_CONNECTION, "PROJECT_NO_CONNECTION");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PROJECT_NO_PERSISTENCE_XML, "PROJECT_NO_PERSISTENCE_XML");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.XML_VERSION_NOT_LATEST, "XML_VERSION_NOT_LATEST");
    }

    private void addPersistenceUnitLevelCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA, "MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_TYPE_DUPLICATE_CLASS, "PERSISTENT_TYPE_DUPLICATE_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_DUPLICATE_CLASS, "PERSISTENCE_UNIT_DUPLICATE_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_DUPLICATE_JAR_FILE, "PERSISTENCE_UNIT_DUPLICATE_JAR_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_INVALID_CLASS, "PERSISTENCE_UNIT_INVALID_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_INVALID_MAPPING_FILE, "PERSISTENCE_UNIT_INVALID_MAPPING_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING, "PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_NONEXISTENT_CLASS, "PERSISTENCE_UNIT_NONEXISTENT_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_NONEXISTENT_JAR_FILE, "PERSISTENCE_UNIT_NONEXISTENT_JAR_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE, "PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_REDUNDANT_CLASS, "PERSISTENCE_UNIT_REDUNDANT_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_UNSPECIFIED_CLASS, "PERSISTENCE_UNIT_UNSPECIFIED_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_UNSPECIFIED_JAR_FILE, "PERSISTENCE_UNIT_UNSPECIFIED_JAR_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE, "PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT, "PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT");
    }

    private void addTypeLevelCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.TYPE_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_NAME_DUPLICATED, "ENTITY_NAME_DUPLICATED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_NAME_MISSING, "ENTITY_NAME_MISSING");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_NO_PK, "ENTITY_NO_PK");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_NON_ROOT_ID_ATTRIBUTE_SPECIFIED, "ENTITY_NON_ROOT_ID_ATTRIBUTE_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_NON_ROOT_ID_CLASS_SPECIFIED, "ENTITY_NON_ROOT_ID_CLASS_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_TYPE_ANNOTATED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT, "PERSISTENT_TYPE_ANNOTATED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_TYPE_MAPPED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT, "PERSISTENT_TYPE_MAPPED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_TYPE_UNRESOLVED_CLASS, "PERSISTENT_TYPE_UNRESOLVED_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_TYPE_UNSPECIFIED_CLASS, "PERSISTENT_TYPE_UNSPECIFIED_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TARGET_NOT_AN_EMBEDDABLE, "TARGET_NOT_AN_EMBEDDABLE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_CLASS_MISSING_NO_ARG_CONSTRUCTOR, "TYPE_MAPPING_CLASS_MISSING_NO_ARG_CONSTRUCTOR");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_CLASS_PRIVATE_NO_ARG_CONSTRUCTOR, "TYPE_MAPPING_CLASS_PRIVATE_NO_ARG_CONSTRUCTOR");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_FINAL_CLASS, "TYPE_MAPPING_FINAL_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_AND_EMBEDDED_ID_BOTH_USED, "TYPE_MAPPING_ID_CLASS_AND_EMBEDDED_ID_BOTH_USED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_DUPLICATE_MATCH, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_DUPLICATE_MATCH");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_NO_MATCH, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_MAPPING_NO_MATCH");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NO_MATCH, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NO_MATCH");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NOT_PRIMARY_KEY, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_NOT_PRIMARY_KEY");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_ATTRIBUTE_TYPE_DOES_NOT_AGREE, "TYPE_MAPPING_ID_CLASS_ATTRIBUTE_TYPE_DOES_NOT_AGREE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_NAME_EMPTY, "TYPE_MAPPING_ID_CLASS_NAME_EMPTY");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_NOT_EXIST, "TYPE_MAPPING_ID_CLASS_NOT_EXIST");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_NOT_VALID, "TYPE_MAPPING_ID_CLASS_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_REDEFINED, "TYPE_MAPPING_ID_CLASS_REDEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_REQUIRED, "TYPE_MAPPING_ID_CLASS_REQUIRED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_ID_CLASS_WITH_MAPS_ID, "TYPE_MAPPING_ID_CLASS_WITH_MAPS_ID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_MAPS_ID_ATTRIBUTE_TYPE_DOES_NOT_AGREE, "TYPE_MAPPING_MAPS_ID_ATTRIBUTE_TYPE_DOES_NOT_AGREE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_MEMBER_CLASS, "TYPE_MAPPING_MEMBER_CLASS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_MULTIPLE_EMBEDDED_ID, "TYPE_MAPPING_MULTIPLE_EMBEDDED_ID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_PK_REDEFINED_ID_ATTRIBUTE, "TYPE_MAPPING_PK_REDEFINED_ID_ATTRIBUTE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TYPE_MAPPING_PK_REDEFINED_ID_CLASS, "TYPE_MAPPING_PK_REDEFINED_ID_CLASS");
    }

    private void addAttributeLevelCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.ATTRIBUTE_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE, "ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ELEMENT_COLLECTION_TARGET_CLASS_DOES_NOT_EXIST, "ELEMENT_COLLECTION_TARGET_CLASS_DOES_NOT_EXIST");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED, "ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED, "ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED, "EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED, "ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPS_ID_VALUE_INVALID, "MAPS_ID_VALUE_INVALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPS_ID_VALUE_NOT_RESOLVED, "MAPS_ID_VALUE_NOT_RESOLVED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPS_ID_VALUE_NOT_SPECIFIED, "MAPS_ID_VALUE_NOT_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPPING_INVALID_MAPPED_BY, "MAPPING_INVALID_MAPPED_BY");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPPING_MAPPED_BY_ON_BOTH_SIDES, "MAPPING_MAPPED_BY_ON_BOTH_SIDES");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAPPING_UNRESOLVED_MAPPED_BY, "MAPPING_UNRESOLVED_MAPPED_BY");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED, "ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_ELEMENT_COLLECTION_INVALID_VALUE_TYPE, "PERSISTENT_ATTRIBUTE_ELEMENT_COLLECTION_INVALID_VALUE_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_FINAL_FIELD, "PERSISTENT_ATTRIBUTE_FINAL_FIELD");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_FINAL_GETTER, "PERSISTENT_ATTRIBUTE_FINAL_GETTER");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_INHERITED_ATTRIBUTES_NOT_SUPPORTED, "PERSISTENT_ATTRIBUTE_INHERITED_ATTRIBUTES_NOT_SUPPORTED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_INVALID_MAPPING, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_INVALID_TEMPORAL_MAPPING_TYPE, "PERSISTENT_ATTRIBUTE_INVALID_TEMPORAL_MAPPING_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE, "PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_PUBLIC_FIELD, "PERSISTENT_ATTRIBUTE_PUBLIC_FIELD");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME, "PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TARGET_ENTITY_IS_NOT_AN_ENTITY, "TARGET_ENTITY_IS_NOT_AN_ENTITY");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TARGET_ENTITY_NOT_DEFINED, "TARGET_ENTITY_NOT_DEFINED");
        parent = this.addSubExpandableSection(parent, JptUiValidationPreferenceMessages.IMPLIED_ATTRIBUTE_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_DOES_NOT_EXIST, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_DOES_NOT_EXIST");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED, "VIRTUAL_ATTRIBUTE_ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED");
    }

    private void addDatabaseCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.DATABASE_CATEGORY);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.addTableCategory(parent);
        this.addColumnCategory(parent);
        this.addOverridesCategory(parent);
    }

    private void addTableCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.TABLE_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.COLLECTION_TABLE_UNRESOLVED_CATALOG, "COLLECTION_TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.COLLECTION_TABLE_UNRESOLVED_NAME, "COLLECTION_TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.COLLECTION_TABLE_UNRESOLVED_SCHEMA, "COLLECTION_TABLE_UNRESOLVED_SCHEMA");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_TABLE_UNRESOLVED_CATALOG, "JOIN_TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_TABLE_UNRESOLVED_NAME, "JOIN_TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_TABLE_UNRESOLVED_SCHEMA, "JOIN_TABLE_UNRESOLVED_SCHEMA");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.SECONDARY_TABLE_UNRESOLVED_CATALOG, "SECONDARY_TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.SECONDARY_TABLE_UNRESOLVED_NAME, "SECONDARY_TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.SECONDARY_TABLE_UNRESOLVED_SCHEMA, "SECONDARY_TABLE_UNRESOLVED_SCHEMA");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TABLE_UNRESOLVED_CATALOG, "TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TABLE_UNRESOLVED_NAME, "TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.TABLE_UNRESOLVED_SCHEMA, "TABLE_UNRESOLVED_SCHEMA");
        parent = this.addSubExpandableSection(parent, JptUiValidationPreferenceMessages.IMPLIED_ATTRIBUTE_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_CATALOG, "VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_SCHEMA, "VIRTUAL_ATTRIBUTE_COLLECTION_TABLE_UNRESOLVED_SCHEMA");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA");
    }

    private void addColumnCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.COLUMN_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.COLUMN_TABLE_NOT_VALID, "COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.COLUMN_UNRESOLVED_NAME, "COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.COLUMN_UNRESOLVED_TABLE, "COLUMN_UNRESOLVED_TABLE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.INVERSE_JOIN_COLUMN_TABLE_NOT_VALID, "INVERSE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.INVERSE_JOIN_COLUMN_UNRESOLVED_NAME, "INVERSE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_COLUMN_TABLE_NOT_VALID, "JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_COLUMN_UNRESOLVED_NAME, "JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAP_KEY_COLUMN_TABLE_NOT_VALID, "MAP_KEY_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.MAP_KEY_COLUMN_UNRESOLVED_NAME, "MAP_KEY_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ORDER_COLUMN_UNRESOLVED_NAME, "ORDER_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME, "PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        parent = this.addSubExpandableSection(parent, JptUiValidationPreferenceMessages.IMPLIED_ATTRIBUTE_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "VIRTUAL_ATTRIBUTE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_TABLE, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_TABLE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_JOIN_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_MAP_KEY_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ORDER_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_ORDER_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "VIRTUAL_SECONDARY_TABLE_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "VIRTUAL_PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
    }

    private void addOverridesCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.OVERRIDES_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ASSOCIATION_OVERRIDE_INVALID_NAME, "ASSOCIATION_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ATTRIBUTE_OVERRIDE_INVALID_NAME, "ATTRIBUTE_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ATTRIBUTE_OVERRIDE_INVALID_TYPE, "ATTRIBUTE_OVERRIDE_INVALID_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ATTRIBUTE_OVERRIDE_MAPPED_BY_RELATIONSHIP_AND_SPECIFIED, "ATTRIBUTE_OVERRIDE_MAPPED_BY_RELATIONSHIP_AND_SPECIFIED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_INVALID_NAME, "VIRTUAL_ASSOCIATION_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS, "VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS, "VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "VIRTUAL_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_CATALOG, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_CATALOG");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_NAME, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_SCHEMA, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_TABLE_UNRESOLVED_SCHEMA");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_NAME, "VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_TYPE, "VIRTUAL_ATTRIBUTE_OVERRIDE_INVALID_TYPE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_INVALID_NAME, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_INVALID_NAME");
        parent = this.addSubExpandableSection(parent, JptUiValidationPreferenceMessages.IMPLIED_ATTRIBUTE_LEVEL_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVALID_NAME, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_INVERSE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_INVERSE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_INVALID_NAME, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID, "VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_INVALID_NAME, "VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_INVALID_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME, "VIRTUAL_ATTRIBUTE_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME");
    }

    private void addInheritanceStrategyCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.INHERITANCE_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.DISCRIMINATOR_COLUMN_UNRESOLVED_NAME, "DISCRIMINATOR_COLUMN_UNRESOLVED_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM");
    }

    private void addQueriesGeneratorsCategory(Composite parent) {
        parent = this.addExpandableSection(parent, JptUiValidationPreferenceMessages.QUERIES_GENERATORS_CATEGORY);
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.GENERATOR_DUPLICATE_NAME, "GENERATOR_DUPLICATE_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.GENERATOR_NAME_UNDEFINED, "GENERATOR_NAME_UNDEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.ID_MAPPING_UNRESOLVED_GENERATOR_NAME, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.JPQL_QUERY_VALIDATION, "JPQL_QUERY_VALIDATION");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.QUERY_DUPLICATE_NAME, "QUERY_DUPLICATE_NAME");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.QUERY_NAME_UNDEFINED, "QUERY_NAME_UNDEFINED");
        this.addLabeledCombo(parent, JptUiValidationPreferenceMessages.QUERY_STATEMENT_UNDEFINED, "QUERY_STATEMENT_UNDEFINED");
    }

    private Composite addExpandableSection(Composite parent, String text) {
        return this.addExpandableSection(parent, text, new GridData(4, 4, true, false));
    }

    private Composite addSubExpandableSection(Composite parent, String text) {
        return this.addExpandableSection(parent, text, new GridData(4, 4, true, false, 2, 1));
    }

    private Composite addExpandableSection(Composite parent, String text, GridData gridData) {
        ExpandableComposite expandablePane = new ExpandableComposite(parent, 0, 18);
        expandablePane.setText(text);
        expandablePane.setExpanded(false);
        expandablePane.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        expandablePane.setLayoutData((Object)gridData);
        expandablePane.addExpansionListener((IExpansionListener)this.buildExpansionListener());
        this.scrollable.adaptChild((Control)expandablePane);
        this.expandablePanes.add(expandablePane);
        parent = new Composite((Composite)expandablePane, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        expandablePane.setClient((Control)parent);
        return parent;
    }

    private void addLabeledCombo(Composite parent, String labelText, String preferenceKey) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(labelText);
        Combo combo = new Combo(parent, 8);
        combo.setItems(this.severityDisplayStrings);
        combo.setLayoutData((Object)new GridData(256));
        combo.setData(PREFERENCE_KEY, (Object)preferenceKey);
        combo.select(this.convertPreferenceKeyToComboIndex(preferenceKey));
        combo.addSelectionListener(this.buildComboSelectionListener());
        this.scrollable.adaptChild((Control)combo);
        this.combos.add(combo);
    }

    private SelectionListener buildComboSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                String preferenceKey = (String)combo.getData(JpaProblemSeveritiesPage.PREFERENCE_KEY);
                String value = JpaProblemSeveritiesPage.this.convertToPreferenceValue(combo.getSelectionIndex());
                JpaProblemSeveritiesPage.this.severityLevels.put(preferenceKey, value);
            }
        };
    }

    private ExpansionAdapter buildExpansionListener() {
        return new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                JpaProblemSeveritiesPage.this.expansionStateChanged();
            }
        };
    }

    protected String[] buildSeverityDisplayStrings() {
        String[] severities = new String[]{JptUiMessages.JpaProblemSeveritiesPage_Error, JptUiMessages.JpaProblemSeveritiesPage_Warning, JptUiMessages.JpaProblemSeveritiesPage_Info, JptUiMessages.JpaProblemSeveritiesPage_Ignore};
        return severities;
    }

    protected int convertPreferenceKeyToComboIndex(String preferenceKey) {
        return this.convertPreferenceValueToComboIndex(this.getPreferenceValue(preferenceKey));
    }

    protected String getPreferenceValue(String preferenceKey) {
        String preference = null;
        preference = this.isProjectPreferencePage() && this.hasProjectSpecificOptions(this.getProject()) ? JpaValidationPreferences.getProjectLevelProblemPreference((IProject)this.getProject(), (String)preferenceKey) : JpaValidationPreferences.getWorkspaceLevelProblemPreference((String)preferenceKey);
        if (preference == null) {
            preference = this.getDefaultPreferenceValue(preferenceKey);
        }
        return preference;
    }

    protected String getDefaultPreferenceValue(String preferenceKey) {
        String preference = this.defaultSeverities.get(preferenceKey);
        return preference == null ? "error" : preference;
    }

    protected int convertPreferenceValueToComboIndex(String preferenceValue) {
        if ("error".equals(preferenceValue)) {
            return 0;
        }
        if ("warning".equals(preferenceValue)) {
            return 1;
        }
        if ("info".equals(preferenceValue)) {
            return 2;
        }
        if ("ignore".equals(preferenceValue)) {
            return 3;
        }
        throw new IllegalStateException();
    }

    protected String convertToPreferenceValue(int selectionIndex) {
        switch (selectionIndex) {
            case 0: {
                return "error";
            }
            case 1: {
                return "warning";
            }
            case 2: {
                return "info";
            }
            case 3: {
                return "ignore";
            }
        }
        return null;
    }

    protected void expansionStateChanged() {
        this.scrollable.reflow(true);
    }

    protected String getPreferencePageID() {
        return JPT_PREFERENCES_PROBLEM_SEVERITIES_ID;
    }

    protected String getPropertyPageID() {
        return JPT_PROPERTY_PAGES_PROBLEM_SEVERITIES_ID;
    }

    protected IEclipsePreferences getProjectPreferences(IProject project) {
        return JptJpaCorePlugin.getProjectPreferences((IProject)project);
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        IEclipsePreferences projectPreferences = this.getProjectPreferences(project);
        return projectPreferences.getBoolean("workspace_preferences_overriden", false);
    }

    protected void performDefaults() {
        super.performDefaults();
        if (!this.isProjectPreferencePage()) {
            this.revertToDefault();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.getDefaultsButton() == null) {
            return;
        }
        this.hasProjectSpecificPreferences = useProjectSpecificSettings;
        if (useProjectSpecificSettings) {
            this.overrideWorkspacePreferences();
        } else {
            this.revertToDefault();
        }
    }

    protected void noDefaultAndApplyButton() {
        throw new IllegalStateException("Don't call this, see enableProjectSpecificSettings for the hack that looks for the defaultsButton being null");
    }

    protected void revertToDefault() {
        for (Combo combo : this.combos) {
            String preferenceKey = (String)combo.getData(PREFERENCE_KEY);
            combo.select(this.convertPreferenceValueToComboIndex(this.getDefaultPreferenceValue(preferenceKey)));
            this.severityLevels.put(preferenceKey, null);
        }
    }

    protected void overrideWorkspacePreferences() {
        for (Combo combo : this.combos) {
            String preferenceKey = (String)combo.getData(PREFERENCE_KEY);
            String workspacePreference = JpaValidationPreferences.getWorkspaceLevelProblemPreference((String)preferenceKey);
            String defaultPreference = this.getDefaultPreferenceValue(preferenceKey);
            if (workspacePreference != null && !workspacePreference.equals(defaultPreference)) {
                combo.select(this.convertPreferenceValueToComboIndex(workspacePreference));
                this.severityLevels.put(preferenceKey, workspacePreference);
                continue;
            }
            combo.select(this.convertPreferenceValueToComboIndex(defaultPreference));
        }
    }

    public boolean performOk() {
        super.performOk();
        if (this.hasProjectSpecificPreferences != null) {
            IEclipsePreferences projectPreferences = this.getProjectPreferences(this.getProject());
            if (this.hasProjectSpecificPreferences.booleanValue()) {
                projectPreferences.putBoolean("workspace_preferences_overriden", true);
            } else {
                projectPreferences.remove("workspace_preferences_overriden");
            }
            JpaValidationPreferences.flush((IEclipsePreferences)projectPreferences);
        }
        for (String validationPreferenceKey : this.severityLevels.keySet()) {
            this.updatePreference(validationPreferenceKey, this.severityLevels.get(validationPreferenceKey));
        }
        try {
            this.buildOkProgressMonitorDialog().run(true, false, this.buildOkRunnableWithProgress());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getTargetException());
        }
        return true;
    }

    protected void updatePreference(String preferenceKey, String value) {
        if (this.isProjectPreferencePage()) {
            JpaValidationPreferences.setProjectLevelProblemPreference((IProject)this.getProject(), (String)preferenceKey, (String)value);
        } else {
            JpaValidationPreferences.setWorkspaceLevelProblemPreference((String)preferenceKey, (String)value);
        }
    }

    private IRunnableContext buildOkProgressMonitorDialog() {
        return new ProgressMonitorDialog(this.getShell());
    }

    private IRunnableWithProgress buildOkRunnableWithProgress() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                try {
                    ws.run(JpaProblemSeveritiesPage.this.buildOkWorkspaceRunnable(), (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
    }

    IWorkspaceRunnable buildOkWorkspaceRunnable() {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JpaProblemSeveritiesPage.this.performOk_(monitor);
            }
        };
    }

    void performOk_(IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null) {
            JavaPlugin.getWorkspace().build(6, monitor);
        } else {
            this.getProject().build(6, monitor);
        }
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogPreferences());
        super.dispose();
    }

    protected IDialogSettings getDialogPreferences() {
        IDialogSettings rootSettings = JptJpaUiPlugin.instance().getDialogSettings();
        IDialogSettings settings = rootSettings.getSection(SETTINGS_SECTION_NAME);
        if (settings == null) {
            settings = rootSettings.addNewSection(SETTINGS_SECTION_NAME);
        }
        return settings;
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int index = this.expandablePanes.size();
        while (--index >= 0) {
            ExpandableComposite expandablePane = this.expandablePanes.get(index);
            settings.put(SETTINGS_EXPANDED + index, expandablePane.isExpanded());
        }
    }
}

