/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.EDTUIPreferenceConstants;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalCategory;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalComputerDescriptor;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLTextMessages;
import org.eclipse.edt.ide.ui.internal.preferences.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class EGLCompletionProposalComputerRegistry {
    private static final String EXTENSION_POINT = "eglCompletionProposalComputer";
    private static final String NUM_COMPUTERS_PREF_KEY = "content_assist_number_of_computers";
    private static EGLCompletionProposalComputerRegistry eglCplProposalRegistrySingleton = null;
    private final Map fDescriptorsByPartition = new HashMap();
    private final Map fPublicDescriptorsByPartition = new HashMap();
    private final List fDescriptors = new ArrayList();
    private final List fPublicDescriptors = Collections.unmodifiableList(this.fDescriptors);
    private final List fCategories = new ArrayList();
    private final List fPublicCategories = Collections.unmodifiableList(this.fCategories);
    private boolean fLoaded = false;
    private boolean fHasUninstalledComputers = false;

    public static synchronized EGLCompletionProposalComputerRegistry getDefault() {
        if (eglCplProposalRegistrySingleton == null) {
            eglCplProposalRegistrySingleton = new EGLCompletionProposalComputerRegistry();
        }
        return eglCplProposalRegistrySingleton;
    }

    List getProposalComputerDescriptors() {
        this.ensureExtensionPointRead();
        return this.fPublicDescriptors;
    }

    List getProposalComputerDescriptors(String partition) {
        this.ensureExtensionPointRead();
        List result = (List)this.fPublicDescriptorsByPartition.get(partition);
        return result != null ? result : Collections.EMPTY_LIST;
    }

    public List getProposalCategories() {
        this.ensureExtensionPointRead();
        return this.fPublicCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExtensionPointRead() {
        boolean reload;
        EGLCompletionProposalComputerRegistry eGLCompletionProposalComputerRegistry = this;
        synchronized (eGLCompletionProposalComputerRegistry) {
            reload = !this.fLoaded;
            this.fLoaded = true;
        }
        if (reload) {
            this.reload();
            this.updateUninstalledComputerCount();
        }
    }

    private void updateUninstalledComputerCount() {
        int currNumber;
        IPreferenceStore preferenceStore = EDTUIPreferenceConstants.getPreferenceStore();
        int lastNumberOfComputers = preferenceStore.getInt(NUM_COMPUTERS_PREF_KEY);
        this.fHasUninstalledComputers = lastNumberOfComputers > (currNumber = this.fDescriptors.size());
        preferenceStore.putValue(NUM_COMPUTERS_PREF_KEY, Integer.toString(currNumber));
        EDTUIPlugin.getDefault().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(Arrays.asList(registry.getConfigurationElementsFor(EDTUIPlugin.getPluginId(), EXTENSION_POINT)));
        HashMap<String, ArrayList<EGLCompletionProposalComputerDescriptor>> map = new HashMap<String, ArrayList<EGLCompletionProposalComputerDescriptor>>();
        ArrayList<EGLCompletionProposalComputerDescriptor> all = new ArrayList<EGLCompletionProposalComputerDescriptor>();
        List categories = this.getCategories(elements);
        for (IConfigurationElement element : elements) {
            try {
                EGLCompletionProposalComputerDescriptor desc = new EGLCompletionProposalComputerDescriptor(element, this, categories);
                Set partitions = desc.getPartitions();
                for (String partition : partitions) {
                    ArrayList<EGLCompletionProposalComputerDescriptor> list = (ArrayList<EGLCompletionProposalComputerDescriptor>)map.get(partition);
                    if (list == null) {
                        list = new ArrayList<EGLCompletionProposalComputerDescriptor>();
                        map.put(partition, list);
                    }
                    list.add(desc);
                }
                all.add(desc);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            }
            catch (CoreException coreException) {}
        }
        EGLCompletionProposalComputerRegistry eGLCompletionProposalComputerRegistry = this;
        synchronized (eGLCompletionProposalComputerRegistry) {
            this.fCategories.clear();
            this.fCategories.addAll(categories);
            Set partitions = map.keySet();
            this.fDescriptorsByPartition.keySet().retainAll(partitions);
            this.fPublicDescriptorsByPartition.keySet().retainAll(partitions);
            for (String partition : partitions) {
                List old = (List)this.fDescriptorsByPartition.get(partition);
                List current = (List)map.get(partition);
                if (old != null) {
                    old.clear();
                    old.addAll(current);
                    continue;
                }
                this.fDescriptorsByPartition.put(partition, current);
                this.fPublicDescriptorsByPartition.put(partition, Collections.unmodifiableList(current));
            }
            this.fDescriptors.clear();
            this.fDescriptors.addAll(all);
        }
    }

    boolean hasUninstalledComputers(String partition, List included) {
        return this.fHasUninstalledComputers;
    }

    private List getCategories(List elements) {
        IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
        String preference = store.getString("content_assist_disabled_categories");
        HashSet<String> disabled = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(preference, "\u0000");
        while (tok.hasMoreTokens()) {
            disabled.add(tok.nextToken());
        }
        HashMap<String, Integer> ordered = new HashMap<String, Integer>();
        preference = store.getString("content_assist_category_order");
        tok = new StringTokenizer(preference, "\u0000");
        while (tok.hasMoreTokens()) {
            StringTokenizer inner = new StringTokenizer(tok.nextToken(), ":");
            String id = inner.nextToken();
            int rank = Integer.parseInt(inner.nextToken());
            ordered.put(id, new Integer(rank));
        }
        EGLCompletionProposalCategory allProposals = null;
        ArrayList<EGLCompletionProposalCategory> categories = new ArrayList<EGLCompletionProposalCategory>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            try {
                boolean separate;
                if (!element.getName().equals("proposalCategory")) continue;
                iter.remove();
                EGLCompletionProposalCategory category = new EGLCompletionProposalCategory(element, this);
                categories.add(category);
                category.setIncluded(!disabled.contains(category.getId()));
                Integer rank = (Integer)ordered.get(category.getId());
                if (rank == null) continue;
                int r = rank;
                boolean bl = separate = r < 65535;
                if (!separate) {
                    r -= 65535;
                }
                category.setSeparateCommand(separate);
                category.setSortOrder(r);
            }
            catch (InvalidRegistryObjectException x) {
                Object[] args = new Object[]{element.toString()};
                String message = Messages.format(EGLTextMessages.CompletionProposalComputerRegistry_invalid_message, args);
                Status status = new Status(2, EDTUIPlugin.getPluginId(), 0, message, (Throwable)x);
                this.informUser((IStatus)status);
            }
            catch (CoreException x) {
                this.informUser(x.getStatus());
            }
        }
        this.preventDuplicateCategories(store, disabled, allProposals);
        return categories;
    }

    private void preventDuplicateCategories(IPreferenceStore store, Set disabled, EGLCompletionProposalCategory allProposals) {
        if (allProposals == null || !allProposals.isIncluded()) {
            return;
        }
        StringBuffer buf = new StringBuffer(50 * disabled.size());
        Iterator iter = disabled.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            buf.append('\u0000');
        }
        store.putValue("content_assist_disabled_computers", buf.toString());
    }

    void resetUnistalledComputers() {
        this.fHasUninstalledComputers = false;
    }

    private void informUser(IStatus status) {
        EDTUIPlugin.log(status);
        String title = EGLTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        String message = status.getMessage();
        MessageDialog.openError((Shell)EDTUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    void informUser(EGLCompletionProposalComputerDescriptor descriptor, IStatus status) {
        EDTUIPlugin.log(status);
        String title = EGLTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        EGLCompletionProposalCategory category = descriptor.getCategory();
        IContributor culprit = descriptor.getContributor();
        Set affectedPlugins = this.getAffectedContributors(category, culprit);
        String culpritName = culprit == null ? null : culprit.getName();
        final String avoidHint = affectedPlugins.isEmpty() ? Messages.format(EGLTextMessages.CompletionProposalComputerRegistry_messageAvoidanceHint, new Object[]{culpritName, category.getDisplayName()}) : Messages.format(EGLTextMessages.CompletionProposalComputerRegistry_messageAvoidanceHintWithWarning, new Object[]{culpritName, category.getDisplayName(), this.toString(affectedPlugins)});
        String message = status.getMessage();
        MessageDialog dialog = new MessageDialog(EDTUIPlugin.getActiveWorkbenchShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createCustomArea(Composite parent) {
                Link link = new Link(parent, 0);
                link.setText(avoidHint);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.edt.ide.ui.ContentAssistAdvancedPreferences", null, null).open();
                    }
                });
                GridData gridData = new GridData(4, 1, true, false);
                gridData.widthHint = this.getMinimumMessageWidth();
                link.setLayoutData((Object)gridData);
                return link;
            }
        };
        dialog.open();
    }

    private Set getAffectedContributors(EGLCompletionProposalCategory category, IContributor culprit) {
        HashSet<String> affectedPlugins = new HashSet<String>();
        for (EGLCompletionProposalComputerDescriptor desc : this.getProposalComputerDescriptors()) {
            IContributor contributor;
            EGLCompletionProposalCategory cat = desc.getCategory();
            if (!cat.equals(category) || (contributor = desc.getContributor()) == null || culprit.equals(contributor)) continue;
            affectedPlugins.add(contributor.getName());
        }
        return affectedPlugins;
    }

    private Object toString(Collection collection) {
        String string = collection.toString();
        return string.substring(1, string.length() - 1);
    }
}

