/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.edt.compiler.internal.util.Encoder;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.deployment.ui.WebBindingDetailPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SQLDatabaseBindingDetailPage
extends WebBindingDetailPage
implements IProfileListener1 {
    private static final int indent = 20;
    private Binding fSQLDatabaseBinding;
    private Button fUseWorkspace;
    private Button fUseDefinedInfo;
    private Button fDeployAsJndi;
    private Button fApplicationAuth;
    private Button btnPing;
    private Combo workspaceCombo;
    private Text fDeployAsJndiName;
    private Text fDbms;
    private Text fSqlDB;
    private Text fUserId;
    private Text fSqlJDBCDriverClass;
    private Text fSqlPassword;
    private Text fDefaultSchema;
    private Text fConnLocation;
    private List<Control> workspaceControls;
    private List<Control> definedControls;
    private List<Control> deployAsJndiControls;
    private String nonExistantProfile;

    public SQLDatabaseBindingDetailPage() {
        this.nColumnSpan = 3;
        this.workspaceControls = new ArrayList<Control>();
        this.definedControls = new ArrayList<Control>();
        this.deployAsJndiControls = new ArrayList<Control>();
    }

    @Override
    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, SOAMessages.SQLDatabaseBindingDetailSecTitle, SOAMessages.SQLDatabaseBindingDetailSecDescp, sectionStyle, columnSpan);
    }

    @Override
    protected void createDetailControls(FormToolkit toolkit, Composite parent) {
        this.createWorkspaceControls(toolkit, parent);
        this.createSQLControls(toolkit, parent);
        this.createDeployAsJNDIControls(toolkit, parent);
        ProfileManager.getInstance().addProfileListener((IProfileListener)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        ProfileManager.getInstance().removeProfileListener((IProfileListener)this);
    }

    private void createWorkspaceControls(FormToolkit toolkit, Composite parent) {
        this.workspaceControls.clear();
        this.fUseWorkspace = toolkit.createButton(parent, SOAMessages.LabelSqlUseWorkspace, 16);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        this.fUseWorkspace.setLayoutData((Object)gd);
        this.fUseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.workspaceUriSelected();
                SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUseURI(true);
                SQLDatabaseBindingDetailPage.this.setWorkspaceUriInModel();
            }
        });
        this.workspaceCombo = new Combo(parent, 12);
        toolkit.adapt((Composite)this.workspaceCombo);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan - 1;
        gd.horizontalIndent = 20;
        this.workspaceCombo.setLayoutData((Object)gd);
        this.workspaceControls.add((Control)this.workspaceCombo);
        this.workspaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.setWorkspaceUriInModel();
            }
        });
        Button newConnection = toolkit.createButton(parent, SOAMessages.NewLabel, 8);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalIndent = 20;
        newConnection.setLayoutData((Object)gd);
        this.workspaceControls.add((Control)newConnection);
        newConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnectionProfile newProfile = EGLSQLUtility.createNewProfile();
                if (newProfile != null) {
                    SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUri("workspace://" + newProfile.getName());
                    SQLDatabaseBindingDetailPage.this.updateCombo();
                }
            }
        });
        this.createSpacer(toolkit, parent, this.nColumnSpan);
    }

    private void createSQLControls(FormToolkit toolkit, Composite parent) {
        this.definedControls.clear();
        this.fUseDefinedInfo = toolkit.createButton(parent, SOAMessages.SqlDatabaseBindingSpecifyInfoLabel, 16);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        this.fUseDefinedInfo.setLayoutData((Object)gd);
        this.fUseDefinedInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.userDefinedSelected();
                SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUseURI(false);
            }
        });
        Label l = toolkit.createLabel(parent, SOAMessages.LabelDbms);
        this.definedControls.add((Control)l);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.fDbms = this.createTextControl(toolkit, parent);
        this.fDbms.setEditable(false);
        this.fDbms.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "dbms", SQLDatabaseBindingDetailPage.this.fDbms.getText());
            }
        });
        this.definedControls.add((Control)this.fDbms);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlJDBCDriverClass);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fSqlJDBCDriverClass = this.createTextControl(toolkit, parent);
        this.fSqlJDBCDriverClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlJDBCDriverClass", SQLDatabaseBindingDetailPage.this.fSqlJDBCDriverClass.getText());
            }
        });
        this.definedControls.add((Control)this.fSqlJDBCDriverClass);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlValidationConnectionURL);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fSqlDB = this.createTextControl(toolkit, parent);
        this.fSqlDB.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlDB", SQLDatabaseBindingDetailPage.this.fSqlDB.getText());
            }
        });
        this.definedControls.add((Control)this.fSqlDB);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlID);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fUserId = this.createTextControl(toolkit, parent);
        this.fUserId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlID", SQLDatabaseBindingDetailPage.this.fUserId.getText());
            }
        });
        this.definedControls.add((Control)this.fUserId);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlPassword);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fSqlPassword = this.createTextControl(toolkit, parent);
        this.fSqlPassword.setEchoChar('*');
        this.fSqlPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlPassword", Encoder.encode((String)SQLDatabaseBindingDetailPage.this.fSqlPassword.getText()));
            }
        });
        this.definedControls.add((Control)this.fSqlPassword);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlSchema);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fDefaultSchema = this.createTextControl(toolkit, parent);
        this.fDefaultSchema.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlSchema", SQLDatabaseBindingDetailPage.this.fDefaultSchema.getText());
            }
        });
        this.definedControls.add((Control)this.fDefaultSchema);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlJarLists);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fConnLocation = this.createTextControl(toolkit, parent);
        this.fConnLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "jarList", SQLDatabaseBindingDetailPage.this.fConnLocation.getText());
            }
        });
        this.definedControls.add((Control)this.fConnLocation);
        this.btnPing = new Button(parent, 0);
        this.btnPing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.testConnection();
            }
        });
        GridData pingGD = new GridData(896);
        pingGD.horizontalSpan = 3;
        this.btnPing.setLayoutData((Object)pingGD);
        this.btnPing.setText(SOAMessages.SQLDatabaseBindingDetailPageTestConnection);
        this.definedControls.add((Control)this.btnPing);
        this.createSpacer(toolkit, parent, this.nColumnSpan);
    }

    private void createDeployAsJNDIControls(FormToolkit toolkit, Composite parent) {
        this.deployAsJndiControls.clear();
        this.fDeployAsJndi = toolkit.createButton(parent, SOAMessages.LabelSqlDeployAsJndi, 96);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        this.fDeployAsJndi.setLayoutData((Object)gd);
        this.fDeployAsJndi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.updateDeployAsControls();
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "deployAsJndi", SQLDatabaseBindingDetailPage.this.fDeployAsJndi.getSelection());
            }
        });
        Label l = toolkit.createLabel(parent, SOAMessages.LabelSqlDeployAsJndiDesc);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.deployAsJndiControls.add((Control)l);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlJndiName);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.deployAsJndiControls.add((Control)l);
        this.fDeployAsJndiName = this.createTextControl(toolkit, parent);
        this.fDeployAsJndiName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "jndiName", SQLDatabaseBindingDetailPage.this.fDeployAsJndiName.getText());
            }
        });
        this.deployAsJndiControls.add((Control)this.fDeployAsJndiName);
        this.fApplicationAuth = toolkit.createButton(parent, SOAMessages.LabelSqlJndiAppAuth, 96);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        gd.horizontalIndent = 20;
        this.fApplicationAuth.setLayoutData((Object)gd);
        this.fApplicationAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.updateDeployAsControls();
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "jndiApplicationAuth", SQLDatabaseBindingDetailPage.this.fApplicationAuth.getSelection());
            }
        });
        this.deployAsJndiControls.add((Control)this.fApplicationAuth);
    }

    protected void testConnection() {
        String vendorName = this.fDbms.getText();
        String profileProviderID = null;
        if (vendorName != null && vendorName.length() > 0) {
            profileProviderID = EGLSQLUtility.getConnectionProviderProfile((String)vendorName);
        }
        if (profileProviderID != null) {
            String profileDescription = "";
            String parentProfile = "";
            boolean isAutoConnect = false;
            ConnectionProfile profile = new ConnectionProfile(vendorName, profileDescription, profileProviderID, parentProfile, isAutoConnect);
            profile.setBaseProperties(this.getConnectionProfileProperties());
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)this.createTestConnectionRunnable((IConnectionProfile)profile));
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SOAMessages.SQLDataBaseBindingTestConnectionNoVendorTitle, (String)NLS.bind((String)SOAMessages.SQLDataBaseBindingTestConnectionNoVendorMsg, (Object)(vendorName == null ? "" : vendorName)));
        }
    }

    private Properties getConnectionProfileProperties() {
        Properties copy = new Properties();
        copy.put("org.eclipse.datatools.connectivity.db.connectionProperties", "");
        copy.put("org.eclipse.datatools.connectivity.db.savePWD", (Object)false);
        if (this.fConnLocation.getText() != null) {
            copy.put("jarList", this.fConnLocation.getText().trim());
        }
        copy.put("org.eclipse.datatools.connectivity.db.username", this.fUserId.getText());
        copy.put("org.eclipse.datatools.connectivity.db.password", this.fSqlPassword.getText());
        copy.put("org.eclipse.datatools.connectivity.db.driverClass", this.fSqlJDBCDriverClass.getText());
        if (this.fSqlDB.getText() != null) {
            copy.put("org.eclipse.datatools.connectivity.db.URL", this.fSqlDB.getText().trim());
        }
        return copy;
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        PingJob pingJob = new PingJob(Display.getCurrent().getActiveShell(), profile);
        pingJob.schedule();
        return new Runnable((Job)pingJob){
            private final /* synthetic */ Job val$pingJob;
            {
                this.val$pingJob = job;
            }

            @Override
            public void run() {
                try {
                    this.val$pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fSQLDatabaseBinding = ssel.size() == 1 ? (Binding)ssel.getFirstElement() : null;
        this.update();
    }

    @Override
    protected void update() {
        this.fNameText.setText(this.fSQLDatabaseBinding.getName() == null ? "" : this.fSQLDatabaseBinding.getName());
        Parameters params = this.fSQLDatabaseBinding.getParameters();
        if (params != null) {
            String jndiName;
            String jarLists;
            String sqlpassword;
            String sqljdbcdriver;
            String sqlid;
            String sqldb;
            String dbms = EGLDDRootHelper.getParameterValue(params, "dbms");
            if (dbms != null) {
                this.fDbms.setText(dbms);
            }
            if ((sqldb = EGLDDRootHelper.getParameterValue(params, "sqlDB")) != null) {
                this.fSqlDB.setText(sqldb);
            }
            if ((sqlid = EGLDDRootHelper.getParameterValue(params, "sqlID")) != null) {
                this.fUserId.setText(sqlid);
            }
            if ((sqljdbcdriver = EGLDDRootHelper.getParameterValue(params, "sqlJDBCDriverClass")) != null) {
                this.fSqlJDBCDriverClass.setText(sqljdbcdriver);
            }
            if ((sqlpassword = EGLDDRootHelper.getParameterValue(params, "sqlPassword")) != null && sqlpassword.trim().length() > 0 && Encoder.isEncoded((String)sqlpassword)) {
                this.fSqlPassword.setText(Encoder.decode((String)sqlpassword));
            } else if (sqlpassword != null) {
                this.fSqlPassword.setText(sqlpassword);
            }
            String sqlschema = EGLDDRootHelper.getParameterValue(params, "sqlSchema");
            if (sqlschema != null) {
                this.fDefaultSchema.setText(sqlschema);
            }
            if ((jarLists = EGLDDRootHelper.getParameterValue(params, "jarList")) != null) {
                this.fConnLocation.setText(jarLists);
            }
            if ((jndiName = EGLDDRootHelper.getParameterValue(params, "jndiName")) != null) {
                this.fDeployAsJndiName.setText(jndiName);
            }
            this.fDeployAsJndi.setSelection(EGLDDRootHelper.getBooleanParameterValue(params, "deployAsJndi"));
            this.fApplicationAuth.setSelection(EGLDDRootHelper.getBooleanParameterValue(params, "jndiApplicationAuth"));
        }
        this.updateDeployAsControls();
        String uri = this.fSQLDatabaseBinding.getUri();
        if (uri != null && uri.startsWith("workspace://") && this.fSQLDatabaseBinding.isUseURI()) {
            this.fUseWorkspace.setSelection(true);
            this.workspaceUriSelected();
        }
        if (!this.fSQLDatabaseBinding.isUseURI()) {
            this.fUseDefinedInfo.setSelection(true);
            this.userDefinedSelected();
        }
        this.updateCombo();
    }

    @Override
    protected void HandleNameChanged() {
        this.fSQLDatabaseBinding.setName(this.fNameText.getText());
        this.refreshMainTableViewer();
    }

    protected void setWorkspaceUriInModel() {
        String selection = this.workspaceCombo.getText();
        if (this.nonExistantProfile != null && selection.equals(NLS.bind((String)SOAMessages.SqlConnectionProfileDoesntExist, (Object)this.nonExistantProfile))) {
            selection = this.nonExistantProfile;
        }
        this.fSQLDatabaseBinding.setUri("workspace://" + selection);
    }

    protected void updateCombo() {
        this.nonExistantProfile = null;
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        ArrayList<String> names = new ArrayList<String>(profiles.length + 1);
        int i = 0;
        while (i < profiles.length) {
            names.add(profiles[i].getName());
            ++i;
        }
        int selectionIndex = -1;
        String nameToSelect = null;
        String uri = this.fSQLDatabaseBinding.getUri();
        if (uri != null && uri.startsWith("workspace://")) {
            nameToSelect = uri.substring(12);
        }
        if (nameToSelect != null) {
            int i2 = 0;
            while (i2 < names.size()) {
                if (nameToSelect.equals(names.get(i2))) {
                    selectionIndex = i2;
                    break;
                }
                ++i2;
            }
            if (selectionIndex == -1) {
                this.nonExistantProfile = nameToSelect;
                names.add(NLS.bind((String)SOAMessages.SqlConnectionProfileDoesntExist, (Object)nameToSelect));
                selectionIndex = names.size() - 1;
            }
        }
        this.workspaceCombo.setItems(names.toArray(new String[names.size()]));
        if (selectionIndex > -1) {
            this.workspaceCombo.select(selectionIndex);
        } else if (names.size() > 0) {
            this.workspaceCombo.select(0);
        }
    }

    private void updateDeployAsControls() {
        boolean state = this.fDeployAsJndi.getSelection() && this.fDeployAsJndi.getEnabled();
        for (Control c : this.deployAsJndiControls) {
            c.setEnabled(state);
        }
    }

    private void workspaceUriSelected() {
        for (Control c : this.definedControls) {
            c.setEnabled(false);
        }
        for (Control c : this.workspaceControls) {
            c.setEnabled(true);
        }
        this.fDeployAsJndi.setEnabled(true);
        this.updateDeployAsControls();
    }

    private void userDefinedSelected() {
        for (Control c : this.definedControls) {
            c.setEnabled(true);
        }
        for (Control c : this.workspaceControls) {
            c.setEnabled(false);
        }
        this.fDeployAsJndi.setEnabled(true);
        this.updateDeployAsControls();
    }

    public void profileAdded(IConnectionProfile profile) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SQLDatabaseBindingDetailPage.this.updateCombo();
            }
        });
    }

    public void profileDeleted(IConnectionProfile profile) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SQLDatabaseBindingDetailPage.this.updateCombo();
            }
        });
    }

    public void profileChanged(IConnectionProfile profile) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SQLDatabaseBindingDetailPage.this.updateCombo();
            }
        });
    }

    public void profileChanged(final IConnectionProfile profile, final String oldName, String oldDesc, Boolean oldAutoConnect) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String name;
                String uri = SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.getUri();
                if (uri != null && uri.startsWith("workspace://") && (name = uri.substring(12)).equals(oldName)) {
                    SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUri("workspace://" + profile.getName());
                }
                SQLDatabaseBindingDetailPage.this.updateCombo();
            }
        });
    }
}

