/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.MoveProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.edt.ide.ui.internal.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReorgMoveWizard
extends RefactoringWizard {
    public ReorgMoveWizard(MoveRefactoring ref) {
        super((Refactoring)ref, 4 | ReorgMoveWizard.computeHasPreviewPage(ref));
        if (ReorgMoveWizard.isTextualMove(ref)) {
            this.setDefaultPageTitle(UINlsStrings.ReorgMoveWizard_textual_move);
        } else {
            this.setDefaultPageTitle(UINlsStrings.ReorgMoveWizard_3);
        }
    }

    private static boolean isTextualMove(MoveRefactoring ref) {
        MoveProcessor moveProcessor = (MoveProcessor)ref.getAdapter(MoveProcessor.class);
        return moveProcessor.isTextualMove();
    }

    private static int computeHasPreviewPage(MoveRefactoring refactoring) {
        MoveProcessor processor = (MoveProcessor)refactoring.getAdapter(MoveProcessor.class);
        if (processor.canUpdateReferences()) {
            return 0;
        }
        return 16;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage());
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private Button fReferenceCheckbox;
        private ICreateTargetQuery fCreateTargetQuery;
        private Object fDestination;

        public MoveInputPage() {
            super(PAGE_NAME);
        }

        private MoveProcessor getEGLMoveProcessor() {
            return (MoveProcessor)this.getRefactoring().getAdapter(MoveProcessor.class);
        }

        @Override
        protected Object getInitiallySelectedElement() {
            return this.getEGLMoveProcessor().getCommonParentForInputElements();
        }

        @Override
        protected IEGLElement[] getEGLElements() {
            return this.getEGLMoveProcessor().getEGLElements();
        }

        @Override
        protected IResource[] getResources() {
            return this.getEGLMoveProcessor().getResources();
        }

        @Override
        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getEGLMoveProcessor();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getEGLMoveProcessor().wasCanceled();
        }

        @Override
        protected RefactoringStatus verifyDestination(Object selected) throws EGLModelException {
            MoveProcessor processor = this.getEGLMoveProcessor();
            RefactoringStatus refactoringStatus = selected instanceof IPackageFragment || selected instanceof IPackageFragmentRoot || selected instanceof IEGLFile ? processor.setDestination((IEGLElement)selected) : RefactoringStatus.createFatalErrorStatus((String)UINlsStrings.ReorgMoveWizard_4);
            this.updateUIStatus();
            this.fDestination = selected;
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setForcePreviewReview(false);
            MoveProcessor processor = this.getEGLMoveProcessor();
            if (this.fReferenceCheckbox != null) {
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                processor.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite result) {
            final MoveProcessor processor = this.getEGLMoveProcessor();
            if (!processor.canUpdateReferences()) {
                return;
            }
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(UINlsStrings.MoveAction_update_references);
            this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    processor.setUpdateReferences(((Button)e.widget).getSelection());
                    MoveInputPage.this.updateUIStatus();
                }
            });
        }

        @Override
        public void createControl(Composite parent) {
            Composite result;
            boolean showDestinationTree;
            boolean bl = showDestinationTree = !this.getEGLMoveProcessor().hasDestinationSet();
            if (showDestinationTree) {
                this.fCreateTargetQuery = this.getEGLMoveProcessor().getCreateTargetQuery();
                super.createControl(parent);
                this.getTreeViewer().getTree().setFocus();
                result = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)parent);
                result = new Composite(parent, 0);
                this.setControl((Control)result);
                result.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)result);
            }
            this.addUpdateReferenceComponent(result);
            this.setControl((Control)result);
            Dialog.applyDialogFont((Control)result);
        }

        @Override
        protected Control addLabel(Composite parent) {
            if (this.fCreateTargetQuery != null) {
                Composite firstLine = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                firstLine.setLayout((Layout)layout);
                firstLine.setLayoutData((Object)new GridData(768));
                Control label = super.addLabel(firstLine);
                label.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 128 && e.doit) {
                            e.detail = 0;
                            MoveInputPage.this.getTreeViewer().getTree().setFocus();
                        }
                    }
                });
                Button newButton = new Button(firstLine, 8);
                newButton.setText(this.fCreateTargetQuery.getNewButtonLabel());
                GridData gd = new GridData(642);
                gd.widthHint = SWTUtil.getButtonWidthHint(newButton);
                newButton.setLayoutData((Object)gd);
                newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MoveInputPage.this.doNewButtonPressed();
                    }
                });
                return firstLine;
            }
            return super.addLabel(parent);
        }

        private boolean canUpdateReferences() {
            return this.getEGLMoveProcessor().canUpdateReferences();
        }

        private void doNewButtonPressed() {
            Object newElement = this.fCreateTargetQuery.getCreatedTarget(this.fDestination);
            if (newElement != null) {
                TreeViewer viewer = this.getTreeViewer();
                ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
                viewer.refresh(contentProvider.getParent(newElement));
                viewer.setSelection((ISelection)new StructuredSelection(newElement), true);
                viewer.getTree().setFocus();
            }
        }
    }
}

