/*
 * Decompiled with CFR 0.152.
 */
package eglx.json;

import com.ibm.icu.text.SimpleDateFormat;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.StringLib;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.json.ArrayNode;
import org.eclipse.edt.javart.json.BooleanNode;
import org.eclipse.edt.javart.json.DecimalNode;
import org.eclipse.edt.javart.json.FloatingPointNode;
import org.eclipse.edt.javart.json.IntegerNode;
import org.eclipse.edt.javart.json.Json;
import org.eclipse.edt.javart.json.JsonParser;
import org.eclipse.edt.javart.json.NameValuePairNode;
import org.eclipse.edt.javart.json.NullNode;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.ParseException;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.json.ValueNode;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.runtime.java.eglx.lang.AnyValue;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EBoolean;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.EList;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETime;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;
import org.eclipse.edt.runtime.java.eglx.lang.NullType;

public class JsonLib {
    public static String convertToJSON(Object obj) {
        return JsonLib.process(obj).toJson();
    }

    public static String convertToJSON(Response response) {
        EDictionary httpResponse = new EDictionary();
        httpResponse.put("headers", response.getHeaders());
        httpResponse.put("body", (Object)response.body);
        httpResponse.put("status", (Object)response.status);
        httpResponse.put("statusMessage", (Object)response.statusMessage);
        return JsonLib.process(httpResponse).toJson();
    }

    public static ValueNode convertToJsonNode(Object obj) {
        return JsonLib.process(obj);
    }

    private static ValueNode process(Object object) throws AnyException {
        if (object == null) {
            return new NullNode();
        }
        if (object instanceof AnyBoxedObject && ((AnyBoxedObject)object).ezeUnbox() == null) {
            return new NullNode();
        }
        if (object instanceof EDate) {
            return new StringNode(StringLib.format((Calendar)((Calendar)((EDate)object).ezeUnbox()), (String)"yyyy-MM-dd"), false);
        }
        if (object instanceof ETime) {
            return new StringNode(StringLib.format((Calendar)((Calendar)((ETime)object).ezeUnbox()), (String)"HH:mm:ss"), false);
        }
        if (object instanceof ETimestamp) {
            return new StringNode(StringLib.format((Calendar)((Calendar)((ETimestamp)object).ezeUnbox()), (String)"yyyy-MM-dd HH:mm:ss"), false);
        }
        if (object instanceof AnyBoxedObject) {
            return JsonLib.process(((AnyBoxedObject)object).ezeUnbox());
        }
        if (object instanceof BigDecimal) {
            return new DecimalNode((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new IntegerNode((BigInteger)object);
        }
        if (object instanceof Byte) {
            return new IntegerNode(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return new IntegerNode((Short)object);
        }
        if (object instanceof Integer) {
            return new IntegerNode((Integer)object);
        }
        if (object instanceof Long) {
            return new IntegerNode((Long)object);
        }
        if (object instanceof Boolean) {
            return new BooleanNode((Boolean)object);
        }
        if (object instanceof Double) {
            return new FloatingPointNode((Double)object);
        }
        if (object instanceof Float) {
            return new FloatingPointNode((Float)object);
        }
        if (object instanceof String) {
            return new StringNode((String)object, false);
        }
        if (object instanceof Enum) {
            return new IntegerNode(((Enum)object).ordinal() + 1);
        }
        if (object instanceof Calendar) {
            return JsonLib.process((Calendar)object);
        }
        if (object instanceof List) {
            return JsonLib.process((List)object);
        }
        if (object instanceof EDictionary) {
            return JsonLib.process((EDictionary)object);
        }
        if (object instanceof AnyValue) {
            return JsonLib.processObject(object);
        }
        if (object instanceof Map) {
            return JsonLib.process((Map)object);
        }
        if (object instanceof ExecutableBase) {
            return JsonLib.processObject(object);
        }
        if (object instanceof AnyException) {
            return JsonLib.processObject(object);
        }
        InvalidArgumentException ex = new InvalidArgumentException();
        throw ex.fillInMessage("EGL0005E", new Object[]{object.getClass().getName()});
    }

    private static ValueNode process(List<?> array) throws AnyException {
        ArrayNode node = new ArrayNode();
        for (Object object : array) {
            node.addValue(JsonLib.process(object));
        }
        return node;
    }

    private static ValueNode process(Calendar calendar) throws AnyException {
        String format = null;
        format = calendar.isSet(11) || calendar.isSet(12) || calendar.isSet(13) || calendar.isSet(14) ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
        return new StringNode(StringLib.format((Calendar)calendar, (String)format), false);
    }

    private static ValueNode process(EDictionary dictionary) throws AnyException {
        ObjectNode objectNode = new ObjectNode();
        String[] contents = dictionary.getKeyArray();
        int i = 0;
        while (i < contents.length) {
            objectNode.addPair(new NameValuePairNode(new StringNode(contents[i], false), JsonLib.process(dictionary.get((Object)contents[i]))));
            ++i;
        }
        return objectNode;
    }

    private static ValueNode process(Map<Object, Object> map) throws AnyException {
        ObjectNode objectNode = new ObjectNode();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            objectNode.addPair(new NameValuePairNode(new StringNode(entry.getKey() == null || entry.getKey().toString() == null ? "" : entry.getKey().toString(), false), JsonLib.process(entry.getValue())));
        }
        return objectNode;
    }

    private static ValueNode processObject(Object object) throws AnyException {
        ObjectNode objectNode = new ObjectNode();
        for (Field field : JsonLib.getFields(object.getClass())) {
            String name = field.getName();
            try {
                Json annot = field.getAnnotation(Json.class);
                if (annot != null) {
                    name = annot.name();
                }
                StringBuilder getterName = new StringBuilder(field.getName().substring(0, 1).toUpperCase());
                getterName.append(field.getName().substring(1));
                Method method = null;
                try {
                    method = object.getClass().getMethod("get" + getterName, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method == null) {
                    try {
                        method = object.getClass().getMethod("is" + getterName, null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                Class<?> type = null;
                String[] asOptions = null;
                if (method != null && Modifier.isPublic(method.getModifiers())) {
                    annot = method.getAnnotation(Json.class);
                    if (annot != null) {
                        name = annot.name();
                        type = annot.clazz();
                        asOptions = annot.asOptions();
                    }
                    objectNode.addPair(new NameValuePairNode(new StringNode(name, false), JsonLib.process(JsonUtilities.wrapCalendar(method.invoke(object, null), type, asOptions))));
                    continue;
                }
                if (!Modifier.isPublic(field.getModifiers())) continue;
                annot = field.getAnnotation(Json.class);
                if (annot != null) {
                    name = annot.name();
                    type = annot.clazz();
                    asOptions = annot.asOptions();
                }
                objectNode.addPair(new NameValuePairNode(new StringNode(name, false), JsonLib.process(JsonUtilities.wrapCalendar(field.get(object), type, asOptions))));
            }
            catch (Throwable t) {
                InvalidArgumentException ex = new InvalidArgumentException();
                ex.initCause(t);
                throw ex.fillInMessage("EGL0020E", new Object[]{name, object.getClass().getName()});
            }
        }
        return objectNode;
    }

    public static void convertFromJSON(String jsonString, Object obj) throws AnyException {
        try {
            JsonLib.convertToEgl(obj, JsonParser.parseValue(jsonString));
        }
        catch (ParseException e) {
            InvalidArgumentException ex = new InvalidArgumentException();
            ex.initCause((Throwable)e);
            throw ex.fillInMessage("EGL0021E", new Object[]{obj, jsonString});
        }
    }

    public static Object convertToEgl(ValueNode jsonValue) throws AnyException {
        return JsonLib.convertToEgl(null, jsonValue);
    }

    public static Object convertToEgl(Object object, ValueNode jsonValue) throws AnyException {
        if (object instanceof AnyBoxedObject) {
            JsonLib.convertToEgl(((AnyBoxedObject)object).ezeUnbox(), jsonValue);
        } else if (object instanceof ExecutableBase && jsonValue instanceof ObjectNode) {
            JsonLib.convertObject(object, (ObjectNode)jsonValue);
        } else if (object instanceof AnyValue && jsonValue instanceof ObjectNode) {
            JsonLib.convertObject(object, (ObjectNode)jsonValue);
        } else if (object instanceof EDictionary && jsonValue instanceof ObjectNode) {
            ((EDictionary)object).removeAll();
            JsonLib.convertObject((EDictionary)object, (ObjectNode)jsonValue);
        } else if (object == null && jsonValue instanceof ObjectNode) {
            JsonLib.convertObject(new EDictionary(), (ObjectNode)jsonValue);
        } else if (jsonValue instanceof NullNode) {
            object = null;
        }
        return object;
    }

    static Object convertToEgl(Class<?> fieldType, String[] fieldTypeOptions, Object field, ValueNode jsonValue) throws AnyException {
        block29: {
            if (!(jsonValue instanceof NullNode)) break block29;
            return null;
        }
        try {
            if (jsonValue instanceof ArrayNode) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object node : ((ArrayNode)jsonValue).getValues()) {
                    list.add(JsonLib.convertToEgl(fieldType, fieldTypeOptions, null, (ValueNode)node));
                }
                return list;
            }
            if (fieldType.equals(EBigint.class)) {
                return EBigint.asBigint((String)jsonValue.toJava());
            }
            if (fieldType.equals(EBoolean.class) && jsonValue instanceof BooleanNode) {
                return ((BooleanNode)jsonValue).getValue();
            }
            if (fieldType.equals(EDate.class)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Calendar cal = DateTimeUtil.getBaseCalendar();
                cal.setTimeInMillis(sdf.parse(jsonValue.toJava()).getTime());
                cal.get(1);
                return EDate.asDate((Calendar)cal);
            }
            if (fieldType.equals(EDecimal.class)) {
                if (fieldTypeOptions != null && fieldTypeOptions.length > 0) {
                    int length = Integer.parseInt(fieldTypeOptions[0]);
                    int decimal = 0;
                    if (fieldTypeOptions.length > 1) {
                        decimal = Integer.parseInt(fieldTypeOptions[1]);
                    }
                    return EDecimal.asDecimal((String)jsonValue.toJava(), (Integer[])new Integer[]{length, decimal});
                }
                return EDecimal.asDecimal((String)jsonValue.toJava(), (Integer[])new Integer[0]);
            }
            if (fieldType.equals(EFloat.class)) {
                return EFloat.asFloat((String)jsonValue.toJava());
            }
            if (fieldType.equals(EInt.class)) {
                return EInt.asInt((String)jsonValue.toJava());
            }
            if (fieldType.equals(ESmallfloat.class)) {
                return ESmallfloat.asSmallfloat((String)jsonValue.toJava());
            }
            if (fieldType.equals(ESmallint.class)) {
                return ESmallint.asSmallint((String)jsonValue.toJava());
            }
            if (fieldType.equals(EString.class)) {
                if (fieldTypeOptions != null && fieldTypeOptions.length == 1) {
                    int length = Integer.parseInt(fieldTypeOptions[0]);
                    return EString.asString((String)jsonValue.toJava(), (Integer[])new Integer[]{length});
                }
                return jsonValue.toJava();
            }
            if (fieldType.equals(ETime.class)) {
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                Calendar cal = DateTimeUtil.getBaseCalendar();
                cal.setTimeInMillis(sdf.parse(jsonValue.toJava()).getTime());
                cal.get(1);
                return ETime.asTime((Calendar)cal);
            }
            if (fieldType.equals(ETimestamp.class)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar cal = DateTimeUtil.getBaseCalendar();
                cal.setTimeInMillis(sdf.parse(jsonValue.toJava()).getTime());
                cal.get(1);
                int start = 0;
                int end = 5;
                if (fieldTypeOptions != null && fieldTypeOptions.length > 1) {
                    start = JsonUtilities.getETimestampStaticField(fieldTypeOptions[0]);
                    end = JsonUtilities.getETimestampStaticField(fieldTypeOptions[1]);
                }
                return ETimestamp.asTimestamp((Calendar)cal, (int)start, (int)end);
            }
            if (AnyValue.class.isAssignableFrom(fieldType) && jsonValue instanceof ObjectNode) {
                AnyValue anyValue = field instanceof AnyValue ? (AnyValue)field : (AnyValue)fieldType.newInstance();
                return JsonLib.convertObject(anyValue, (ObjectNode)jsonValue);
            }
            if (ExecutableBase.class.isAssignableFrom(fieldType) && jsonValue instanceof ObjectNode) {
                ExecutableBase base = field instanceof ExecutableBase ? (ExecutableBase)field : (ExecutableBase)fieldType.newInstance();
                return JsonLib.convertObject(base, (ObjectNode)jsonValue);
            }
            if (fieldType.isEnum() && jsonValue instanceof IntegerNode) {
                ?[] objArray = fieldType.getEnumConstants();
                int n = objArray.length;
                int cal = 0;
                while (cal < n) {
                    Object enumConstant = objArray[cal];
                    if (enumConstant instanceof Enum) {
                        int value;
                        try {
                            Method method = fieldType.getMethod("getValue", null);
                            value = (Integer)method.invoke(enumConstant, null);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            value = ((Enum)enumConstant).ordinal() + 1;
                        }
                        if (((IntegerNode)jsonValue).getBigIntegerValue().intValue() == value) {
                            return enumConstant;
                        }
                    }
                    ++cal;
                }
            }
            if (jsonValue instanceof ObjectNode) {
                EDictionary dict = field instanceof EDictionary ? (EDictionary)field : new EDictionary();
                JsonLib.convertObject(dict, (ObjectNode)jsonValue);
                return dict;
            }
        }
        catch (Throwable t) {
            InvalidArgumentException ex = new InvalidArgumentException();
            ex.initCause(t);
            throw ex.fillInMessage("EGL0021E", new Object[]{field, jsonValue});
        }
        InvalidArgumentException ex = new InvalidArgumentException();
        throw ex.fillInMessage("EGL0021E", new Object[]{field, jsonValue});
    }

    private static EDictionary convertObject(EDictionary dictionary, ObjectNode objectNode) throws AnyException {
        for (Object pair : objectNode.getPairs()) {
            dictionary.put(((NameValuePairNode)pair).getName().getJavaValue(), JsonLib.convertJsonNode(((NameValuePairNode)pair).getValue()));
        }
        return dictionary;
    }

    private static Object convertJsonNode(ValueNode jsonValue) {
        Object retVal = null;
        if (jsonValue instanceof ArrayNode) {
            retVal = new ArrayList();
            for (Object node : ((ArrayNode)jsonValue).getValues()) {
                ((List)retVal).add(JsonLib.convertJsonNode((ValueNode)node));
            }
            retVal = EList.ezeBox((List)((List)retVal), (String)"eglx.lang.EList<eglx.lang.EAny>");
        } else if (jsonValue instanceof BooleanNode) {
            retVal = EBoolean.ezeBox((Boolean)((BooleanNode)jsonValue).getValue());
        } else if (jsonValue instanceof DecimalNode) {
            retVal = EDecimal.ezeBox((BigDecimal)EDecimal.asDecimal((String)jsonValue.toJava(), (Integer[])new Integer[0]));
        } else if (jsonValue instanceof FloatingPointNode) {
            retVal = EFloat.ezeBox((Double)EFloat.asFloat((String)jsonValue.toJava()));
        } else if (jsonValue instanceof IntegerNode) {
            retVal = EDecimal.ezeBox((BigDecimal)EDecimal.asDecimal((String)jsonValue.toJava(), (Integer[])new Integer[0]));
        } else {
            if (jsonValue instanceof NullNode) {
                return NullType.ezeWrap(null);
            }
            if (jsonValue instanceof ObjectNode) {
                retVal = JsonLib.convertToEgl(EDictionary.class, null, null, jsonValue);
            } else if (jsonValue instanceof StringNode) {
                retVal = EString.ezeBox((String)jsonValue.toJava());
            }
        }
        if (!(retVal instanceof eglx.lang.EAny)) {
            retVal = EAny.ezeBox((Object)retVal);
        }
        return retVal;
    }

    private static Object convertObject(Object object, ObjectNode objectNode) throws AnyException {
        for (Field field : JsonLib.getFields(object.getClass())) {
            String name = field.getName();
            try {
                Json jsonAnnotation = field.getAnnotation(Json.class);
                if (jsonAnnotation != null) {
                    name = jsonAnnotation.name();
                }
                StringBuilder setterName = new StringBuilder(field.getName().substring(0, 1).toUpperCase());
                setterName.append(field.getName().substring(1));
                Method setMethod = null;
                try {
                    setMethod = object.getClass().getMethod("set" + setterName, field.getType());
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                Method getMethod = null;
                try {
                    getMethod = object.getClass().getMethod("get" + setterName, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (getMethod == null) {
                    try {
                        getMethod = object.getClass().getMethod("is" + setterName, null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                Object existingFieldObject = null;
                if (getMethod != null && Modifier.isPublic(getMethod.getModifiers())) {
                    if (getMethod.getAnnotation(Json.class) != null) {
                        jsonAnnotation = getMethod.getAnnotation(Json.class);
                        name = jsonAnnotation.name();
                    }
                    existingFieldObject = getMethod.invoke(object, null);
                } else if (Modifier.isPublic(field.getModifiers())) {
                    existingFieldObject = field.get(object);
                }
                if (jsonAnnotation == null || (getMethod == null || !Modifier.isPublic(getMethod.getModifiers())) && !Modifier.isPublic(field.getModifiers())) continue;
                Object newEglValue = JsonLib.convertToEgl(jsonAnnotation.clazz(), jsonAnnotation.asOptions(), existingFieldObject, org.eclipse.edt.javart.json.JsonUtilities.getValueNode(objectNode, name));
                if (setMethod != null && Modifier.isPublic(setMethod.getModifiers())) {
                    setMethod.invoke(object, newEglValue);
                    continue;
                }
                if (!Modifier.isPublic(field.getModifiers())) continue;
                field.set(object, newEglValue);
            }
            catch (Throwable t) {
                InvalidArgumentException ex = new InvalidArgumentException();
                ex.initCause(t);
                throw ex.fillInMessage("EGL0020E", new Object[]{name, object.getClass().getName()});
            }
        }
        return object;
    }

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while (eglx.lang.EAny.class.isAssignableFrom(clazz = clazz.getSuperclass()) || Executable.class.isAssignableFrom(clazz));
        return fields;
    }
}

