/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLValue;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPUtil;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.core.java.variables.VariableUtil;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;

public class EGLJavaValue
extends EGLJavaDebugElement
implements IEGLJavaValue {
    protected final IJavaValue javaValue;
    protected final IEGLJavaVariable parentVariable;
    protected IVariable[] children;
    private String smap;
    private SMAPVariableInfo[] smapVariableInfos;

    public EGLJavaValue(IDebugTarget target, IJavaValue value, IEGLJavaVariable parent) {
        super(target);
        this.javaValue = value;
        this.parentVariable = parent;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IValue.class || adapter == EGLJavaValue.class || adapter == IEGLValue.class || adapter == IEGLJavaValue.class) {
            return this;
        }
        if (adapter == IJavaValue.class) {
            return this.javaValue;
        }
        return super.getAdapter(adapter);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.parentVariable.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        return this.javaValue.getValueString();
    }

    public boolean isAllocated() throws DebugException {
        return this.javaValue.isAllocated();
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.children != null) {
            return this.children;
        }
        if (this.getSMAP().length() == 0) {
            this.children = this.javaValue.getVariables();
        } else {
            List<IEGLJavaVariable> newEGLVariables = VariableUtil.filterAndWrapVariables(this.javaValue.getVariables(), this.parentVariable.getEGLStackFrame(), false, this);
            this.children = newEGLVariables.toArray(new EGLJavaVariable[newEGLVariables.size()]);
        }
        return this.children;
    }

    public boolean hasVariables() throws DebugException {
        return this.javaValue.hasVariables() && this.getVariables().length != 0;
    }

    @Override
    public Object getJavaDebugElement() {
        return this.javaValue;
    }

    @Override
    public IJavaValue getJavaValue() {
        return this.javaValue;
    }

    public String getSMAP() throws DebugException {
        if (this.smap == null) {
            this.smap = SMAPUtil.getSMAP((IEGLJavaDebugTarget)this.getEGLJavaDebugTarget(), this.javaValue.getJavaType());
        }
        return this.smap;
    }

    @Override
    public SMAPVariableInfo[] getSMAPVariableInfos() throws DebugException {
        if (this.smapVariableInfos == null) {
            this.smapVariableInfos = SMAPUtil.parseVariables(this.getSMAP(), null);
            IJavaType type = this.javaValue.getJavaType();
            while (type instanceof IJavaClassType) {
                SMAPVariableInfo[] superInfos;
                String superSMAP;
                IJavaClassType superType = ((IJavaClassType)type).getSuperclass();
                if (superType != null && (superSMAP = SMAPUtil.getSMAP((IEGLJavaDebugTarget)this.getEGLJavaDebugTarget(), (IJavaType)superType)).length() != 0 && (superInfos = SMAPUtil.parseVariables(superSMAP, null)).length != 0) {
                    if (this.smapVariableInfos.length == 0) {
                        this.smapVariableInfos = superInfos;
                    } else {
                        SMAPVariableInfo[] newInfos = new SMAPVariableInfo[this.smapVariableInfos.length + superInfos.length];
                        System.arraycopy(this.smapVariableInfos, 0, newInfos, 0, this.smapVariableInfos.length);
                        System.arraycopy(superInfos, 0, newInfos, this.smapVariableInfos.length, superInfos.length);
                        this.smapVariableInfos = newInfos;
                    }
                }
                type = superType;
            }
        }
        return this.smapVariableInfos;
    }

    @Override
    public String computeDetail() {
        return null;
    }

    @Override
    public IEGLJavaVariable getParentVariable() {
        return this.parentVariable;
    }

    @Override
    protected boolean shouldCheckJavaElementAdapter() {
        try {
            return !SMAPUtil.isEGLStratum(this.getSMAP());
        }
        catch (DebugException debugException) {
            return true;
        }
    }
}

