/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.WrapperedZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.partinfo.EGLFileOrigin;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class WorkingCopyProjectInfo
extends AbstractProjectInfo {
    private HashMap<String, HashMap<String, WorkingCopyProjectInfoEntry>> packageMap = new HashMap();

    public WorkingCopyProjectInfo(IProject project) {
        super(project);
    }

    @Override
    public IPartOrigin getPartOrigin(String packageName, String partName) {
        WorkingCopyProjectInfoEntry entry;
        HashMap<String, WorkingCopyProjectInfoEntry> partMap = this.packageMap.get(packageName);
        if (partMap != null && (entry = partMap.get(partName)) != null) {
            return new EGLFileOrigin(entry.file);
        }
        IPartOrigin partOrigin = super.getPartOrigin(packageName, partName);
        if (partOrigin == null || partOrigin.getEGLFile() == null) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry) {
                    Environment.pushEnv((IEnvironment)((WrapperedZipFileBuildPathEntry)pathEntry).getIREnviornment());
                    IPartOrigin zipPartOrigin = ((WrapperedZipFileBuildPathEntry)pathEntry).getPartOrigin(packageName, partName);
                    Environment.popEnv();
                    if (zipPartOrigin != null) {
                        return zipPartOrigin;
                    }
                }
                ++n2;
            }
        }
        return partOrigin;
    }

    @Override
    public boolean hasPackage(String packageName) {
        boolean hasPackage = super.hasPackage(packageName);
        if (!hasPackage) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry && pathEntry.hasPackage(packageName)) {
                    return true;
                }
                ++n2;
            }
        }
        return hasPackage;
    }

    @Override
    public int hasPart(String packageName, String partName) {
        WorkingCopyProjectInfoEntry entry;
        HashMap<String, WorkingCopyProjectInfoEntry> partMap = this.packageMap.get(packageName);
        if (partMap != null && (entry = partMap.get(partName)) != null) {
            if (entry.entryType != 1) {
                return entry.partType;
            }
            return 1;
        }
        int partType = super.hasPart(packageName, partName);
        if (partType == 1) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry && 1 != (partType = pathEntry.hasPart(packageName, partName))) break;
                ++n2;
            }
        }
        return partType;
    }

    private void recordEntry(String packageName, String partName, WorkingCopyProjectInfoEntry entry) {
        HashMap<String, WorkingCopyProjectInfoEntry> partMap = this.packageMap.get(packageName);
        if (partMap == null) {
            partMap = new HashMap();
            this.packageMap.put(packageName, partMap);
        }
        partMap.put(partName, entry);
    }

    @Override
    public void clear() {
        super.clear();
        this.packageMap.clear();
    }

    public void resetWorkingCopies() {
        this.packageMap.clear();
    }

    @Override
    protected IFileInfo getCachedFileInfo(IProject project, IPath projectRelativePath) {
        return WorkingCopyFileInfoManager.getInstance().getFileInfo(project, projectRelativePath);
    }

    @Override
    public String getCaseSensitivePartName(String packageName, String partName) {
        PackageAndPartName ppName = this.getPackageAndPartName(packageName, partName);
        if (ppName != null) {
            return ppName.getCaseSensitivePartName();
        }
        return null;
    }

    @Override
    public PackageAndPartName getPackageAndPartName(String packageName, String partName) {
        WorkingCopyProjectInfoEntry entry;
        HashMap<String, WorkingCopyProjectInfoEntry> partMap = this.packageMap.get(packageName);
        if (partMap != null && (entry = partMap.get(partName)) != null) {
            return entry.ppName;
        }
        PackageAndPartName ppName = super.getPackageAndPartName(packageName, partName);
        if (ppName == null) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry) {
                    try {
                        Part part = pathEntry.findPart(packageName, partName);
                        if (part != null) {
                            ppName = new PackageAndPartName(part.getCaseSensitivePackageName(), part.getCaseSensitiveName());
                        } else {
                            String fileExtension;
                            int index = partName.lastIndexOf(".");
                            if (index > -1 && "egl".equalsIgnoreCase(fileExtension = partName.substring(index + 1))) {
                                ppName = new PackageAndPartName(packageName, partName);
                            }
                        }
                        if (ppName != null) {
                            return ppName;
                        }
                    }
                    catch (PartNotFoundException partNotFoundException) {}
                }
                ++n2;
            }
        }
        return ppName;
    }

    @Override
    protected IContainer[] getSourceLocations(IProject project) {
        return WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project).getSourceLocations();
    }

    public void workingCopyPartAdded(String packageName, String partName, int partType, IFile file, PackageAndPartName ppName) {
        this.recordEntry(packageName, partName, new WorkingCopyProjectInfoEntry(partType, file, 2, ppName));
    }

    public void workingCopyPartRemoved(String packageName, String partName, int partType, IFile file, PackageAndPartName ppName) {
        this.recordEntry(packageName, partName, new WorkingCopyProjectInfoEntry(partType, file, 1, ppName));
    }

    public void workingCopyPartChanged(String packageName, String partName, int partType, IFile file, PackageAndPartName ppName) {
        this.recordEntry(packageName, partName, new WorkingCopyProjectInfoEntry(partType, file, 0, ppName));
    }

    private class WorkingCopyProjectInfoEntry {
        public static final int CHANGE = 0;
        public static final int REMOVAL = 1;
        public static final int ADDITION = 2;
        private int partType;
        private IFile file;
        private int entryType;
        private PackageAndPartName ppName;

        public WorkingCopyProjectInfoEntry(int partType, IFile file, int entryType, PackageAndPartName ppName) {
            this.partType = partType;
            this.file = file;
            this.entryType = entryType;
            this.ppName = ppName;
        }
    }
}

