/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLProject;

public class EGLElementDelta
implements IEGLElementDelta {
    protected IEGLElement fChangedElement;
    private int fKind = 0;
    private int fChangeFlags = 0;
    protected IEGLElementDelta[] fAffectedChildren = fgEmptyDelta;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IEGLElement fMovedFromHandle = null;
    protected IEGLElement fMovedToHandle = null;
    protected static IEGLElementDelta[] fgEmptyDelta = new IEGLElementDelta[0];

    public EGLElementDelta(IEGLElement element) {
        this.fChangedElement = element;
    }

    protected void addAffectedChild(EGLElementDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 8;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 8;
            }
        }
        if (this.fChangedElement.getElementType() >= 6) {
            this.fineGrained();
        }
        if (this.fAffectedChildren.length == 0) {
            this.fAffectedChildren = new IEGLElementDelta[]{child};
            return;
        }
        IEGLElementDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.fAffectedChildren != null) {
            int i = 0;
            while (i < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                    existingChild = this.fAffectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.fAffectedChildren = this.growAndAddToArray(this.fAffectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.fKind = 4;
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            IEGLElementDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                EGLElementDelta childsChild = (EGLElementDelta)children[i];
                                ((EGLElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            switch (((EGLElementDelta)existingChild).fChangeFlags) {
                                case 64: 
                                case 128: {
                                    ((EGLElementDelta)existingChild).fChangeFlags |= child.fChangeFlags;
                                }
                            }
                            IResourceDelta[] resDeltas = child.getResourceDeltas();
                            if (resDeltas != null) {
                                ((EGLElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((EGLElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.fAffectedChildren[existingChildIndex] = child;
                    child.fChangeFlags |= flags;
                }
            }
        }
    }

    public void added(IEGLElement element) {
        EGLElementDelta addedDelta = new EGLElementDelta(element);
        addedDelta.fKind = 1;
        this.insertDeltaTree(element, addedDelta);
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 1;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    public void changed(IEGLElement element, int changeFlag) {
        EGLElementDelta changedDelta = new EGLElementDelta(element);
        changedDelta.fKind = 4;
        changedDelta.fChangeFlags |= changeFlag;
        this.insertDeltaTree(element, changedDelta);
    }

    public void contentChanged() {
        this.fChangeFlags |= 1;
    }

    public IEGLElementDelta clone(IEGLProject project) {
        EGLElementDelta clone = new EGLElementDelta(((EGLElement)this.fChangedElement).rootedAt(project));
        if (this.fAffectedChildren != fgEmptyDelta) {
            int length = this.fAffectedChildren.length;
            IEGLElementDelta[] cloneChildren = new IEGLElementDelta[length];
            int i = 0;
            while (i < length) {
                cloneChildren[i] = ((EGLElementDelta)this.fAffectedChildren[i]).clone(project);
                ++i;
            }
            clone.fAffectedChildren = cloneChildren;
        }
        clone.fChangeFlags = this.fChangeFlags;
        clone.fKind = this.fKind;
        if (this.fMovedFromHandle != null) {
            clone.fMovedFromHandle = ((EGLElement)this.fMovedFromHandle).rootedAt(project);
        }
        if (this.fMovedToHandle != null) {
            clone.fMovedToHandle = ((EGLElement)this.fMovedToHandle).rootedAt(project);
        }
        clone.resourceDeltas = this.resourceDeltas;
        clone.resourceDeltasCounter = this.resourceDeltasCounter;
        return clone;
    }

    public void closed(IEGLElement element) {
        EGLElementDelta delta = new EGLElementDelta(element);
        delta.fKind = 4;
        delta.fChangeFlags |= 0x400;
        this.insertDeltaTree(element, delta);
    }

    protected EGLElementDelta createDeltaTree(IEGLElement element, EGLElementDelta delta) {
        EGLElementDelta childDelta = delta;
        ArrayList ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.fKind = delta.fKind;
                this.fChangeFlags = delta.fChangeFlags;
                this.fMovedToHandle = delta.fMovedToHandle;
                this.fMovedFromHandle = delta.fMovedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IEGLElement ancestor = (IEGLElement)ancestors.get(i);
                EGLElementDelta ancestorDelta = new EGLElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected boolean equalsAndSameParent(IEGLElement e1, IEGLElement e2) {
        IEGLElement parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    protected EGLElementDelta find(IEGLElement e) {
        if (this.equalsAndSameParent(this.fChangedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.fAffectedChildren.length) {
            EGLElementDelta delta = ((EGLElementDelta)this.fAffectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void fineGrained() {
        if (this.fKind == 0) {
            this.fKind = 4;
        }
        this.fChangeFlags |= 0x4000;
    }

    @Override
    public IEGLElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    @Override
    public IEGLElementDelta[] getAffectedChildren() {
        return this.fAffectedChildren;
    }

    private ArrayList getAncestors(IEGLElement element) {
        IEGLElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IEGLElement> parents = new ArrayList<IEGLElement>();
        while (!parent.equals(this.fChangedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    @Override
    public IEGLElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected IEGLElementDelta[] getChildrenOfType(int type) {
        int length = this.fAffectedChildren.length;
        if (length == 0) {
            return new IEGLElementDelta[0];
        }
        ArrayList<IEGLElementDelta> children = new ArrayList<IEGLElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.fAffectedChildren[i].getKind() == type) {
                children.add(this.fAffectedChildren[i]);
            }
            ++i;
        }
        IEGLElementDelta[] childrenOfType = new IEGLElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    public EGLElementDelta getDeltaFor(IEGLElement element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.fAffectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.fAffectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            EGLElementDelta delta = (EGLElementDelta)this.fAffectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IEGLElement getElement() {
        return this.fChangedElement;
    }

    @Override
    public int getFlags() {
        return this.fChangeFlags;
    }

    @Override
    public int getKind() {
        return this.fKind;
    }

    @Override
    public IEGLElement getMovedFromElement() {
        return this.fMovedFromHandle;
    }

    @Override
    public IEGLElement getMovedToElement() {
        return this.fMovedToHandle;
    }

    @Override
    public IEGLElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected IEGLElementDelta[] growAndAddToArray(IEGLElementDelta[] array, IEGLElementDelta addition) {
        IEGLElementDelta[] old = array;
        array = new IEGLElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected void insertDeltaTree(IEGLElement element, EGLElementDelta delta) {
        EGLElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    public void movedFrom(IEGLElement movedFromElement, IEGLElement movedToElement) {
        EGLElementDelta removedDelta = new EGLElementDelta(movedFromElement);
        removedDelta.fKind = 2;
        removedDelta.fChangeFlags |= 0x20;
        removedDelta.fMovedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(IEGLElement movedToElement, IEGLElement movedFromElement) {
        EGLElementDelta addedDelta = new EGLElementDelta(movedToElement);
        addedDelta.fKind = 1;
        addedDelta.fChangeFlags |= 0x10;
        addedDelta.fMovedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    public void opened(IEGLElement element) {
        EGLElementDelta delta = new EGLElementDelta(element);
        delta.fKind = 4;
        delta.fChangeFlags |= 0x200;
        this.insertDeltaTree(element, delta);
    }

    protected void removeAffectedChild(EGLElementDelta child) {
        int index = -1;
        if (this.fAffectedChildren != null) {
            int i = 0;
            while (i < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, index);
        }
    }

    protected IEGLElementDelta[] removeAndShrinkArray(IEGLElementDelta[] old, int index) {
        int rest;
        IEGLElementDelta[] array = new IEGLElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void removed(IEGLElement element) {
        EGLElementDelta removedDelta = new EGLElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        EGLElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.fKind = 2;
            actualDelta.fChangeFlags = 0;
            actualDelta.fAffectedChildren = fgEmptyDelta;
        }
    }

    public void sourceAttached(IEGLElement element) {
        EGLElementDelta attachedDelta = new EGLElementDelta(element);
        attachedDelta.fKind = 4;
        attachedDelta.fChangeFlags |= 0x1000;
        this.insertDeltaTree(element, attachedDelta);
    }

    public void sourceDetached(IEGLElement element) {
        EGLElementDelta detachedDelta = new EGLElementDelta(element);
        detachedDelta.fKind = 4;
        detachedDelta.fChangeFlags |= 0x2000;
        this.insertDeltaTree(element, detachedDelta);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((EGLElement)this.getElement()).toDebugString());
        buffer.append("[");
        switch (this.getKind()) {
            case 1: {
                buffer.append('+');
                break;
            }
            case 2: {
                buffer.append('-');
                break;
            }
            case 4: {
                buffer.append('*');
                break;
            }
            default: {
                buffer.append('?');
            }
        }
        buffer.append("]: {");
        int changeFlags = this.getFlags();
        boolean prev = false;
        if ((changeFlags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((changeFlags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((changeFlags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((EGLElement)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((changeFlags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((EGLElement)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((changeFlags & 0x40) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ADDED TO CLASSPATH");
            prev = true;
        }
        if ((changeFlags & 0x80) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REMOVED FROM CLASSPATH");
            prev = true;
        }
        if ((changeFlags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((changeFlags & 0x8000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ARCHIVE CONTENT CHANGED");
            prev = true;
        }
        if ((changeFlags & 2) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MODIFIERS CHANGED");
            prev = true;
        }
        if ((changeFlags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        buffer.append("}");
        IEGLElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((EGLElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toDebugString(0);
    }
}

