/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.nls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.ide.rui.internal.nls.ILocaleConstants;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocalesList;

public class LocaleUtility {
    private static String[] descriptionArray = null;
    public static HashMap DEFAULT_HANDLER_LOCALE_CODES = new HashMap();
    public static HashMap DEFAULT_RUNTIME_LOCALE_CODES;
    public static HashMap DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES;

    static {
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_English, "en_US");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Arabic_Egypt, "ar_EG");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Arabic_Saudi_Arabia, "ar_SA");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Brazilian, "pt_BR");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Chinese_Simplified, "zh_CN");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Chinese_Taiwan, "zh_TW");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Chinese_Hong_Kong, "zh_HK");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Czech, "cs_CZ");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_French, "fr_FR");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_German, "de_DE");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Hungarian, "hu_HU");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Italian, "it_IT");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Japanese, "ja_JP");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Korean, "ko_KR");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Polish, "pl_PL");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Russian, "ru_RU");
        DEFAULT_HANDLER_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Spanish, "es_ES");
        DEFAULT_RUNTIME_LOCALE_CODES = new HashMap();
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_English, "en_US");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Arabic, "ar");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Brazilian, "pt_BR");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Chinese_Simplified, "zh");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Chinese_Taiwan, "zh_TW");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Chinese_Hong_Kong, "zh_HK");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Czech, "cs");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_French, "fr");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_German, "de");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Hungarian, "hu");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Italian, "it");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Japanese, "ja");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Korean, "ko");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Polish, "pl");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Russian, "ru");
        DEFAULT_RUNTIME_LOCALE_CODES.put(ILocaleConstants.Locale_Description_Spanish, "es");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES = new HashMap();
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("en_US", "en_US");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("ar_EG", "ar");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("ar_SA", "ar");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("pt_BR", "pt_BR");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("zh_CN", "zh");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("zh_TW", "zh_TW");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("zh_HK", "zh_HK");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("cs_CZ", "cs");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("fr_FR", "fr");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("de_DE", "de");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("hu_HU", "hu");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("it_IT", "it");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("ja_JP", "ja");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("ko_KR", "ko");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("pl_PL", "pl");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("ru_RU", "ru");
        DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.put("es_ES", "es");
    }

    public static String getHandlerDescriptionForCode(String localeCode) {
        String result = "";
        for (Map.Entry entry : DEFAULT_HANDLER_LOCALE_CODES.entrySet()) {
            if (!entry.getValue().equals(localeCode)) continue;
            result = (String)entry.getKey();
        }
        return result;
    }

    public static String getRuntimeDescriptionForCode(String localeCode) {
        String result = "";
        for (Map.Entry entry : DEFAULT_RUNTIME_LOCALE_CODES.entrySet()) {
            if (!entry.getValue().equals(localeCode)) continue;
            result = (String)entry.getKey();
        }
        return result;
    }

    public static String getRuntimeCodeForDescription(String description) {
        return (String)DEFAULT_RUNTIME_LOCALE_CODES.get(description);
    }

    public static String getDefaultRuntimeCodeForHandlerCode(String handlerCode) {
        return (String)DEFAULT_HANDLER_CODES_TO_RUNTIME_CODES.get(handlerCode);
    }

    public static String[] getRuntimeDescriptionsArray() {
        if (descriptionArray == null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            for (Map.Entry mapEntry : DEFAULT_RUNTIME_LOCALE_CODES.entrySet()) {
                String description = (String)mapEntry.getKey();
                descriptions.add(description);
            }
            descriptionArray = descriptions.toArray(new String[descriptions.size()]);
            Arrays.sort(descriptionArray);
        }
        return descriptionArray;
    }

    public static final String getWorkbenchLocale() {
        return System.getProperty("osgi.nl");
    }

    public static final Locale getDefaultHandlerLocale() {
        return LocaleUtility.getDefaultLocale(LocalesList.getLocalesList().getLocales());
    }

    public static final Locale getDefaultRuntimeLocale() {
        ArrayList<Locale> localesList = new ArrayList<Locale>();
        for (Map.Entry mapEntry : DEFAULT_RUNTIME_LOCALE_CODES.entrySet()) {
            Locale locale = new Locale((String)mapEntry.getValue(), (String)mapEntry.getKey(), (String)mapEntry.getValue());
            localesList.add(locale);
        }
        return LocaleUtility.getDefaultLocale(localesList);
    }

    private static final Locale getDefaultLocale(List searchList) {
        String workbench_locale;
        Locale bestMatch = null;
        Locale exactMatch = null;
        Locale englishLocale = null;
        String best_match_search = workbench_locale = LocaleUtility.getWorkbenchLocale();
        if (workbench_locale.length() > 1) {
            best_match_search = workbench_locale.substring(0, 2);
        }
        Iterator iterator = searchList.iterator();
        while (iterator.hasNext() && exactMatch == null) {
            Locale locale = (Locale)iterator.next();
            if (locale.getCode().equals("en_US")) {
                englishLocale = locale;
            }
            if (locale.getCode().equals(workbench_locale)) {
                exactMatch = locale;
                continue;
            }
            if (workbench_locale.equals("zh") && locale.getCode().equals("zh_CN") || workbench_locale.equals("zh_CN") && locale.getCode().equals("zh")) {
                exactMatch = locale;
                continue;
            }
            if (!locale.getCode().startsWith(best_match_search)) continue;
            bestMatch = locale;
        }
        if (exactMatch != null) {
            return exactMatch;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        if (englishLocale != null) {
            return englishLocale;
        }
        if (searchList.size() > 0) {
            return (Locale)searchList.get(0);
        }
        return new Locale("en_US", ILocaleConstants.Locale_Description_English, "en_US");
    }
}

