/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.ui.IContainmentAdapter;

public class EGLElementContainmentAdapter
implements IContainmentAdapter {
    private IEGLModel fEGLModel = EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    public boolean contains(Object workingSetElement, Object element, int flags) {
        if (!(workingSetElement instanceof IEGLElement) || element == null) {
            return false;
        }
        IEGLElement workingSetEGLElement = (IEGLElement)workingSetElement;
        IResource resource = null;
        IEGLElement jElement = null;
        if (element instanceof IEGLElement) {
            jElement = (IEGLElement)element;
        } else if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null && this.fEGLModel.contains(resource) && (jElement = EGLCore.create((IResource)resource)) != null && !jElement.exists()) {
            jElement = null;
        }
        if (jElement != null) {
            if (this.contains(workingSetEGLElement, jElement, flags)) {
                return true;
            }
            if (workingSetEGLElement.getElementType() == 4 && resource.getType() == 2 && this.checkIfDescendant(flags)) {
                return this.isChild(workingSetEGLElement, resource);
            }
        } else if (resource != null) {
            return this.contains(workingSetEGLElement, resource, flags);
        }
        return false;
    }

    private boolean contains(IEGLElement workingSetElement, IEGLElement element, int flags) {
        if (this.checkContext(flags) && workingSetElement.equals(element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetElement.equals(element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    private boolean check(IEGLElement ancestor, IEGLElement descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals(descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean isChild(IEGLElement workingSetElement, IResource element) {
        IResource resource = workingSetElement.getResource();
        if (resource == null) {
            return false;
        }
        return this.check(element, resource);
    }

    private boolean contains(IEGLElement workingSetElement, IResource element, int flags) {
        IResource workingSetResource = workingSetElement.getResource();
        if (workingSetResource == null) {
            return false;
        }
        if (this.checkContext(flags) && workingSetResource.equals((Object)element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetResource.equals((Object)element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetResource, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetResource);
    }

    private boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }

    private boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    private boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    private boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }
}

