/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInputFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class BinaryEditorInput
implements IStorageEditorInput,
IPersistableElement {
    private BinaryReadOnlyFile binaryReadOnlyFile;
    private IClassFile classFile;

    public BinaryEditorInput(BinaryReadOnlyFile binaryReadOnlyFile) {
        this.binaryReadOnlyFile = binaryReadOnlyFile;
    }

    public BinaryEditorInput(BinaryReadOnlyFile binaryReadOnlyFile, IClassFile classFile) {
        this.binaryReadOnlyFile = binaryReadOnlyFile;
        this.classFile = classFile;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.binaryReadOnlyFile.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public IStorage getStorage() {
        return this.binaryReadOnlyFile;
    }

    public String getToolTipText() {
        return "file: " + this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getSource() {
        return this.binaryReadOnlyFile.getSource();
    }

    public void setClassFile(IClassFile classFile) {
        this.classFile = classFile;
    }

    public IClassFile getClassFile() {
        if (this.classFile != null) {
            return this.classFile;
        }
        IProject proj = null;
        proj = this.binaryReadOnlyFile.getProject();
        if (proj == null) {
            return null;
        }
        IEGLProject eglProj = EGLCore.create((IProject)proj);
        try {
            String[] pkgName;
            EglarPackageFragmentRoot packageFragmentRoot;
            EglarPackageFragment packageFragment;
            IPackageFragmentRoot myRoot = eglProj.getPackageFragmentRoot(this.binaryReadOnlyFile.getFullPath().toString());
            if (myRoot instanceof EglarPackageFragmentRoot && myRoot.exists() && (packageFragment = (EglarPackageFragment)(packageFragmentRoot = (EglarPackageFragmentRoot)myRoot).getPackageFragment(pkgName = IRFileNameUtility.toIRFileName((String[])this.binaryReadOnlyFile.getPackageSegments()))) != null && packageFragment.exists()) {
                this.classFile = packageFragment.getClassFile(this.binaryReadOnlyFile.getIrName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.classFile;
    }

    public String getFullPath() {
        return this.binaryReadOnlyFile.getIrFullPathString();
    }

    public IProject getProject() {
        return this.binaryReadOnlyFile.getProject();
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryEditorInput) {
            return this.getFullPath().equals(((BinaryEditorInput)o).getFullPath()) && this.getProject().equals((Object)((BinaryEditorInput)o).getProject());
        }
        return super.equals(o);
    }

    public BinaryReadOnlyFile getBinaryReadOnlyFile() {
        return this.binaryReadOnlyFile;
    }

    public void saveState(IMemento memento) {
        BinaryEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return BinaryEditorInputFactory.getFactoryId();
    }
}

