/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.DeleteChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class DeleteProcessor
extends org.eclipse.ltk.core.refactoring.participants.DeleteProcessor {
    Object[] elements;
    Change deleteChange;

    public DeleteProcessor(Object[] elements) {
        this.elements = elements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        ArrayList<DeleteParticipant> result = new ArrayList<DeleteParticipant>();
        int i = 0;
        while (i < this.elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.elements[i], (DeleteArguments)new DeleteArguments(), (String[])this.getNatures(), (SharableParticipants)shared)));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private String[] getNatures() {
        return new String[]{"com.ibm.etools.egl.model.eglnature"};
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create((IStatus)DeleteProcessor.checkInSync(this.getResources())));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IResource[] getResources() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] instanceof IResource) {
                list.add(this.elements[i]);
            } else if (this.elements[i] instanceof IEGLElement) {
                list.add(((IEGLElement)this.elements[i]).getResource());
            }
            ++i;
        }
        return list.toArray(new IResource[list.size()]);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.deleteChange = new DeleteChange(this.elements);
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        pm.done();
        return this.deleteChange;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public String getIdentifier() {
        return "EGLDeleteProcessor";
    }

    public String getProcessorName() {
        return UINlsStrings.DeleteRefactoring_name;
    }

    public boolean isApplicable() throws CoreException {
        return this.elements != null && this.elements.length > 0;
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = DeleteProcessor.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, MessageFormat.format((String)UINlsStrings.Resources_outOfSync, (Object[])new String[]{resource.getFullPath().toString()}), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, UINlsStrings.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }
}

