/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.changes;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

abstract class ResourceReorgChange
extends Change {
    protected static final int NONE = 0;
    protected static final int READ_ONLY = 1;
    protected static final int DIRTY = 2;
    private static final int SAVE = 4;
    protected static final int SAVE_IF_DIRTY = 6;
    private long fModificationStamp;
    private boolean fReadOnly;
    private final IPath fResourcePath;
    private final boolean fIsFile;
    private final IPath fDestinationPath;
    private final boolean fIsDestinationProject;
    private final INewNameQuery fNewNameQuery;

    ResourceReorgChange(IResource res, IContainer dest, INewNameQuery nameQuery) {
        Assert.isTrue((res instanceof IFile || res instanceof IFolder ? 1 : 0) != 0);
        this.fIsFile = res instanceof IFile;
        this.fResourcePath = ResourceReorgChange.getResourcePath(res);
        Assert.isTrue((dest instanceof IProject || dest instanceof IFolder ? 1 : 0) != 0);
        this.fIsDestinationProject = dest instanceof IProject;
        this.fDestinationPath = ResourceReorgChange.getResourcePath((IResource)dest);
        this.fNewNameQuery = nameQuery;
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws CoreException;

    public final Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(this.getName(), 2);
            String newName = this.getNewResourceName();
            IResource resource = this.getResource();
            boolean performReorg = this.deleteIfAlreadyExists((IProgressMonitor)new SubProgressMonitor(pm, 1), newName);
            if (!performReorg) {
                return null;
            }
            Change result = this.doPerformReorg(this.getDestinationPath(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(resource);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    protected IPath getDestinationPath(String newName) {
        return this.getDestination().getFullPath().append(newName);
    }

    private boolean deleteIfAlreadyExists(IProgressMonitor pm, String newName) throws CoreException {
        pm.beginTask("", 1);
        IResource current = this.getDestination().findMember(newName);
        if (current == null) {
            return true;
        }
        if (!current.exists()) {
            return true;
        }
        IResource resource = this.getResource();
        Assert.isNotNull((Object)resource);
        if (ReorgUtils.areEqualInWorkspaceOrOnDisk(resource, current)) {
            return false;
        }
        if (current instanceof IFile) {
            ((IFile)current).delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else if (current instanceof IFolder) {
            ((IFolder)current).delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            Assert.isTrue((boolean)false);
        }
        return true;
    }

    private String getNewResourceName() {
        if (this.fNewNameQuery == null) {
            return this.getResource().getName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getResource().getName();
        }
        return name;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    private IFile getFile() {
        return ResourceReorgChange.getFile(this.fResourcePath);
    }

    private IFolder getFolder() {
        return ResourceReorgChange.getFolder(this.fResourcePath);
    }

    protected IResource getResource() {
        if (this.fIsFile) {
            return this.getFile();
        }
        return this.getFolder();
    }

    IContainer getDestination() {
        if (this.fIsDestinationProject) {
            return ResourceReorgChange.getProject(this.fDestinationPath);
        }
        return ResourceReorgChange.getFolder(this.fDestinationPath);
    }

    protected int getReorgFlags() {
        return 34;
    }

    private void markAsExecuted(IResource resource) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)resource);
        }
    }

    static IPath getResourcePath(IResource resource) {
        return resource.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    static IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    static IFolder getFolder(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
    }

    static IProject getProject(IPath path) {
        return (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(path);
    }

    public abstract String getName();

    public abstract Object getAdapter(Class var1);

    protected final RefactoringStatus isValid(IProgressMonitor pm, int flags) throws CoreException {
        pm.beginTask("", 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            Object modifiedElement = this.getModifiedElement();
            ResourceReorgChange.checkExistence(result, modifiedElement);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (flags == 0) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IResource resource = ResourceReorgChange.getResource(modifiedElement);
            if (resource != null) {
                ValidationState state = new ValidationState(resource);
                state.checkModificationStamp(result, this.fModificationStamp);
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                state.checkSameReadOnly(result, this.fReadOnly);
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                if ((flags & 1) != 0) {
                    state.checkReadOnly(result);
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                }
                if ((flags & 2) != 0) {
                    if ((flags & 4) != 0) {
                        state.checkDirty(result, this.fModificationStamp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    } else {
                        state.checkDirty(result);
                    }
                }
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected static void checkExistence(RefactoringStatus status, Object element) {
        if (element == null) {
            status.addFatalError(UINlsStrings.DynamicValidationStateChange_workspace_changed);
        } else if (element instanceof IResource && !((IResource)element).exists()) {
            status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_does_not_exist, (Object[])new String[]{((IResource)element).getFullPath().toString()}));
        } else if (element instanceof IEGLElement && !((IEGLElement)element).exists()) {
            status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_does_not_exist, (Object[])new String[]{((IEGLElement)element).getElementName()}));
        }
    }

    protected final RefactoringStatus isValid(int flags) throws CoreException {
        return this.isValid((IProgressMonitor)new NullProgressMonitor(), flags);
    }

    private static ITextFileBuffer getBuffer(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return manager.getTextFileBuffer(file.getFullPath());
    }

    private static IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IEGLFile) {
            return ((IEGLFile)element).getResource();
        }
        if (element instanceof IEGLElement) {
            return ((IEGLElement)element).getResource();
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }

    public static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    public long getModificationStamp(IResource resource) {
        if (!(resource instanceof IFile)) {
            return resource.getModificationStamp();
        }
        IFile file = (IFile)resource;
        ITextFileBuffer buffer = ResourceReorgChange.getBuffer(file);
        if (buffer == null) {
            return file.getModificationStamp();
        }
        IDocument document = buffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            return ((IDocumentExtension4)document).getModificationStamp();
        }
        return file.getModificationStamp();
    }

    public void initializeValidationData(IProgressMonitor pm) {
        IResource resource = ResourceReorgChange.getResource(this.getModifiedElement());
        if (resource != null) {
            this.fModificationStamp = this.getModificationStamp(resource);
            this.fReadOnly = ResourceReorgChange.isReadOnly(resource);
        }
    }

    private static class ValidationState {
        private IResource fResource;
        private int fKind;
        private boolean fDirty;
        private boolean fReadOnly;
        private long fModificationStamp;
        private ITextFileBuffer fTextFileBuffer;
        public static final int RESOURCE = 1;
        public static final int DOCUMENT = 2;

        public ValidationState(IResource resource) {
            this.fResource = resource;
            if (resource instanceof IFile) {
                this.initializeFile((IFile)resource);
            } else {
                this.initializeResource(resource);
            }
        }

        public void checkDirty(RefactoringStatus status, long stampToMatch, IProgressMonitor pm) throws CoreException {
            if (this.fDirty) {
                if (this.fKind == 2 && this.fTextFileBuffer != null && stampToMatch == this.fModificationStamp) {
                    this.fTextFileBuffer.commit(pm, false);
                } else {
                    status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_is_unsaved, (Object[])new String[]{this.fResource.getFullPath().toString()}));
                }
            }
        }

        public void checkDirty(RefactoringStatus status) {
            if (this.fDirty) {
                status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_is_unsaved, (Object[])new String[]{this.fResource.getFullPath().toString()}));
            }
        }

        public void checkReadOnly(RefactoringStatus status) {
            if (this.fReadOnly) {
                status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_is_read_only, (Object[])new String[]{this.fResource.getFullPath().toString()}));
            }
        }

        public void checkSameReadOnly(RefactoringStatus status, boolean valueToMatch) {
            if (this.fReadOnly != valueToMatch) {
                status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_same_read_only, (Object[])new String[]{this.fResource.getFullPath().toString()}));
            }
        }

        public void checkModificationStamp(RefactoringStatus status, long stampToMatch) {
            if (this.fKind == 2) {
                if (stampToMatch != -1L && this.fModificationStamp != stampToMatch) {
                    status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_has_modifications, (Object[])new String[]{this.fResource.getFullPath().toString()}));
                }
            } else if (stampToMatch != -1L && this.fModificationStamp != stampToMatch) {
                status.addFatalError(MessageFormat.format((String)UINlsStrings.Change_has_modifications, (Object[])new String[]{this.fResource.getFullPath().toString()}));
            }
        }

        private void initializeFile(IFile file) {
            this.fTextFileBuffer = ResourceReorgChange.getBuffer(file);
            if (this.fTextFileBuffer == null) {
                this.initializeResource((IResource)file);
            } else {
                IDocument document = this.fTextFileBuffer.getDocument();
                this.fDirty = this.fTextFileBuffer.isDirty();
                this.fReadOnly = ResourceReorgChange.isReadOnly((IResource)file);
                if (document instanceof IDocumentExtension4) {
                    this.fKind = 2;
                    this.fModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
                } else {
                    this.fKind = 1;
                    this.fModificationStamp = file.getModificationStamp();
                }
            }
        }

        private void initializeResource(IResource resource) {
            this.fKind = 1;
            this.fDirty = false;
            this.fReadOnly = ResourceReorgChange.isReadOnly(resource);
            this.fModificationStamp = resource.getModificationStamp();
        }
    }
}

