/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.eunit.templates.javascriptasync;

import java.util.List;
import org.eclipse.edt.gen.eunit.CommonUtilities;
import org.eclipse.edt.gen.eunit.Context;
import org.eclipse.edt.gen.eunit.TestCounter;
import org.eclipse.edt.gen.eunit.TestDriverTargetLanguageKind;
import org.eclipse.edt.gen.eunit.templates.EUnitTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Part;

public class LibraryTemplate
extends EUnitTemplate {
    public void preGenClassBody(Library part, Context ctx, TestCounter counter) {
        this.preGenFunctions(part, ctx, counter);
    }

    public void preGenFunctions(Library part, Context ctx, TestCounter counter) {
        this.collectTestFunctions(part, ctx, counter, TestDriverTargetLanguageKind.JAVASCRIPT);
    }

    public void genImports(Part part, Context ctx, TabbedWriter out) {
        out.println("import org.eclipse.edt.eunit.runtime.TestListMgr;");
        this.generateImportStatement(part, ctx, out);
    }

    public void genLibDriverImports(Library part, Context ctx, TabbedWriter out) {
        out.println("import org.eclipse.edt.eunit.runtime.TestListMgr;");
        out.println("import org.eclipse.edt.eunit.runtime.runTestMethod;");
        this.generateLibDriverImportStatements((Part)part, ctx, out);
    }

    public void genClassBody(Library part, Context ctx, TabbedWriter out, TestCounter counter) {
        out.println("library " + part.getName());
        out.pushIndent();
        out.println("function invokeTheTest()");
        out.pushIndent();
        out.println("runningTest();");
        out.popIndent();
        out.println("end");
        out.println();
        out.println("function runningTest()");
        out.pushIndent();
        out.println("//reset the test library name (TestDescription.name)");
        out.println("TestListMgr.testLibName = \"" + part.getName() + "\" + \"_\" + TestListMgr.getBindingTypeString(TestListMgr.bindingType);");
        List functions = (List)ctx.getAttribute(((Object)((Object)ctx)).getClass(), "partFunctionsWanted");
        out.println("//reset the list of test method names in this libary ");
        out.print("TestListMgr.testMethodNames = [");
        boolean flag2 = false;
        for (String function : functions) {
            if (flag2) {
                out.print(", ");
            }
            out.print("\"" + function + "\"");
            flag2 = true;
        }
        out.println("];");
        out.println("testVariationCnt int = TestListMgr.testMethodNames.getSize();");
        out.println();
        out.println("//reset the multiStatus in this library");
        out.println("TestListMgr.ms = new MultiStatus;");
        out.println("TestListMgr.ms.expectedCnt = testVariationCnt;");
        out.println();
        out.println("LogResult.clearResults();");
        out.println("//reset the list of tests in this libary ");
        out.println("TestListMgr.runTestMtds = new runTestMethod[];");
        for (String function : functions) {
            out.print("TestListMgr.runTestMtds ::= ");
            out.println(String.valueOf(part.getFullyQualifiedName()) + "." + function + ";");
        }
        out.println("TestListMgr.runTestMtds ::= endTest;");
        out.println();
        out.println("//reset the index back to 1");
        out.println("TestListMgr.testIndex = 1;");
        out.println("TestListMgr.runTestMtds[TestListMgr.testIndex]();");
        out.popIndent();
        out.println("end");
        out.println();
        out.println("function endTest()");
        out.pushIndent();
        out.println("td TestDescription;");
        out.println("td.expCnt = " + counter.getCount() + ";");
        out.println("td.rootDir = \"\";");
        out.println("td.pkgName = \"" + part.getPackageName() + "\";");
        out.println("td.name = \"" + part.getName() + "\";");
        out.println("td.title = \"\";");
        out.println("td.description = \"\";");
        out.print("td.testcases = \"");
        boolean flag1 = false;
        for (String function : functions) {
            if (flag1) {
                out.print(" ");
            }
            out.print(function);
            flag1 = true;
        }
        out.println("\";");
        out.println("td.sources = \"" + part.getName() + ".egl\";");
        out.println("td.keywords = \"\";");
        out.println("TestExecutionLib.writeResults(td, TestListMgr.ms, true);");
        out.println("TestListMgr.nextTestLibrary();");
        out.popIndent();
        out.println("end");
        out.popIndent();
        out.println("end");
    }

    public void genLibDriverClassBody(Library part, Context ctx, TabbedWriter out, String driverPartNameAppend, TestCounter counter) {
        String genedHandlerName = String.valueOf(part.getName()) + driverPartNameAppend;
        out.println("Handler " + genedHandlerName + " type RUIhandler {initialUI = [], includefile = \"rununit.html\", onConstructionFunction = start, title=\"" + genedHandlerName + "\"} ");
        out.pushIndent();
        out.println("startTS timestamp?;");
        out.println();
        out.println("function start()");
        out.pushIndent();
        out.println("ts timestamp(\"yyyyMMddHHmmssffffff\");");
        out.println("startTS = ts;");
        out.println("TestListMgr.bindingType = ServiceBindingType.DEDICATED;");
        out.println("TestListMgr.LibraryStartTests = new runTestMethod[];");
        out.println("TestListMgr.LibraryStartTests ::= " + CommonUtilities.getECKGenPartFQName((Part)part) + "." + "invokeTheTest" + ";");
        out.println("TestListMgr.LibraryStartTests ::= endTest;");
        out.println("TestListMgr.LibraryStartTests[1]();");
        out.popIndent();
        out.println("end");
        out.println();
        out.println("function endTest()");
        out.pushIndent();
        out.println("TestExecutionLib.writeResultSummary(" + counter.getCount() + ", startTS);");
        out.popIndent();
        out.println("end");
        out.popIndent();
        out.println("end");
    }
}

