/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.gen;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jpt.common.core.internal.gen.AbstractJptGenerator;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator
extends AbstractJptGenerator {
    public static String LAUNCH_CONFIG_NAME = "JAXB Schema Gen Run Config";
    public static String JAXB_SCHEMA_GEN_PACKAGE_NAME = "org.eclipse.jpt.jaxb.core.schemagen";
    public static String JAXB_SCHEMA_GEN_CLASS = String.valueOf(JAXB_SCHEMA_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_JAXB_SCHEMA_GEN_PACKAGE_NAME = "org.eclipse.jpt.jaxb.eclipselink.core.schemagen";
    public static String ECLIPSELINK_JAXB_SCHEMA_GEN_CLASS = String.valueOf(ECLIPSELINK_JAXB_SCHEMA_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_JAXB_CONTEXT_FACTORY = "org.eclipse.persistence.jaxb.JAXBContextFactory";
    public static String ECLIPSELINK_JAXB_PROPERTIES_FILE_CONTENTS = "javax.xml.bind.context.factory=" + ECLIPSELINK_JAXB_CONTEXT_FACTORY;
    public static String JAXB_PROPERTIES_FILE_NAME = "jaxb.properties";
    public static String JAXB_SCHEMA_GEN_JAR_PREFIX = String.valueOf(JAXB_SCHEMA_GEN_PACKAGE_NAME) + "_";
    public static String ECLIPSELINK_JAXB_SCHEMA_GEN_JAR_PREFIX = String.valueOf(ECLIPSELINK_JAXB_SCHEMA_GEN_PACKAGE_NAME) + "_";
    public static String JAXB_GENERIC_SCHEMA_GEN_CLASS = "javax.xml.bind.JAXBContext";
    public static String JAXB_ECLIPSELINK_SCHEMA_GEN_CLASS = "org.eclipse.persistence.jaxb.JAXBContext";
    private final String targetSchemaName;
    private final String[] sourceClassNames;
    private String mainType;
    private boolean useMoxy;

    public static void generate(IJavaProject javaProject, String targetSchemaName, String[] sourceClassNames, boolean useMoxy, IProgressMonitor monitor) {
        if (javaProject == null) {
            throw new NullPointerException();
        }
        new SchemaGenerator(javaProject, targetSchemaName, sourceClassNames, useMoxy).generate(monitor);
    }

    protected SchemaGenerator(IJavaProject javaProject, String targetSchemaName, String[] sourceClassNames, boolean useMoxy) {
        super(javaProject);
        this.targetSchemaName = targetSchemaName;
        this.sourceClassNames = sourceClassNames;
        this.useMoxy = useMoxy;
        this.mainType = this.useMoxy ? ECLIPSELINK_JAXB_SCHEMA_GEN_CLASS : JAXB_SCHEMA_GEN_CLASS;
        this.initialize();
    }

    protected String getMainType() {
        return this.mainType;
    }

    protected String getLaunchConfigName() {
        return LAUNCH_CONFIG_NAME;
    }

    protected String getBootstrapJarPrefix() {
        return this.useMoxy ? ECLIPSELINK_JAXB_SCHEMA_GEN_JAR_PREFIX : JAXB_SCHEMA_GEN_JAR_PREFIX;
    }

    protected void preGenerate(IProgressMonitor monitor) {
        if (this.useMoxy) {
            if (!this.isJaxbPropertiesFilePresent()) {
                this.generateJaxbPropertiesFile(monitor);
            } else if (!this.isJaxbContextMoxy()) {
                this.useMoxy = false;
                this.mainType = JAXB_SCHEMA_GEN_CLASS;
            }
        }
    }

    protected void postGenerate() {
        super.postGenerate();
        try {
            this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> buildClasspath() throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.getBootstrapJarClasspathEntry().getMemento());
        classpath.add(this.getDefaultProjectClasspathEntry().getMemento());
        classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        return classpath;
    }

    protected void specifyProgramArguments() {
        StringBuffer programArguments = new StringBuffer();
        this.appendClassNameArguments(programArguments);
        programArguments.append(" -s \"");
        programArguments.append(this.targetSchemaName);
        programArguments.append('\"');
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private void appendClassNameArguments(StringBuffer sb) {
        String[] stringArray = this.sourceClassNames;
        int n = this.sourceClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            sb.append(" -c ");
            sb.append(className);
            ++n2;
        }
    }

    private IFile getJaxbPropertiesFile() {
        return this.getJaxbPropertiesFileFromPackageRoots(JDTTools.getJavaSourceFolders((IJavaProject)this.javaProject));
    }

    private IFile getJaxbPropertiesFileFromPackageRoots(Iterable<IPackageFragmentRoot> packageFragmentRoots) {
        Object[] objects = null;
        try {
            for (IPackageFragmentRoot pfr : packageFragmentRoots) {
                IJavaElement[] javaElements;
                IJavaElement[] iJavaElementArray = javaElements = pfr.getChildren();
                int n = javaElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = iJavaElementArray[n2];
                    Object[] objectArray = objects = ((IPackageFragment)javaElement).getNonJavaResources();
                    int n3 = objects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray[n4];
                        IResource resource = (IResource)object;
                        if (resource.getName().equals(JAXB_PROPERTIES_FILE_NAME)) {
                            return (IFile)resource;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException jme) {
            throw new RuntimeException(jme);
        }
        return null;
    }

    private boolean isJaxbPropertiesFilePresent() {
        return this.getJaxbPropertiesFile() != null;
    }

    private boolean isJaxbContextMoxy() {
        InputStream in = null;
        try {
            in = this.getJaxbPropertiesFile().getContents();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            String propertyValue = line.substring(line.indexOf("=") + 1);
            if (propertyValue.equals(ECLIPSELINK_JAXB_CONTEXT_FACTORY)) {
                return true;
            }
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        return false;
    }

    private void generateJaxbPropertiesFile(IProgressMonitor monitor) {
        byte[] bytes;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        sm.subTask(JptJaxbCoreMessages.SchemaGenerator_creatingJAXBPropertiesFileTask);
        IPackageFragment packageFragment = this.findPackageFragementForSourceClassName(this.sourceClassNames[0]);
        IFolder folder = (IFolder)packageFragment.getResource();
        IFile file = folder.getFile(JAXB_PROPERTIES_FILE_NAME);
        try {
            bytes = ECLIPSELINK_JAXB_PROPERTIES_FILE_CONTENTS.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(bytes);
        try {
            file.create((InputStream)contents, 0, (IProgressMonitor)sm.newChild(1));
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    private IPackageFragment findPackageFragementForSourceClassName(String sourceClassName) {
        String packageName = sourceClassName.substring(0, sourceClassName.lastIndexOf(46));
        for (IPackageFragmentRoot pfr : JDTTools.getJavaSourceFolders((IJavaProject)this.javaProject)) {
            IPackageFragment packageFragment = pfr.getPackageFragment(packageName);
            if (!packageFragment.exists()) continue;
            return packageFragment;
        }
        throw new IllegalStateException("Java package must exist for source class");
    }
}

