/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.MergeUtils;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;

public final class FileUtils {
    private static final String TMP_FOLDER_NAME = ".cxftmp";

    private FileUtils() {
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static void copyFolder(String source, String destination) {
        File sourceFolder = new File(source);
        String[] files = sourceFolder.list();
        int i = 0;
        while (i < files.length) {
            File file = new File(sourceFolder + File.separator + files[i]);
            if (file.isDirectory()) {
                FileUtils.copyFolder(source, destination, files[i]);
            } else {
                FileUtils.copyFile(source, destination, files[i]);
            }
            ++i;
        }
    }

    private static void copyFolder(String sourceFolder, String targetFolder, String name) {
        File target = new File(String.valueOf(targetFolder) + File.separator + name);
        if (!target.exists()) {
            target.mkdir();
        }
        FileUtils.copyFolder(String.valueOf(sourceFolder) + File.separator + name, String.valueOf(targetFolder) + File.separator + name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(String sourceFolder, String targetFolder, String fileName) {
        File sourceFile = new File(String.valueOf(sourceFolder) + File.separator + fileName);
        File targetFile = new File(String.valueOf(targetFolder) + File.separator + fileName);
        if (!targetFile.exists()) {
            FileInputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(sourceFile);
                    outputStream = new FileOutputStream(targetFile);
                    byte[] buffer = new byte[102400];
                    while (true) {
                        int numberOfBytes;
                        if ((numberOfBytes = ((InputStream)inputStream).read(buffer)) < 0) {
                            return;
                        }
                        outputStream.write(buffer, 0, numberOfBytes);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    CXFCorePlugin.log(fnfe);
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        if (outputStream == null) return;
                        outputStream.close();
                        return;
                    }
                    catch (IOException ioe) {
                        CXFCorePlugin.log(ioe);
                    }
                    return;
                }
                catch (IOException ioe) {
                    CXFCorePlugin.log(ioe);
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        if (outputStream == null) return;
                        outputStream.close();
                        return;
                    }
                    catch (IOException ioe2) {
                        CXFCorePlugin.log(ioe2);
                    }
                    return;
                }
            }
            finally {
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException ioe) {
                    CXFCorePlugin.log(ioe);
                }
            }
        }
        if (sourceFile.getName().indexOf(".java") == -1) return;
        MergeUtils.merge(sourceFile, targetFile);
    }

    public static String getTmpFolderName() {
        return TMP_FOLDER_NAME;
    }

    public static String getTmpFolder(String projectName) {
        return FileUtils.getTmpFolder(FileUtils.getProject(projectName));
    }

    public static String getTmpFolder(IProject project) {
        IFolder tmpWSDLFolder;
        IFolder tmpSrcFolder;
        IFolder tmpFolder = project.getFolder(TMP_FOLDER_NAME);
        if (!tmpFolder.exists()) {
            try {
                tmpFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
            }
        }
        if (!(tmpSrcFolder = tmpFolder.getFolder("src")).exists()) {
            try {
                tmpSrcFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
            }
        }
        if (!(tmpWSDLFolder = tmpFolder.getFolder("wsdl")).exists()) {
            try {
                tmpWSDLFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
            }
        }
        return tmpFolder.getLocation().toOSString();
    }

    public static void copyW2JFilesFromTmp(WSDL2JavaDataModel model) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(model.getProjectName());
        IFolder srcFolder = workspaceRoot.getFolder((IPath)new Path(model.getJavaSourceFolder()));
        FileUtils.copyFolder(String.valueOf(FileUtils.getTmpFolder(project)) + "/src", srcFolder.getLocation().toOSString());
        try {
            srcFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            CXFCorePlugin.log(ce.getStatus());
        }
        FileUtils.deleteTmpFolder(project);
    }

    public static void copyJ2WFilesFromTmp(Java2WSDataModel model) {
        String projectName = model.getProjectName();
        IProject project = FileUtils.getProject(projectName);
        IType type = JDTUtils.findType((IJavaProject)JDTUtils.getJavaProject((String)projectName), (String)model.getJavaStartingPoint());
        IJavaElement javaElement = type.getPackageFragment().getParent();
        IResource javaElementResource = javaElement.getResource();
        if (javaElementResource instanceof IFolder) {
            try {
                IFolder srcDirectory = (IFolder)javaElementResource;
                FileUtils.copyFolder(String.valueOf(FileUtils.getTmpFolder(project)) + "/src", srcDirectory.getLocation().toOSString());
                srcDirectory.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                if (model.isGenerateWSDL()) {
                    IFolder wsdlFolder = WSDLUtils.getWSDLFolder((String)projectName);
                    FileUtils.copyFolder(String.valueOf(FileUtils.getTmpFolder(project)) + "/wsdl", wsdlFolder.getLocation().toOSString());
                    model.setConfigWsdlLocation(String.valueOf(wsdlFolder.getName()) + "/" + model.getWsdlFileName());
                    wsdlFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
            }
        }
        FileUtils.deleteTmpFolder(project);
    }

    private static IStatus deleteTmpFolder(IProject project) {
        IStatus status = Status.OK_STATUS;
        IFolder tmpFolder = project.getFolder(TMP_FOLDER_NAME);
        if (tmpFolder.exists()) {
            try {
                tmpFolder.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
            }
        }
        return status;
    }

    public static boolean isFileInWebContentFolder(IProject project, IPath filePath) {
        IPath webContentPath = WSDLUtils.getWebContentFolder((IProject)project).getLocation();
        return webContentPath.isPrefixOf(filePath);
    }

    public static boolean isFileInWorkspace(URL fileURL) {
        IWorkspaceRoot workspaceRoot;
        IPath workspacePath;
        Path filePath = new Path(fileURL.getPath());
        return filePath.isValidPath((workspacePath = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getLocation()).toOSString());
    }

    public static void formatXMLFile(IFile file) {
        if (file != null) {
            try {
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription == null) {
                    return;
                }
                IContentType contentType = contentDescription.getContentType();
                IStructuredFormatProcessor formatProcessor = FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentType.getId());
                if (formatProcessor != null) {
                    formatProcessor.formatFile(file);
                }
            }
            catch (CoreException ce) {
                CXFCorePlugin.log(ce.getStatus());
            }
            catch (IOException ioe) {
                CXFCorePlugin.log(ioe);
            }
        }
    }

    public static void refreshProject(String projectName, IProgressMonitor monitor) {
        IProject project = FileUtils.getProject(projectName);
        FileUtils.refreshProject(project, monitor);
    }

    public static void refreshProject(IProject project, IProgressMonitor monitor) {
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException ce) {
            CXFCorePlugin.log(ce.getStatus());
        }
    }
}

