/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;

public class DataItemBindingCompletor
extends AbstractBinder {
    private DataItemBinding dataItemBinding;
    private IProblemRequestor problemRequestor;

    public DataItemBindingCompletor(Scope currentScope, DataItemBinding dataItemBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, dataItemBinding, dependencyRequestor, compilerOptions);
        this.dataItemBinding = dataItemBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(DataItem dataItem) {
        dataItem.getName().setBinding(this.dataItemBinding);
        this.dataItemBinding.setPrivate(dataItem.isPrivate());
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.bindType(dataItem.getType());
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return false;
        }
        if (typeBinding.getKind() == 3) {
            if (typeBinding == PrimitiveTypeBinding.getInstance(Primitive.ANY)) {
                this.problemRequestor.acceptProblem(dataItem.getType(), 6599);
            } else {
                this.dataItemBinding.setPrimitiveTypeBinding((PrimitiveTypeBinding)typeBinding);
            }
        } else {
            this.problemRequestor.acceptProblem(dataItem.getType(), 6599);
        }
        return true;
    }

    @Override
    public void endVisit(DataItem dataItem) {
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(dataItem);
        this.dataItemBinding.setValid(true);
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, this.dataItemBinding, this.dataItemBinding, this.dataItemBinding, -1, this.dataItemBinding);
        SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.dataItemBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(blockCompletor);
        return false;
    }
}

