/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Statement;

public class ConverseStatement
extends Statement {
    private Expression expr;
    private Name withNameOpt;

    public ConverseStatement(Expression expr, Name withNameOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        if (withNameOpt != null) {
            this.withNameOpt = withNameOpt;
            withNameOpt.setParent(this);
        }
    }

    public Expression getTarget() {
        return this.expr;
    }

    public boolean isConversingPageLabel() {
        return this.withNameOpt != null;
    }

    public Name getPageLabelName() {
        return this.withNameOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            if (this.withNameOpt != null) {
                this.withNameOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public List getIOObjects() {
        return Arrays.asList(this.expr);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Name newWithNameOpt = this.withNameOpt != null ? (Name)this.withNameOpt.clone() : null;
        return new ConverseStatement((Expression)this.expr.clone(), newWithNameOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public Name getWithNameOpt() {
        return this.withNameOpt;
    }
}

