/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Type;

public class NullableType
extends Type {
    private Type baseType;

    public NullableType(Type baseType, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.baseType = baseType;
        baseType.setParent(this);
    }

    @Override
    public Type getBaseType() {
        return this.baseType;
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.baseType.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalName() {
        return String.valueOf(this.baseType.getCanonicalName()) + "?";
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new NullableType((Type)this.baseType.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public ITypeBinding resolveTypeBinding() {
        ITypeBinding tBinding = this.baseType.resolveTypeBinding();
        return tBinding == null || tBinding == IBinding.NOT_FOUND_BINDING ? null : tBinding.getNullableInstance();
    }

    @Override
    public boolean isNullableType() {
        return true;
    }
}

