/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class TerminalInsertionRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int missingTerminal;

    public TerminalInsertionRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        short[] terminalCandidates = this.errorStack.getTerminalCandidates(this.errorStack.getCurrentState());
        int i = 0;
        while (i < terminalCandidates.length) {
            if (terminalCandidates[i] != 55) {
                Terminal terminal = new Terminal(terminalCandidates[i], -1, -1, -1);
                ParseStack trialStack = this.errorStack.createCopy();
                trialStack.processLookAhead(terminal);
                int trialDistance = trialStack.parseCheck(this.tokenStream);
                if (trialDistance > this.parseCheckDistance) {
                    this.parseCheckDistance = trialDistance;
                    this.missingTerminal = terminalCandidates[i];
                }
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance;
    }

    @Override
    public int performRecovery() {
        int errorOffset = this.tokenStream.getLookAhead().left;
        this.problemRequestor.missingTerminal(this.missingTerminal, this.tokenStream.getLookAhead().left, this.tokenStream.getLookAhead().right);
        Terminal terminal = new Terminal(this.missingTerminal, errorOffset, errorOffset, -1);
        Symbol symbol = new Symbol(this.missingTerminal, errorOffset, errorOffset);
        symbol.parse_state = -2;
        this.tokenStream.rollBack(terminal, symbol);
        return 0;
    }
}

