/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.edt.compiler.internal.IEGLBuildDescriptorLocator;
import org.eclipse.edt.compiler.internal.util.Encoder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EGLBasePlugin
extends AbstractUIPlugin {
    public static final String EGL_BASE_PLUGIN_ID = "org.eclipse.edt.compiler";
    public static final String EGL_AST_PLUGIN_ID = "com.ibm.etools.egl.java.ast";
    public static final String EGL_BUILD_PARTS_DTD_KEY_51 = "-//IBM//DTD EGL 5.1//EN";
    public static final String EGL_BUILD_PARTS_DTD_KEY = "-//IBM Corporation, Inc.//DTD EGL Build Parts 6.0//EN";
    public static final String EGL_BASE_CONTRIBUTION_ID = "com.ibm.etools.egl.buildparts.model.eglcontributions";
    public static final String EGL_PACKAGE_VERSION_EXTENSION_POINT_ID = "org.eclipse.edt.compiler.internal.packages";
    public static final String EGL_PACKAGE_VERSION_ELEMENT_ID = "packageVersion";
    public static final String EGL_PACKAGE_VERSION_ATTRIBUTE_ID = "versionId";
    public static final String EGL_BASE_PRODUCT_ID = "baseproduct";
    public static final String EGL_CORE_ACTIVITY = "com.ibm.etools.egl.core.activity";
    public static final String EGL_JSF_ACTIVITY = "com.ibm.etools.egl.jsf.activity";
    public static final String EGL_DLI_ACTIVITY = "com.ibm.etools.egl.dli.activity";
    public static final String EGL_RCP_ACTIVITY = "com.ibm.etools.egl.rcp.activity";
    public static final String EGL_CUI_ACTIVITY = "com.ibm.etools.egl.cui.activity";
    public static final String EGL_REPORTS_ACTIVITY = "com.ibm.etools.egl.reports.activity";
    public static final String EGL_TUI_ACTIVITY = "com.ibm.etools.egl.tui.activity";
    public static final String EGL_RUI_ACTIVITY = "com.ibm.etools.egl.rui.activity";
    public static final String EGL_VGUI_ACTIVITY = "com.ibm.etools.egl.vgui.activity";
    public static final String EGL_BIRT_ACTIVITY = "com.ibm.etools.egl.birt.activity";
    public static final String EGL_MQ_ACTIVITY = "com.ibm.etools.egl.mq.activity";
    public static final String EGL_FILEIO_ACTIVITY = "com.ibm.etools.egl.fileio.activity";
    public static final String PORTAL_DEVELOPMENT_ACTIVITY = "com.ibm.etools.portaledit.development";
    public static final String EGL_HELP_ID_PREFIX_WSAD = "com.ibm.etools.egl.cshelp";
    public static final String VAGCOMPATIBILITY_OPTION = "VAGCompatibilityOption";
    public static final String ALIAS_JSF_HANDLER_NAMES = "aliasJSFHandlerNames";
    public static final String RUIGENERATIONMODE_OPTION = "ruiGenerationMode";
    public static final String DESTINATION_USERID = "DestinationUserID";
    public static final String DESTINATION_PASSWORD = "DestinationPassword";
    public static final String OUTPUT_CODESET = "outputCodeset";
    public static final String INCOMPLETE_BUILD_PATH = "incompleteBuildPath";
    public static final String BIDI_ENABLED_OPTION = "BidiEnabledOption";
    public static final String BIDI_VISUAL_SOURCEASSISTANT_OPTION = "BidiVisualSourceAssistantOption";
    public static final String BIDI_RTL_SOURCEASSISTANT_OPTION = "BidiRTLSourceAssistantOption";
    public static final String BIDI_VISUAL_EDITING_OPTION = "BidiVisualEditingOption";
    public static final String EGLFEATURE_MASK = "EGLFeatureMask";
    public static final int EGLFEATURE_SOACLIENT_MASK = 2;
    public static final int EGLFEATURE_JASPER_MASK = 4;
    public static final int EGLFEATURE_BIRT_MASK = 8;
    public static final int EGLFEATURE_EGLDD = 16;
    public static final int EGLFEATURE_MQ = 32;
    public static final int EGLFAETURE_LDAP = 64;
    public static final int EGLFEATURE_iSeries = 128;
    public static final String EGL_Default_Web_Runtime = "MigrationDefaultWebRuntime";
    public static final String EGL_Project_Type = "EGLProjectType";
    public static final String EGLWEBFEATURE_WJSF = "EGLWebWithJSF";
    public static final String EGLWEBFEATURE_WEBTRANS = "EGLWebWithWebTrans";
    public static final String EGLWEBFEATURE_JAVAOBJINTERFACE = "EGLWebWithJavaObjInterface";
    public static final QualifiedName VALUESTOREKEY_EGLFEATURE = new QualifiedName(null, "EGLProjectFeatureMask");
    public static final String EGLPROJECTMIGRATIONVERSION75 = "7.5.0";
    public static final String EGLPROJECTMIGRATIONVERSION80 = "8.0.0";
    public static final QualifiedName VALUESTOREKEY_EGLPROJECTMIGRATIONVERSION = new QualifiedName(null, "EGLProjectMigrationVersion");
    public static final String BD_UPDATE_ON_DATA_SOURCE_CHANGE_PROMPT = "promptBeforeUpdatingBuildDescAfterDataSourceChange";
    public static final String BD_UPDATE_ON_DATA_SOURCE_CHANGE_ALWAYS = "alwaysUpdateBuildDescAfterDataSourceChange";
    public static final String BD_UPDATE_ON_DATA_SOURCE_CHANGE_NEVER = "neverUpdateBuildDescAfterDataSourceChange";
    public static String[] defaultArchitectureOptionNonMnemonicStrings;
    private IEGLBuildDescriptorLocator bdLocator = null;
    public static final String PT_BUILDDESCRIPTORLOCATOR = "com.ibm.etools.egl.buildDescriptorLocator";
    public static final String EGL_VALIDATION_RESOURCE_BUNDLE = "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    public static final QualifiedName GENERATED_JAVA_FOLDER;
    public static final QualifiedName CUSTOM_JAVA_FOLDER;
    public static final QualifiedName DEBUG_JAVASCRIPT_FOLDER;
    public static final QualifiedName TARGET_JAVASCRIPT_FOLDER;
    public static final int TARGET_RUNTIME_JAVA_MASK = 1;
    public static final int TARGET_RUNTIME_JAVASCRIPT_MASK = 2;
    public static final int TARGET_RUNTIME_COBOL_MASK = 4;
    public static final QualifiedName VALUESTOREKEY_TARGETRUNTIME;
    protected static EGLBasePlugin plugin;

    static {
        GENERATED_JAVA_FOLDER = new QualifiedName(null, "GeneratedJavaFolder");
        CUSTOM_JAVA_FOLDER = new QualifiedName(null, "CustomJavaFolder");
        DEBUG_JAVASCRIPT_FOLDER = new QualifiedName(null, "DebugJavaScriptFolder");
        TARGET_JAVASCRIPT_FOLDER = new QualifiedName(null, "TargetJavaScriptFolder");
        VALUESTOREKEY_TARGETRUNTIME = new QualifiedName(null, "EGLTargetRuntimeMask");
    }

    public EGLBasePlugin() {
        plugin = this;
    }

    public static EGLBasePlugin getPlugin() {
        return plugin;
    }

    public static String getDestinationUserIDPreference() {
        String userIDPreference = EGLBasePlugin.getPlugin().getPreferenceStore().getString(DESTINATION_USERID);
        if (userIDPreference == null) {
            return "";
        }
        return userIDPreference;
    }

    public static void setDestinationUserIDPreference(String value) {
        EGLBasePlugin.getPlugin().getPreferenceStore().setValue(DESTINATION_USERID, value);
    }

    public static void setDestinationPasswordPreference(String value) {
        String destPassword = value;
        if (destPassword.trim().length() > 0 && !Encoder.isEncoded(destPassword)) {
            destPassword = Encoder.encode(destPassword);
        }
        EGLBasePlugin.getPlugin().getPreferenceStore().setValue(DESTINATION_PASSWORD, destPassword);
    }

    public static String getDestinationPasswordPreference() {
        String passwordPreference = EGLBasePlugin.getPlugin().getPreferenceStore().getString(DESTINATION_PASSWORD);
        if (passwordPreference == null) {
            return "";
        }
        if (passwordPreference.trim().length() > 0 && Encoder.isEncoded(passwordPreference)) {
            passwordPreference = Encoder.decode(passwordPreference);
        }
        return passwordPreference;
    }

    public static boolean isASTInstalled() {
        State state = Platform.getPlatformAdmin().getState(false);
        BundleDescription bundle = state.getBundle(EGL_AST_PLUGIN_ID, null);
        if (bundle != null) {
            return bundle.getResolvedRequires().length == bundle.getRequiredBundles().length;
        }
        return false;
    }

    private static boolean isEGLComponent(String id) {
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        IActivity activity = activityManager.getActivity(id);
        return activity.isEnabled();
    }

    public static boolean isCore() {
        return EGLBasePlugin.isEGLComponent(EGL_CORE_ACTIVITY);
    }

    public static boolean isJSF() {
        return EGLBasePlugin.isEGLComponent(EGL_JSF_ACTIVITY);
    }

    public static boolean isDLI() {
        return EGLBasePlugin.isEGLComponent(EGL_DLI_ACTIVITY);
    }

    public static boolean isRCP() {
        return EGLBasePlugin.isEGLComponent(EGL_RCP_ACTIVITY);
    }

    public static boolean isCUI() {
        return EGLBasePlugin.isEGLComponent(EGL_CUI_ACTIVITY);
    }

    public static boolean isReports() {
        return EGLBasePlugin.isEGLComponent(EGL_REPORTS_ACTIVITY);
    }

    public static boolean isTUI() {
        return EGLBasePlugin.isEGLComponent(EGL_TUI_ACTIVITY);
    }

    public static boolean isRUI() {
        return EGLBasePlugin.isEGLComponent(EGL_RUI_ACTIVITY);
    }

    public static boolean isVGUI() {
        return EGLBasePlugin.isEGLComponent(EGL_VGUI_ACTIVITY);
    }

    public static boolean isBIRT() {
        return EGLBasePlugin.isEGLComponent(EGL_BIRT_ACTIVITY);
    }

    public static boolean isMQ() {
        return EGLBasePlugin.isEGLComponent(EGL_MQ_ACTIVITY);
    }

    public static String getHelpIDPrefix() {
        return EGL_HELP_ID_PREFIX_WSAD;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(OUTPUT_CODESET, "UTF-8");
        store.setDefault(VAGCOMPATIBILITY_OPTION, false);
        store.setDefault(EGLFEATURE_MASK, 16);
        store.setDefault(EGLWEBFEATURE_WJSF, true);
        store.setDefault(EGLWEBFEATURE_JAVAOBJINTERFACE, true);
        store.setDefault(BD_UPDATE_ON_DATA_SOURCE_CHANGE_PROMPT, true);
        store.setDefault(BIDI_ENABLED_OPTION, false);
        store.setDefault(BIDI_VISUAL_SOURCEASSISTANT_OPTION, false);
        store.setDefault(BIDI_RTL_SOURCEASSISTANT_OPTION, false);
        store.setDefault(BIDI_VISUAL_EDITING_OPTION, false);
        store.setDefault(ALIAS_JSF_HANDLER_NAMES, true);
    }

    public IEGLBuildDescriptorLocator getBdLocator() {
        if (this.bdLocator == null) {
            this.initializeBDLocator();
        }
        return this.bdLocator;
    }

    private void initializeBDLocator() {
        try {
            IConfigurationElement[] extensions;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PT_BUILDDESCRIPTORLOCATOR);
            if (extensionPoint != null && (extensions = extensionPoint.getConfigurationElements()).length > 0) {
                this.bdLocator = (IEGLBuildDescriptorLocator)extensions[extensions.length - 1].createExecutableExtension("class");
            }
        }
        catch (CoreException coreException) {}
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }
}

