/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import java.util.HashMap;
import org.eclipse.edt.compiler.internal.EGLLib;

public class EGLStrLib
extends EGLLib {
    private static final EGLStrLib INSTANCE = new EGLStrLib();
    public static final EGLStrLibConstant ISO_DATE_FORMAT = new EGLStrLibConstant("isoDateFormat", 0, 10);
    public static final EGLStrLibConstant EUR_DATE_FORMAT = new EGLStrLibConstant("eurDateFormat", 0, 10);
    public static final EGLStrLibConstant JIS_DATE_FORMAT = new EGLStrLibConstant("jisDateFormat", 0, 10);
    public static final EGLStrLibConstant USA_DATE_FORMAT = new EGLStrLibConstant("usaDateFormat", 0, 10);
    public static final EGLStrLibConstant DEFAULT_DATE_FORMAT = new EGLStrLibConstant("defaultDateFormat", 0, 10);
    public static final EGLStrLibConstant ISO_TIME_FORMAT = new EGLStrLibConstant("isoTimeFormat", 1, 8);
    public static final EGLStrLibConstant EUR_TIME_FORMAT = new EGLStrLibConstant("eurTimeFormat", 1, 8);
    public static final EGLStrLibConstant JIS_TIME_FORMAT = new EGLStrLibConstant("jisTimeFormat", 1, 8);
    public static final EGLStrLibConstant USA_TIME_FORMAT = new EGLStrLibConstant("usaTimeFormat", 1, 8);
    public static final EGLStrLibConstant DEFAULT_TIME_FORMAT = new EGLStrLibConstant("defaultTimeFormat", 1, 8);
    public static final EGLStrLibConstant DB2_TIMESTAMP_FORMAT = new EGLStrLibConstant("db2TimeStampFormat", 2, 26);
    public static final EGLStrLibConstant ODBC_TIMESTAMP_FORMAT = new EGLStrLibConstant("odbcTimeStampFormat", 2, 26);
    public static final EGLStrLibConstant DEFAULT_TIMESTAMP_FORMAT = new EGLStrLibConstant("defaultTimeStampFormat", 2, 26);
    public static final EGLStrLibConstant NULL_FILL = new EGLStrLibConstant("nullFill", 3, 0);
    private static final HashMap constantsMap = new HashMap();
    public static final EGLStrLibConstant[] timeConstants;
    public static final EGLStrLibConstant[] dateConstants;
    public static final EGLStrLibConstant[] timeStampConstants;
    private static final String LIBRARY_NAME = "strLib";

    static {
        constantsMap.put("isoDateFormat".toUpperCase().toLowerCase(), ISO_DATE_FORMAT);
        constantsMap.put("eurDateFormat".toUpperCase().toLowerCase(), EUR_DATE_FORMAT);
        constantsMap.put("usaDateFormat".toUpperCase().toLowerCase(), USA_DATE_FORMAT);
        constantsMap.put("jisDateFormat".toUpperCase().toLowerCase(), JIS_DATE_FORMAT);
        constantsMap.put("defaultDateFormat".toUpperCase().toLowerCase(), DEFAULT_DATE_FORMAT);
        constantsMap.put("isoTimeFormat".toUpperCase().toLowerCase(), ISO_TIME_FORMAT);
        constantsMap.put("eurTimeFormat".toUpperCase().toLowerCase(), EUR_TIME_FORMAT);
        constantsMap.put("jisTimeFormat".toUpperCase().toLowerCase(), JIS_TIME_FORMAT);
        constantsMap.put("usaTimeFormat".toUpperCase().toLowerCase(), USA_TIME_FORMAT);
        constantsMap.put("defaultTimeFormat".toUpperCase().toLowerCase(), DEFAULT_TIME_FORMAT);
        constantsMap.put("db2TimeStampFormat".toUpperCase().toLowerCase(), DB2_TIMESTAMP_FORMAT);
        constantsMap.put("odbcTimeStampFormat".toUpperCase().toLowerCase(), ODBC_TIMESTAMP_FORMAT);
        constantsMap.put("defaultTimeStampFormat".toUpperCase().toLowerCase(), DEFAULT_TIMESTAMP_FORMAT);
        constantsMap.put("nullFill".toUpperCase().toLowerCase(), NULL_FILL);
        timeConstants = new EGLStrLibConstant[]{ISO_TIME_FORMAT, EUR_TIME_FORMAT, JIS_TIME_FORMAT, USA_TIME_FORMAT, DEFAULT_TIME_FORMAT};
        dateConstants = new EGLStrLibConstant[]{ISO_DATE_FORMAT, EUR_DATE_FORMAT, USA_DATE_FORMAT, JIS_DATE_FORMAT, DEFAULT_DATE_FORMAT};
        timeStampConstants = new EGLStrLibConstant[]{DB2_TIMESTAMP_FORMAT, ODBC_TIMESTAMP_FORMAT, DEFAULT_TIMESTAMP_FORMAT};
    }

    private EGLStrLib() {
    }

    public static EGLStrLib getInstance() {
        return INSTANCE;
    }

    public EGLStrLibConstant resolve(String resolveString) {
        return (EGLStrLibConstant)super.resolve(LIBRARY_NAME, resolveString);
    }

    @Override
    public EGLLib.EGLLibConstant getConstant(String name) {
        return (EGLLib.EGLLibConstant)constantsMap.get(name.toUpperCase().toLowerCase());
    }

    public static class EGLStrLibConstant
    extends EGLLib.EGLLibConstant {
        public static final int DATE_TYPE = 0;
        public static final int TIME_TYPE = 1;
        public static final int TIMESTAMP_TYPE = 2;
        public static final int FILLCHARACTER_TYPE = 3;
        private int type;
        private int defaultFieldLength;

        public EGLStrLibConstant(String constantName, int type, int defaultFieldLength) {
            super(constantName);
            this.type = type;
            this.defaultFieldLength = defaultFieldLength;
        }

        public int getDefaultFieldLength() {
            return this.defaultFieldLength;
        }

        public int getType() {
            return this.type;
        }
    }
}

