/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import org.eclipse.edt.compiler.internal.EGLBaseNlsStrings;
import org.eclipse.edt.compiler.internal.EGLSystemWord;

public class EGLSystemVariable
extends EGLSystemWord {
    private int length;
    private int arrayLength;
    private String primitiveType;

    public EGLSystemVariable(String name, int type, int specialFunctionType) {
        this(name, type, specialFunctionType, null, 0);
    }

    public EGLSystemVariable(String name, int type, int specialFunctionType, String primitiveType, int length) {
        this(name, type, specialFunctionType, primitiveType, length, "sysVar".toLowerCase());
    }

    public EGLSystemVariable(String name, int type, int specialFunctionType, String primitiveType, int length, String library) {
        this(name, type, specialFunctionType, primitiveType, length, library, -1);
    }

    public EGLSystemVariable(String name, int type, int specialFunctionType, int length, int arrayLength) {
        this(name, type, specialFunctionType, null, 0, arrayLength);
    }

    public EGLSystemVariable(String name, int type, int specialFunctionType, String primitiveType, int length, int arrayLength) {
        this(name, type, specialFunctionType, primitiveType, length, "sysVar".toLowerCase(), arrayLength);
    }

    public EGLSystemVariable(String name, int type, int specialFunctionType, String primitiveType, int length, String library, int arrayLength) {
        super(name, type, specialFunctionType, library);
        this.length = length;
        this.arrayLength = arrayLength;
        this.primitiveType = primitiveType;
        this.additonalInformation = this.isArrayWord() ? EGLBaseNlsStrings.CAProposalArrayVariableSystemWord : EGLBaseNlsStrings.CAProposalVariableSystemWord;
    }

    @Override
    public boolean isSystemVariable() {
        return true;
    }

    public boolean isCharacterVariable() {
        return (this.type & 4) != 0;
    }

    public boolean isNumericVariable() {
        return (this.type & 8) != 0;
    }

    public boolean isReferenceTypeVariable() {
        return (this.type & 0x20) != 0;
    }

    @Override
    public boolean isPresentationAttributes() {
        return this.primitiveType != null && this.primitiveType.equals("egl.console.ui.PRESENTATIONATTRIBUTES");
    }

    @Override
    public boolean isPSBDataRecord() {
        return this.primitiveType != null && this.primitiveType.equals("PSBDATARECORD");
    }

    public int getLength() {
        return this.length;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public boolean isArray() {
        return this.arrayLength != -1;
    }

    public String getPrimitiveType() {
        return this.primitiveType;
    }

    public boolean isReadOnly() {
        return (this.type & 0x80) != 0;
    }
}

