/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.DynamicDataBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class TypeBindingScope
extends Scope {
    private ITypeBinding typeBinding;
    private IDataBinding dataBinding;
    private boolean addImplicitQualifier;

    public TypeBindingScope(Scope parentScope, ITypeBinding typeBinding, IDataBinding dataBinding) {
        super(parentScope);
        this.typeBinding = typeBinding;
        this.dataBinding = dataBinding;
    }

    public TypeBindingScope(Scope parentScope, ITypeBinding typeBinding, IDataBinding dataBinding, boolean addImplicitQualifier) {
        this(parentScope, typeBinding, dataBinding);
        this.addImplicitQualifier = addImplicitQualifier;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result = this.findDataInType(simpleName);
        if (result != null && result != IBinding.NOT_FOUND_BINDING) {
            IPartBinding partBinding;
            if (this.addImplicitQualifier && this.typeBinding.isPartBinding() && (partBinding = (IPartBinding)this.typeBinding).getStaticPartDataBinding() != null) {
                return new DataBindingWithImplicitQualifier(result, partBinding.getStaticPartDataBinding());
            }
            return result;
        }
        return this.parentScope.findData(simpleName);
    }

    private IDataBinding findDataInType(String simpleName) {
        if (this.typeBinding != null) {
            if (this.typeBinding.isDynamicallyAccessible()) {
                IPartBinding declaringPart = null;
                if (this.dataBinding != null) {
                    declaringPart = this.dataBinding.getDeclaringPart();
                }
                return new DynamicDataBinding(InternUtil.internCaseSensitive((String)simpleName), declaringPart);
            }
            IDataBinding result = this.typeBinding.getBaseType().findData(simpleName);
            if (result != IBinding.NOT_FOUND_BINDING) {
                return result;
            }
            if (this.typeBinding.getKind() == 6 && (result = (IDataBinding)this.typeBinding.getSimpleNamesToDataBindingsMap().get(simpleName)) != null) {
                return result;
            }
        }
        return null;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return this.parentScope.findFunction(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }

    public ITypeBinding getTypeBinding() {
        return this.typeBinding;
    }
}

