/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class VAGenResolutionWarningsValidator {
    private IProblemRequestor pRequestor;
    private ICompilerOptions compilerOptions;

    public VAGenResolutionWarningsValidator(IProblemRequestor pRequestor, ICompilerOptions compilerOptions) {
        this.pRequestor = pRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void checkOperands(ITypeBinding functionContainerBinding, final Expression operand1, final Expression operand2, final Node nodeForErrors) {
        IAnnotationBinding aBinding;
        IAnnotationBinding iAnnotationBinding = aBinding = functionContainerBinding == null ? null : functionContainerBinding.getAnnotation(new String[]{"egl", "core"}, "allowUnqualifiedItemReferences");
        if (this.compilerOptions.isVAGCompatible() && aBinding != null && Boolean.YES == aBinding.getValue()) {
            final ITypeBinding operand1Type = operand1.resolveTypeBinding();
            final ITypeBinding operand2Type = operand2.resolveTypeBinding();
            if (StatementValidator.isValidBinding(operand1Type) && StatementValidator.isValidBinding(operand2Type)) {
                operand1.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(SimpleName simpleName) {
                        boolean firstOperandContainer = VAGenResolutionWarningsValidator.this.isContainer(operand1Type);
                        if (firstOperandContainer) {
                            boolean secondOperandItem = VAGenResolutionWarningsValidator.this.isItem(operand2Type);
                            if (firstOperandContainer && secondOperandItem) {
                                VAGenResolutionWarningsValidator.this.pRequestor.acceptProblem(nodeForErrors, 6621, 1, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                            }
                        }
                        return false;
                    }
                });
                operand2.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(SimpleName simpleName) {
                        boolean firstOperandItem;
                        boolean secondOperandContainer = VAGenResolutionWarningsValidator.this.isContainer(operand2Type);
                        if (secondOperandContainer && (firstOperandItem = VAGenResolutionWarningsValidator.this.isItem(operand1Type)) && secondOperandContainer) {
                            VAGenResolutionWarningsValidator.this.pRequestor.acceptProblem(nodeForErrors, 6621, 1, new String[]{operand2.getCanonicalString(), operand1.getCanonicalString()});
                        }
                        return false;
                    }
                });
            }
        }
    }

    public void checkItemRecordNameOverlap(final Scope scope, final Expression expression) {
        IDataBinding dBinding;
        if (this.compilerOptions.isVAGCompatible() && IBinding.NOT_FOUND_BINDING != (dBinding = expression.resolveDataBinding()) && dBinding != null) {
            expression.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(SimpleName simpleName) {
                    FunctionContainerScope fContainerScope = VAGenResolutionWarningsValidator.this.getFunctionContainerScope(scope);
                    if (fContainerScope != null) {
                        Map itemsWhoseNamesCanBeUnqualified = fContainerScope.getItemsWhoseNamesCanBeUnqualified();
                        Map recordsFormsAndDataTables = fContainerScope.getRecordsFormsAndDataTables();
                        block0 : switch (dBinding.getKind()) {
                            case 5: 
                            case 7: {
                                IDataBinding otherDBinding = (IDataBinding)recordsFormsAndDataTables.get(dBinding.getName());
                                if (otherDBinding == null) break;
                                if (otherDBinding.isDataBindingWithImplicitQualifier()) {
                                    otherDBinding = ((DataBindingWithImplicitQualifier)otherDBinding).getWrappedDataBinding();
                                }
                                switch (otherDBinding.getKind()) {
                                    case 5: 
                                    case 7: {
                                        VAGenResolutionWarningsValidator.this.pRequestor.acceptProblem(expression, 6572, 1, new String[]{dBinding.getName(), dBinding.getDeclaringPart().getName(), otherDBinding.getDeclaringPart().getName()});
                                        break block0;
                                    }
                                }
                                VAGenResolutionWarningsValidator.this.pRequestor.acceptProblem(expression, 6571, 1, new String[]{dBinding.getName(), dBinding.getDeclaringPart().getName()});
                                break;
                            }
                            default: {
                                ITypeBinding tBinding = dBinding.getType();
                                if (!Binding.isValidBinding(tBinding)) break;
                                switch (tBinding.getKind()) {
                                    case 5: 
                                    case 6: 
                                    case 8: {
                                        IDataBinding otherDBinding = (IDataBinding)itemsWhoseNamesCanBeUnqualified.get(dBinding.getName());
                                        if (otherDBinding == null) break block0;
                                        if (otherDBinding.isDataBindingWithImplicitQualifier()) {
                                            otherDBinding = ((DataBindingWithImplicitQualifier)otherDBinding).getWrappedDataBinding();
                                        }
                                        VAGenResolutionWarningsValidator.this.pRequestor.acceptProblem(expression, 6570, 1, new String[]{dBinding.getName(), otherDBinding.getDeclaringPart().getName()});
                                    }
                                }
                            }
                        }
                    }
                    return false;
                }
            });
        }
    }

    private FunctionContainerScope getFunctionContainerScope(Scope scope) {
        while (scope != null && !(scope instanceof FunctionContainerScope)) {
            scope = scope.getParentScope();
        }
        return (FunctionContainerScope)scope;
    }

    private boolean isItem(ITypeBinding type) {
        return 3 == type.getKind() || 26 == type.getKind();
    }

    private boolean isContainer(ITypeBinding type) {
        return 6 == type.getKind() || 8 == type.getKind() || 5 == type.getKind();
    }
}

