/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.utils;

import java.io.StringReader;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AccumulatingSyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.VAGLexer;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;

public class TypeParser {
    private ICompilerOptions compilerOptions;

    public TypeParser(ICompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public Type parseAsType(String string) {
        File fileAst = this.getFileAst(this.getPartString(string));
        if (fileAst == null) {
            return null;
        }
        final FunctionDataDeclaration[] result = new FunctionDataDeclaration[1];
        fileAst.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionDataDeclaration dataDecl) {
                result[0] = dataDecl;
                return false;
            }
        });
        if (result[0] == null) {
            return null;
        }
        return result[0].getType();
    }

    private File getFileAst(String string) {
        try {
            StringReader reader = new StringReader(string);
            ErrorCorrectingParser parser = new ErrorCorrectingParser(this.compilerOptions.isVAGCompatible() ? new VAGLexer(reader) : new Lexer(reader));
            AccumulatingSyntaxErrorRequestor pRequestor = new AccumulatingSyntaxErrorRequestor();
            parser.setProblemRequestor(pRequestor);
            File fileAST = (File)parser.parse().value;
            if (pRequestor.getSyntaxErrors().isEmpty()) {
                return fileAST;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    private String getPartString(String string) {
        return "function fred() wilma " + string + "; end";
    }
}

