/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class JavaObjectFieldTypeValidator
extends DefaultFieldContentAnnotationValidationRule {
    private static Set invalidPrimitives = null;

    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding type = containerBinding.getType();
        if (Binding.isValidBinding(type)) {
            JavaObjectFieldTypeValidator.checkTypeValidInExternalType(errorNode, containerBinding.getDeclaringPart(), type.getBaseType(), false, problemRequestor);
        }
        JavaObjectFieldTypeValidator.checkDataDeclarationValidInExternalType(errorNode, containerBinding, problemRequestor);
    }

    public void validateFunctionParameter(FunctionParameter fParameter, FunctionParameterBinding parameterBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding parameterTypeBinding = parameterBinding.getType();
        if (Binding.isValidBinding(parameterTypeBinding)) {
            JavaObjectFieldTypeValidator.checkTypeValidInExternalType(fParameter.getType().getBaseType(), parameterBinding.getDeclaringPart(), parameterTypeBinding.getBaseType(), true, problemRequestor);
            if (3 == parameterTypeBinding.getKind() && !Primitive.isDateTimeType(((PrimitiveTypeBinding)parameterTypeBinding).getPrimitive()) && !parameterBinding.isInput()) {
                problemRequestor.acceptProblem(fParameter, 7824);
            }
        }
    }

    @Override
    public void validateFunctionReturnType(Type typeNode, ITypeBinding typeBinding, IPartBinding declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        JavaObjectFieldTypeValidator.checkTypeValidInExternalType(typeNode.getBaseType(), declaringPart, typeBinding.getBaseType(), true, problemRequestor);
    }

    public static void checkTypeValidInExternalType(Node errorNode, IPartBinding partBinding, ITypeBinding typeBinding, boolean issueErrorForDelegate, IProblemRequestor problemRequestor) {
        if (IBinding.NOT_FOUND_BINDING != typeBinding && typeBinding != null) {
            boolean typeValid = true;
            switch (typeBinding.getKind()) {
                case 6: 
                case 7: 
                case 10: 
                case 21: 
                case 22: {
                    typeValid = false;
                    break;
                }
                case 27: {
                    typeValid = !issueErrorForDelegate;
                    break;
                }
                case 3: {
                    boolean bl = typeValid = !JavaObjectFieldTypeValidator.getInvalidPrimitives().contains(typeBinding);
                }
            }
            if (!typeValid) {
                problemRequestor.acceptProblem(errorNode, 3425, new String[]{StatementValidator.getTypeString(typeBinding)});
            }
        }
    }

    public static void checkDataDeclarationValidInExternalType(Node errorNode, IDataBinding binding, IProblemRequestor problemRequestor) {
        IAnnotationBinding aBinding;
        ITypeBinding tBinding = binding.getType();
        if (Binding.isValidBinding(tBinding) && IBinding.NOT_FOUND_BINDING != (tBinding = tBinding.getBaseType()) && tBinding != null && 27 == tBinding.getKind() && (aBinding = binding.getAnnotation(new String[]{"eglx", "lang"}, "eventListener")) == null) {
            problemRequestor.acceptProblem(errorNode, 3426, new String[]{StatementValidator.getTypeString(tBinding), "eventListener"});
        }
    }

    private static Set getInvalidPrimitives() {
        if (invalidPrimitives == null) {
            invalidPrimitives = new HashSet();
            invalidPrimitives.add(PrimitiveTypeBinding.getInstance(Primitive.BLOB));
            invalidPrimitives.add(PrimitiveTypeBinding.getInstance(Primitive.CLOB));
            invalidPrimitives.add(PrimitiveTypeBinding.getInstance(Primitive.ANY));
        }
        return invalidPrimitives;
    }
}

