/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.PCBKind;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class PCBValidator
implements IAnnotationValidationRule {
    private static final Set invalidFieldsForType = new HashSet();

    static {
        invalidFieldsForType.add(InternUtil.intern((String)"secondaryIndex"));
        invalidFieldsForType.add(InternUtil.intern((String)"secondaryIndexItem"));
        invalidFieldsForType.add(InternUtil.intern((String)"hierarchy"));
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
    }

    private void validateType(final Node expression, Node container, final Map allAnnotations, final IProblemRequestor problemRequestor) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"pcbType"));
        if (annotationBinding != null) {
            final IDataBinding pcbKind = (IDataBinding)annotationBinding.getValue();
            if (pcbKind.getName().equalsIgnoreCase(PCBKind.TP.getName()) || pcbKind.getName().equalsIgnoreCase(PCBKind.GSAM.getName())) {
                for (String fieldName : invalidFieldsForType) {
                    if (!allAnnotations.containsKey(fieldName)) continue;
                    problemRequestor.acceptProblem(expression, 7855, new String[]{fieldName, pcbKind.getName()});
                }
            } else if (pcbKind.getName().equalsIgnoreCase(PCBKind.DB.getName())) {
                container.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(StructureItem structureItem) {
                        String itemName = structureItem.getName().getIdentifier();
                        if (itemName == InternUtil.intern((String)"elawork") || itemName == InternUtil.intern((String)"elamsg")) {
                            for (String fieldName : invalidFieldsForType) {
                                if (!allAnnotations.containsKey(fieldName)) continue;
                                problemRequestor.acceptProblem(expression, 7856, new String[]{fieldName, pcbKind.getCaseSensitiveName()});
                            }
                        }
                        return false;
                    }
                });
            }
        }
    }
}

