/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;

public class PublishMessageHelperValidator
implements IValueValidationRule {
    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        FunctionBinding function;
        if (annotationBinding.getValue() instanceof FunctionBinding && !this.isValidPublishMessageHelperFunction(function = (FunctionBinding)annotationBinding.getValue())) {
            problemRequestor.acceptProblem(errorNode, 3323, new String[]{function.getName()});
        }
    }

    public boolean isValidPublishMessageHelperFunction(FunctionBinding function) {
        if (function.getReturnType() != null) {
            return false;
        }
        if (function.getParameters().size() != 1) {
            return false;
        }
        FunctionParameterBinding parm = (FunctionParameterBinding)function.getParameters().get(0);
        if (parm.getType() != this.getStringType()) {
            return false;
        }
        return !parm.isOutput() && !parm.isInputOutput();
    }

    private PrimitiveTypeBinding getStringType() {
        return PrimitiveTypeBinding.getInstance(Primitive.STRING);
    }
}

