/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SelectTypeForPageItemFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    public static final Set STRINGS_OR_CHARS = new HashSet<Primitive>(Arrays.asList(Primitive.STRING, Primitive.CHAR));

    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        boolean compatible;
        ITypeBinding containerType;
        ITypeBinding selectFromListItemType;
        IDataBinding selectFromListItemDBinding;
        Object selectFromListItemValue;
        IAnnotationBinding selectFromListItemABinding;
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"selectType"));
        EnumerationDataBinding value = null;
        if (annotationBinding != null) {
            value = (EnumerationDataBinding)annotationBinding.getValue();
        }
        if ((selectFromListItemABinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"selectFromListItem"))) == null) {
            if (value != null) {
                problemRequestor.acceptProblem(errorNode, 3133);
            }
        } else if (value == null || InternUtil.intern((String)"INDEX") == value.getName()) {
            boolean compatible2;
            ITypeBinding containerType2 = containerBinding.getType();
            if (containerType2 != null && IBinding.NOT_FOUND_BINDING != containerType2 && !(compatible2 = TypeCompatibilityUtil.typesAreIdentical(containerType2.getBaseType(), PrimitiveTypeBinding.getInstance(Primitive.INT), compilerOptions))) {
                problemRequestor.acceptProblem(errorNode, 3142, new String[]{containerBinding.getCaseSensitiveName()});
            }
        } else if (InternUtil.intern((String)"VALUE") == value.getName() && (selectFromListItemValue = selectFromListItemABinding.getValue()) instanceof Name && (selectFromListItemDBinding = ((Name)selectFromListItemABinding.getValue()).resolveDataBinding()) != IBinding.NOT_FOUND_BINDING && selectFromListItemDBinding != null && (selectFromListItemType = selectFromListItemDBinding.getType()) != null && containerBinding.getType() != null && (containerType = containerBinding.getType()) != null && IBinding.NOT_FOUND_BINDING != containerType && !(compatible = SelectTypeForPageItemFieldValidator.typesIdenticalOrAreCharAndString(containerType.getBaseType(), selectFromListItemType.getBaseType(), compilerOptions))) {
            problemRequestor.acceptProblem(errorNode, 3132, new String[]{((Name)selectFromListItemValue).getCanonicalName(), containerBinding.getCaseSensitiveName()});
        }
    }

    public static boolean typesIdenticalOrAreCharAndString(ITypeBinding type1, ITypeBinding type2, ICompilerOptions compilerOptions) {
        return TypeCompatibilityUtil.typesAreIdentical(type1, type2, compilerOptions) || SelectTypeForPageItemFieldValidator.typesInPrimitiveClass(new ITypeBinding[]{type1, type2}, STRINGS_OR_CHARS);
    }

    public static boolean typesInPrimitiveClass(ITypeBinding[] bindings, Set primitives) {
        int i = 0;
        while (i < bindings.length) {
            if (3 != bindings[i].getKind() || !primitives.contains(((PrimitiveTypeBinding)bindings[i]).getPrimitive())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

