/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractSelectedItemAnnotationValidator;

public class SelectedRowItemAnnotationValidator
extends AbstractSelectedItemAnnotationValidator {
    public SelectedRowItemAnnotationValidator() {
        super("selectedRowItem");
    }

    @Override
    protected void targetIsDataTableOrRecordArray(Node errorNode, IBinding targetBinding, ITypeBinding targetTypeBinding, ITypeBinding selectedItemType, IDataBinding value, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        boolean typeValid = false;
        if (5 == value.getKind()) {
            if (((StructureItemBinding)value).isMultiplyOccuring() || 5 == value.getDeclaringPart().getKind()) {
                if (PrimitiveTypeBinding.getInstance(Primitive.INT) == selectedItemType || PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN) == selectedItemType) {
                    typeValid = true;
                }
            } else {
                IAnnotationBinding aBinding = value.getAnnotation(new String[]{"egl", "ui"}, "isBoolean");
                if (aBinding != null && Boolean.YES == aBinding.getValue()) {
                    typeValid = true;
                }
            }
        } else if (ArrayTypeBinding.getInstance(PrimitiveTypeBinding.getInstance(Primitive.INT)) == selectedItemType || ArrayTypeBinding.getInstance(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN)) == selectedItemType) {
            typeValid = true;
        } else {
            IAnnotationBinding aBinding = value.getAnnotation(new String[]{"egl", "ui"}, "isBoolean");
            if (aBinding != null && Boolean.YES == aBinding.getValue()) {
                typeValid = true;
            }
        }
        if (!typeValid) {
            problemRequestor.acceptProblem(errorNode, 7681, new String[]{value.getCaseSensitiveName()});
        }
    }

    @Override
    protected void targetIsPrimitiveArray(Node errorNode, IBinding targetBinding, ITypeBinding targetTypeBinding, ITypeBinding selectedItemType, IDataBinding value, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        PrimitiveTypeBinding intPrim = PrimitiveTypeBinding.getInstance(Primitive.INT);
        if (intPrim != selectedItemType && ArrayTypeBinding.getInstance(intPrim) != selectedItemType) {
            problemRequestor.acceptProblem(errorNode, 7688, new String[]{value.getCaseSensitiveName()});
        }
    }
}

