/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.core.EGLSQLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;

public class TableNameVariablesValueValidator
implements IValueValidationRule {
    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotationBinding.getValue() instanceof String[][]) {
            String[][] value = (String[][])annotationBinding.getValue();
            int i = 0;
            while (i < value.length) {
                String[] nextPair = value[i];
                if (nextPair.length == 2 && EGLSQLKeywordHandler.getSQLClauseKeywordNamesToLowerCaseAsSet().contains(nextPair[1].toLowerCase())) {
                    problemRequestor.acceptProblem(errorNode, 6597, new String[]{nextPair[1], EGLSQLKeywordHandler.getSQLClauseKeywordNamesCommaSeparatedString()});
                }
                ++i;
            }
        }
    }
}

