/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ValueForFormFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"value"));
        if (annotationBinding != null) {
            Object value = annotationBinding.getValue();
            if (containerBinding != null && 7 == containerBinding.getKind()) {
                FormFieldBinding fieldBinding = (FormFieldBinding)containerBinding;
                ITypeBinding targetTypeBinding = null;
                targetTypeBinding = fieldBinding.isConstant() ? PrimitiveTypeBinding.getInstance(Primitive.CHAR, Integer.MAX_VALUE) : fieldBinding.getType();
                if (targetTypeBinding != null && 3 == targetTypeBinding.getKind()) {
                    PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)targetTypeBinding;
                    Primitive prim = primTypeBinding.getPrimitive();
                    if (Primitive.isStringType(prim) || Primitive.NUM == prim || Primitive.NUMC == prim) {
                        if (value instanceof String || !Primitive.isStringType(prim) && value instanceof Number) {
                            if (Primitive.STRING != prim && !fieldBinding.isConstant()) {
                                IAnnotationBinding aBinding = fieldBinding.getAnnotation(new String[]{"egl", "ui"}, "FieldLen");
                                int maxLength = aBinding != null ? ((Integer)aBinding.getValue()).intValue() : primTypeBinding.getLength();
                                if (this.lengthWithoutBogusChars(value.toString()) > maxLength) {
                                    problemRequestor.acceptProblem(errorNode, 3182, new String[]{value.toString(), "value", String.valueOf(maxLength)});
                                }
                            }
                        } else {
                            problemRequestor.acceptProblem(errorNode, 5341, new String[]{"value", canonicalContainerName, fieldBinding.getDeclaringPart().getCaseSensitiveName()});
                        }
                    } else if (Primitive.isIntegerType(prim) && (value instanceof String || value instanceof Object[] || value instanceof IBinding)) {
                        problemRequestor.acceptProblem(errorNode, 3085, new String[]{"value"});
                    }
                }
            }
        }
    }

    private int lengthWithoutBogusChars(String input) {
        int len = 0;
        char[] chars = input.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != '\u200e' && chars[i] != '\u200f') {
                ++len;
            }
            ++i;
        }
        return len;
    }
}

