/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.name;

public class EGLNameToken {
    protected int type;
    protected String text = null;
    protected int offset;
    protected int line;
    protected int column;
    protected boolean subscript = false;
    private int firstDelimiter = 1;
    public static final int L_SQUARE = 1;
    public static final int R_SQUARE = 2;
    public static final int DOT = 3;
    public static final int COMMA = 4;
    public static final int COLON = 5;
    private int lastDelimiter = 5;
    public static final int IDENTIFIER = 6;
    public static final int REAL_NUMBER = 7;
    public static final int INTEGER = 8;
    public static final int FLOAT_NUMBER = 9;
    public static final int QUOTED_STRING = 10;
    public static final int UNKNOWN_EGL = 11;
    public static final int COMMENT = Integer.MAX_VALUE;

    public EGLNameToken(int tokenType, String tokenText, int tokenOffset, int tokenLine, int tokenColumn) {
        this.type = tokenType;
        this.text = tokenText;
        this.offset = tokenOffset;
        this.line = tokenLine;
        this.column = tokenColumn;
    }

    public boolean isDelimiter() {
        return this.type >= this.firstDelimiter && this.type <= this.lastDelimiter;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int off) {
        this.offset = off;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int inputLine) {
        this.line = inputLine;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int inputCol) {
        this.column = inputCol;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int inType) {
        this.type = inType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String inText) {
        this.text = inText;
    }

    public String toString() {
        return "[\"" + this.getText() + "\",<" + this.type + ">,offset=" + this.offset + ",line=" + this.line + ",column=" + this.column + "]";
    }
}

