/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.List;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ClassDataDeclarationValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ExternalTypeValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    private ExternalTypeBinding partBinding;
    private ICompilerOptions compilerOptions;

    public ExternalTypeValidator(IProblemRequestor problemRequestor, ExternalTypeBinding partBinding, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.partBinding = partBinding;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ExternalType externalType) {
        EGLNameValidator.validate(externalType.getName(), 38, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(externalType);
        if (this.checkHasSubtype(externalType)) {
            this.checkExtendedTypes(externalType);
        }
        return true;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        classDataDeclaration.accept(new ClassDataDeclarationValidator(this.problemRequestor, this.compilerOptions, this.partBinding));
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        nestedFunction.accept(new FunctionValidator(this.problemRequestor, this.partBinding, this.compilerOptions));
        this.checkParameters(nestedFunction.getFunctionParameters());
        return false;
    }

    @Override
    public boolean visit(Constructor constructor) {
        constructor.accept(new FunctionValidator(this.problemRequestor, this.partBinding, this.compilerOptions));
        this.checkParameters(constructor.getParameters());
        return false;
    }

    private void checkParameters(List parameters) {
        if (this.partBinding != null && this.partBinding.getSubType() != null && AbstractBinder.annotationIs(this.partBinding.getSubType(), new String[]{"eglx", "lang"}, "NativeType")) {
            return;
        }
        for (FunctionParameter parm : parameters) {
            if (!parm.isParmConst()) continue;
            this.problemRequestor.acceptProblem((Node)parm, 4961, new String[]{parm.getName().getCanonicalName()});
        }
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        settingsBlock.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                IDataBinding lhDBinding = assignment.getLeftHandSide().resolveDataBinding();
                if (lhDBinding != null && IBinding.NOT_FOUND_BINDING != lhDBinding) {
                    lhDBinding.getKind();
                }
                return false;
            }
        });
        return false;
    }

    private void checkExtendedTypes(ExternalType externalType) {
        for (Name nameAST : externalType.getExtendedTypes()) {
            ITypeBinding extendedType = (ITypeBinding)nameAST.resolveBinding();
            if (extendedType == null || IBinding.NOT_FOUND_BINDING == extendedType) continue;
            boolean typeIsValid = false;
            if (28 == extendedType.getKind()) {
                typeIsValid = true;
            }
            if (typeIsValid) continue;
            this.problemRequestor.acceptProblem((Node)nameAST, 3421, new String[]{extendedType.getCaseSensitiveName()});
        }
    }

    private boolean checkHasSubtype(ExternalType externalType) {
        boolean subtypeValid;
        if (externalType.hasSubType()) {
            boolean bl = subtypeValid = this.partBinding.getSubType() != null;
            if (this.partBinding.getSubType() != null && this.partBinding.getSubType().getName() == InternUtil.intern((String)"NativeType") && this.partBinding.getSubType().getPackageName() == InternUtil.intern((String[])new String[]{"egl", "core"})) {
                this.problemRequestor.acceptProblem((Node)externalType.getSubType(), 3458, new String[]{"NativeType".toUpperCase()});
                return false;
            }
        } else {
            this.problemRequestor.acceptProblem((Node)externalType.getName(), 3420, new String[]{externalType.getName().getCanonicalName()});
            subtypeValid = false;
        }
        return subtypeValid;
    }
}

