/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;

public abstract class FixedStructureValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    protected ICompilerOptions compilerOptions;
    protected String canonicalStructureName;
    protected FixedStructureBinding structureBinding;
    protected StructureItemValidatorFactory sItemValidatorFactory;

    public FixedStructureValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        if (structureItem.isEmbedded()) {
            this.sItemValidatorFactory.createStructureItemValidator().validateEmbeddedItem(structureItem);
        } else {
            StructureItemInfo sItemInfo = this.createStructureItemInfo(structureItem);
            if (sItemInfo != null) {
                this.sItemValidatorFactory.createStructureItemValidator().validate(sItemInfo);
            }
        }
        return false;
    }

    private StructureItemInfo createStructureItemInfo(StructureItem sItem) {
        StructureItemInfo result = new StructureItemInfo();
        IBinding binding = sItem.resolveBinding();
        if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        StructureItemBinding itemBinding = (StructureItemBinding)binding;
        if (sItem.isFiller()) {
            result.nodeForErrors = sItem;
            result.canonicalName = "*";
        } else {
            result.nodeForErrors = sItem.getName();
            result.canonicalName = sItem.getName().getCanonicalName();
        }
        result.binding = itemBinding;
        result.structureItemNode = sItem;
        return result;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    protected class DefaultStructureItemValidator
    extends StructureItemValidator {
        @Override
        public void validate(StructureItemInfo sItemInfo) {
            boolean itemIsLeaf;
            if (!sItemInfo.structureItemNode.isEmbedded() && !sItemInfo.structureItemNode.isFiller()) {
                EGLNameValidator.validate(sItemInfo.structureItemNode.getName(), 41, FixedStructureValidator.this.problemRequestor, FixedStructureValidator.this.compilerOptions);
            }
            if (sItemInfo.binding.numOccursDimensions() > 7) {
                FixedStructureValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 5033, new String[]{sItemInfo.canonicalName});
            }
            if (itemIsLeaf = sItemInfo.binding.getChildren().isEmpty()) {
                if (!sItemInfo.structureItemNode.hasType()) {
                    FixedStructureValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 4118, new String[]{sItemInfo.canonicalName, FixedStructureValidator.this.canonicalStructureName});
                }
            } else {
                int totalChildLength;
                int itemLengthWithoutOccurs;
                boolean checkLength = true;
                Type type = sItemInfo.structureItemNode.getType();
                if (type != null) {
                    if (type.isArrayType()) {
                        type = ((ArrayType)type).getElementType();
                    }
                    if (type.isPrimitiveType() && !((PrimitiveType)type).getPrimitive().hasDefaultLength()) {
                        checkLength = ((PrimitiveType)type).hasPrimLength();
                    }
                }
                if (checkLength && (itemLengthWithoutOccurs = this.getLengthWithoutOccurs(sItemInfo.binding)) != (totalChildLength = this.getTotalLengthOfChildren(sItemInfo.binding))) {
                    FixedStructureValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 5069, new String[]{sItemInfo.canonicalName, Integer.toString(itemLengthWithoutOccurs), Integer.toString(totalChildLength)});
                }
            }
            if (3 == sItemInfo.binding.getType().getKind()) {
                PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)sItemInfo.binding.getType();
                Primitive prim = primTypeBinding.getPrimitive();
                switch (prim.getType()) {
                    case 3: {
                        break;
                    }
                    case 0: 
                    case 19: 
                    case 21: 
                    case 22: {
                        FixedStructureValidator.this.problemRequestor.acceptProblem((Node)sItemInfo.structureItemNode.getType(), 4004, new String[]{prim.getName()});
                    }
                }
            }
        }

        @Override
        public void validateEmbeddedItem(StructureItem embeddedItem) {
        }

        @Override
        public void validatePart(FixedStructureBinding fixedStructureBinding) {
        }

        private int getLengthWithoutOccurs(StructureItemBinding sItemBinding) {
            int result = sItemBinding.getLengthInBytes();
            if (sItemBinding.hasOccurs()) {
                result /= sItemBinding.getOccurs();
            }
            return result;
        }

        private int getTotalLengthOfChildren(StructureItemBinding sItemBinding) {
            int sum = 0;
            for (StructureItemBinding siBinding : sItemBinding.getChildren()) {
                if (siBinding.getAnnotation(new String[]{"egl", "core"}, "Redefines") != null) continue;
                sum += siBinding.getLengthInBytes();
            }
            return sum;
        }
    }

    protected class DefaultStructureItemValidatorFactory
    extends StructureItemValidatorFactory {
        protected DefaultStructureItemValidatorFactory() {
        }

        @Override
        StructureItemValidator createStructureItemValidator() {
            return new DefaultStructureItemValidator();
        }
    }

    protected static final class StructureItemInfo {
        Node nodeForErrors;
        String canonicalName;
        StructureItem structureItemNode;
        StructureItemBinding binding;

        protected StructureItemInfo() {
        }
    }

    protected abstract class StructureItemValidator {
        public abstract void validate(StructureItemInfo var1);

        public abstract void validateEmbeddedItem(StructureItem var1);

        public abstract void validatePart(FixedStructureBinding var1);
    }

    protected abstract class StructureItemValidatorFactory {
        protected StructureItemValidatorFactory() {
        }

        abstract StructureItemValidator createStructureItemValidator();
    }
}

