/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.dli.stmtFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IDLIDataContainer;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IDLIDataContainerFactory;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IDLISegmentRecord;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IData;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPCB;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPCBStructure;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPSBRecord;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IRelationship;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DLIDataContainerFactory
implements IDLIDataContainerFactory {
    IDataBinding psbBinding;
    IDataBinding[] segmentBindings;
    DLIDataContainer dataContainer;
    HashMap bindingToDLISegmentRecordMap = new HashMap();
    private static final String[] EGLIODLI = new String[]{"egl", "io", "dli"};

    @Override
    public IDLIDataContainer createDLIDataContainer(IDataBinding psbBinding, IDataBinding[] segmentBindings) {
        this.dataContainer = new DLIDataContainer();
        this.psbBinding = psbBinding;
        this.segmentBindings = segmentBindings;
        this.dataContainer.setPSB(this.createPSB());
        this.dataContainer.setSegments(this.createSegments());
        return this.dataContainer;
    }

    private IDLISegmentRecord[] createSegments() {
        ArrayList<IDLISegmentRecord> list = new ArrayList<IDLISegmentRecord>();
        int i = 0;
        while (i < this.segmentBindings.length) {
            IDLISegmentRecord rec = this.createSegment(this.segmentBindings[i]);
            if (rec != null) {
                list.add(rec);
            }
            ++i;
        }
        return list.toArray(new IDLISegmentRecord[list.size()]);
    }

    private IDLISegmentRecord createSegment(IDataBinding binding) {
        ITypeBinding typeBinding = this.getBaseTypeBinding(binding);
        if (typeBinding == null) {
            return null;
        }
        if (binding.getAnnotation(EGLIODLI, "DLISegment") == null) {
            return null;
        }
        IDLISegmentRecord rec = this.createDLISegmentRecord(binding, false);
        if (rec != null) {
            rec.setName(binding.getName());
        }
        return rec;
    }

    private ITypeBinding getBaseTypeBinding(IDataBinding dataBinding) {
        if (dataBinding == null || dataBinding == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (dataBinding.getType() == null || dataBinding.getType() == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (dataBinding.getType().getBaseType() == null || dataBinding.getType().getBaseType() == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        return dataBinding.getType().getBaseType();
    }

    private IPSBRecord createPSB() {
        FlexibleRecordBinding psbTypeBinding = (FlexibleRecordBinding)this.getBaseTypeBinding(this.psbBinding);
        if (psbTypeBinding == null) {
            return null;
        }
        PSBRecord psbRec = new PSBRecord();
        psbRec.setName(this.psbBinding.getName());
        psbRec.setType(psbTypeBinding);
        psbRec.setPCBs(this.createPCBStructures(psbTypeBinding.getDeclaredFields(), psbRec));
        return psbRec;
    }

    private IPCBStructure[] createPCBStructures(List fieldBindings, IPSBRecord psb) {
        ArrayList<IPCBStructure> list = new ArrayList<IPCBStructure>();
        Iterator i = fieldBindings.iterator();
        while (i.hasNext()) {
            IPCBStructure pcb = this.createPCBStructure((FlexibleRecordFieldBinding)i.next(), psb);
            if (pcb == null) continue;
            list.add(pcb);
        }
        return list.toArray(new IPCBStructure[list.size()]);
    }

    private IPCBStructure createPCBStructure(FlexibleRecordFieldBinding binding, IPSBRecord psb) {
        String redefinesName = null;
        IAnnotationBinding annotationBinding = binding.getAnnotation(new String[]{"egl", "core"}, "Redefines");
        if (annotationBinding != null) {
            Object oValue = annotationBinding.getValue();
            if (oValue instanceof IBinding) {
                IBinding value = (IBinding)annotationBinding.getValue();
                if (value != null && value != IBinding.NOT_FOUND_BINDING) {
                    redefinesName = value.getName();
                }
            } else {
                redefinesName = (String)oValue;
            }
        }
        annotationBinding = binding.getAnnotation(EGLIODLI, "PCB");
        if (redefinesName == null && annotationBinding == null) {
            return null;
        }
        PCBStructure pcb = new PCBStructure();
        pcb.setRedefines(redefinesName);
        pcb.setType(binding.getType());
        pcb.setName(binding.getName());
        pcb.setPCB(this.createPCB(annotationBinding));
        pcb.setContainer(psb);
        return pcb;
    }

    private IPCB createPCB(IAnnotationBinding annotationBinding) {
        if (annotationBinding == null) {
            return null;
        }
        PCB pcb = new PCB();
        IAnnotationBinding subAnnotationBinding = this.getField(annotationBinding, "secondaryIndex");
        if (subAnnotationBinding != null) {
            pcb.setSecondaryIndex((String)subAnnotationBinding.getValue());
        }
        if ((subAnnotationBinding = this.getField(annotationBinding, "secondaryIndexItem")) != null) {
            pcb.setSecondaryIndexItemName((String)subAnnotationBinding.getValue());
        }
        if ((subAnnotationBinding = this.getField(annotationBinding, "pcbType")) != null) {
            pcb.setPCBType((EnumerationDataBinding)subAnnotationBinding.getValue());
        }
        pcb.setHierarchy(this.createRelationships(this.getField(annotationBinding, "hierarchy")));
        return pcb;
    }

    private IRelationship[] createRelationships(IAnnotationBinding annotationBinding) {
        if (annotationBinding == null) {
            return null;
        }
        Object[] objValue = (Object[])annotationBinding.getValue();
        if (objValue.length == 0) {
            return new Relationship[0];
        }
        IAnnotationBinding[] value = (IAnnotationBinding[])objValue;
        IRelationship[] relations = new Relationship[value.length];
        int i = 0;
        while (i < relations.length) {
            relations[i] = this.createRelationship(value[i]);
            ++i;
        }
        return relations;
    }

    private Relationship createRelationship(IAnnotationBinding annotationBinding) {
        Relationship relation = new Relationship();
        IAnnotationBinding subAnnotationBinding = this.getField(annotationBinding, "segmentRecord");
        if (subAnnotationBinding != null) {
            relation.setSegmentRecord(this.createDLISegmentRecord((ITypeBinding)subAnnotationBinding.getValue(), true));
        }
        if ((subAnnotationBinding = this.getField(annotationBinding, "parentRecord")) != null) {
            relation.setParentRecord(this.createDLISegmentRecord((ITypeBinding)subAnnotationBinding.getValue(), true));
        }
        return relation;
    }

    private IDLISegmentRecord createDLISegmentRecord(IBinding binding, boolean useCache) {
        IBinding value;
        DLISegmentRecord rec;
        if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (useCache && (rec = (DLISegmentRecord)this.bindingToDLISegmentRecordMap.get(binding)) != null) {
            return rec;
        }
        rec = new DLISegmentRecord();
        rec.setType(this.getBaseTypeBinding(binding));
        rec.setArray(this.isArray(binding));
        IAnnotationBinding annotationBinding = this.getField(binding.getAnnotation(EGLIODLI, "DLISegment"), "hostVarQualifier");
        if (annotationBinding != null) {
            rec.setHostVarQualifier((String)annotationBinding.getValue());
        }
        if ((annotationBinding = this.getField(binding.getAnnotation(EGLIODLI, "DLISegment"), "keyItem")) != null && (value = (IBinding)annotationBinding.getValue()) != null && value != IBinding.NOT_FOUND_BINDING) {
            StructureItemBinding siBinding = (StructureItemBinding)value;
            String qualName = siBinding.getParentQualifiedName();
            rec.setKeyItemName(qualName);
            String keyItemFieldName = siBinding.getName();
            if (binding.isDataBinding()) {
                IDataBinding dataBinding = (IDataBinding)binding;
                annotationBinding = dataBinding.getAnnotationFor(EGLIODLI, "DLIFieldName", new IDataBinding[]{siBinding});
                if (annotationBinding != null) {
                    keyItemFieldName = (String)annotationBinding.getValue();
                }
            } else {
                annotationBinding = siBinding.getAnnotation(EGLIODLI, "DLIFieldName");
                if (annotationBinding != null) {
                    keyItemFieldName = (String)annotationBinding.getValue();
                }
            }
            rec.setKeyItemFieldName(keyItemFieldName);
        }
        if ((annotationBinding = this.getField(binding.getAnnotation(EGLIODLI, "DLISegment"), "segmentName")) != null) {
            rec.setSegmentName((String)annotationBinding.getValue());
        }
        rec.setName(binding.getName());
        return rec;
    }

    private boolean isArray(IBinding binding) {
        IDataBinding dataBinding;
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 2;
        }
        if (binding.isDataBinding() && Binding.isValidBinding((dataBinding = (IDataBinding)binding).getType())) {
            return dataBinding.getType().getKind() == 2;
        }
        return false;
    }

    private ITypeBinding getBaseTypeBinding(IBinding binding) {
        IDataBinding dataBinding;
        if (binding.isTypeBinding()) {
            return (ITypeBinding)binding;
        }
        if (binding.isDataBinding() && (dataBinding = (IDataBinding)binding).getType() != null && dataBinding.getType() != IBinding.NOT_FOUND_BINDING) {
            return ((IDataBinding)binding).getType().getBaseType();
        }
        return null;
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        if (aBinding == null) {
            return null;
        }
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    private class DLIDataContainer
    implements IDLIDataContainer {
        IPSBRecord psbRecord;
        IDLISegmentRecord[] segments;

        private DLIDataContainer() {
        }

        @Override
        public IPSBRecord getPSB() {
            return this.psbRecord;
        }

        public void setPSB(IPSBRecord psbRecord) {
            this.psbRecord = psbRecord;
        }

        @Override
        public IDLISegmentRecord[] getSegments() {
            return this.segments;
        }

        public void setSegments(IDLISegmentRecord[] segments) {
            this.segments = segments;
        }
    }

    private class DLISegmentRecord
    extends Data
    implements IDLISegmentRecord {
        String segmentName;
        String keyItemName;
        String keyItemFieldName;
        String hostVarQualifier;
        boolean array;

        private DLISegmentRecord() {
        }

        @Override
        public boolean isDLISegmentRecord() {
            return true;
        }

        @Override
        public String getHostVarQualifier() {
            if (this.hostVarQualifier == null) {
                if (this.isArray() && this.getType() != null) {
                    return this.getType().getName();
                }
                return this.getName();
            }
            return this.hostVarQualifier;
        }

        public void setHostVarQualifier(String hostVarQualifier) {
            this.hostVarQualifier = hostVarQualifier;
        }

        @Override
        public String getKeyItemName() {
            return this.keyItemName;
        }

        public void setKeyItemName(String keyItemName) {
            this.keyItemName = keyItemName;
        }

        @Override
        public String getSegmentName() {
            if (this.segmentName == null) {
                return this.getType().getName();
            }
            return this.segmentName;
        }

        public void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public String getKeyItemFieldName() {
            return this.keyItemFieldName;
        }

        public void setKeyItemFieldName(String keyItemFieldName) {
            this.keyItemFieldName = keyItemFieldName;
        }

        @Override
        public boolean typeMatches(ITypeBinding compType) {
            if (this.getType() == compType) {
                return true;
            }
            if (!Binding.isValidBinding(this.getType()) || !Binding.isValidBinding(compType)) {
                return false;
            }
            if (InternUtil.intern((String)this.getType().getName()) != InternUtil.intern((String)compType.getName())) {
                return false;
            }
            if (this.getType().getKind() == compType.getKind() && this.getType() instanceof PartBinding) {
                String[] compPkgName;
                String[] pkgName = InternUtil.intern((String[])((PartBinding)this.getType()).getPackageName());
                return pkgName == (compPkgName = InternUtil.intern((String[])((PartBinding)compType).getPackageName()));
            }
            return false;
        }

        public boolean isArray() {
            return this.array;
        }

        public void setArray(boolean array) {
            this.array = array;
        }
    }

    private abstract class Data
    implements IData {
        ITypeBinding type;
        String name;

        private Data() {
        }

        @Override
        public boolean isDLISegmentRecord() {
            return false;
        }

        @Override
        public boolean isPSBRecord() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public ITypeBinding getType() {
            return this.type;
        }

        @Override
        public void setType(ITypeBinding type) {
            this.type = type;
        }
    }

    private class PCB
    implements IPCB {
        IRelationship[] eglHierarchy;
        String secondaryIndex;
        String secondaryIndexItemName;
        EnumerationDataBinding pCBType;

        private PCB() {
        }

        @Override
        public IRelationship[] getHierarchy() {
            return this.eglHierarchy;
        }

        public void setHierarchy(IRelationship[] relationship) {
            this.eglHierarchy = relationship;
        }

        @Override
        public String getSecondaryIndex() {
            return this.secondaryIndex;
        }

        public void setSecondaryIndex(String secondaryIndex) {
            this.secondaryIndex = secondaryIndex;
        }

        @Override
        public String getSecondaryIndexItemName() {
            if (this.secondaryIndexItemName == null) {
                return this.getSecondaryIndex();
            }
            return this.secondaryIndexItemName;
        }

        public void setSecondaryIndexItemName(String secondaryIndexItemName) {
            this.secondaryIndexItemName = secondaryIndexItemName;
        }

        @Override
        public EnumerationDataBinding getPCBType() {
            return this.pCBType;
        }

        public void setPCBType(EnumerationDataBinding type) {
            this.pCBType = type;
        }
    }

    private class PCBStructure
    extends Data
    implements IPCBStructure {
        String redefines;
        IPSBRecord container;
        IPCB PCB;

        private PCBStructure() {
        }

        public IPSBRecord getContainer() {
            return this.container;
        }

        public void setContainer(IPSBRecord container) {
            this.container = container;
        }

        @Override
        public IPCB getPCB() {
            PCBStructure redef;
            if (this.PCB == null && this.getContainer() != null && this.getRedefines() != null && (redef = (PCBStructure)this.getContainer().getPCBStructureNamed(this.getRedefines())) != null && redef.getRedefines() == null) {
                return redef.getPCB();
            }
            return this.PCB;
        }

        public void setPCB(IPCB eglpcb) {
            this.PCB = eglpcb;
        }

        public String getRedefines() {
            return this.redefines;
        }

        public void setRedefines(String redefines) {
            this.redefines = redefines;
        }
    }

    private class PSBRecord
    extends Data
    implements IPSBRecord {
        private IPCBStructure[] PCBs;

        private PSBRecord() {
        }

        @Override
        public boolean isPSBRecord() {
            return true;
        }

        @Override
        public IPCBStructure[] getPCBs() {
            return this.PCBs;
        }

        @Override
        public IPCBStructure[] getRealPCBs() {
            ArrayList<IPCBStructure> list = new ArrayList<IPCBStructure>();
            int i = 0;
            while (i < this.getPCBs().length) {
                if (((PCBStructure)this.getPCBs()[i]).getRedefines() == null) {
                    list.add(this.getPCBs()[i]);
                }
                ++i;
            }
            return list.toArray(new IPCBStructure[list.size()]);
        }

        @Override
        public IPCBStructure getPCBStructureNamed(String name) {
            if (this.getPCBs() == null || name == null) {
                return null;
            }
            String internedName = InternUtil.intern((String)name);
            int i = 0;
            while (i < this.getPCBs().length) {
                if (internedName == InternUtil.intern((String)this.getPCBs()[i].getName())) {
                    return this.getPCBs()[i];
                }
                ++i;
            }
            return null;
        }

        public void setPCBs(IPCBStructure[] bs) {
            this.PCBs = bs;
        }
    }

    private class Relationship
    implements IRelationship {
        IDLISegmentRecord ParentRecord;
        IDLISegmentRecord SegmentRecord;

        private Relationship() {
        }

        @Override
        public IDLISegmentRecord getParentRecord() {
            return this.ParentRecord;
        }

        public void setParentRecord(IDLISegmentRecord parentRecord) {
            this.ParentRecord = parentRecord;
        }

        @Override
        public IDLISegmentRecord getSegmentRecord() {
            return this.SegmentRecord;
        }

        public void setSegmentRecord(IDLISegmentRecord segmentRecord) {
            this.SegmentRecord = segmentRecord;
        }
    }
}

