/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.DynamicDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.LibraryDataBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLSystemConstantAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.InExpression;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.LikeMatchesExpression;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofStatement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BooleanLiteral;
import org.eclipse.edt.mof.egl.DBCharLiteral;
import org.eclipse.edt.mof.egl.DecimalLiteral;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DelegateInvocation;
import org.eclipse.edt.mof.egl.DynamicAccess;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FloatingPointLiteral;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.FunctionPartInvocation;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.IsAExpression;
import org.eclipse.edt.mof.egl.IsNotExpression;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.MBCharLiteral;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NumericLiteral;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartName;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.StringLiteral;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.SubstringAccess;
import org.eclipse.edt.mof.egl.TernaryExpression;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;

abstract class Egl2MofExpression
extends Egl2MofStatement {
    private Stack<org.eclipse.edt.mof.egl.Expression> sveStack = new Stack();
    private Stack<org.eclipse.edt.mof.egl.Type> sveTypeStack = new Stack();
    private Stack<LHSExpr> localStack = new Stack();

    Egl2MofExpression(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.AsExpression expr) {
        AsExpression asExpr = this.factory.createAsExpression();
        this.stack.push(asExpr);
        this.setElementInformation((Node)expr, (EObject)asExpr);
        expr.getExpression().accept(this);
        asExpr.setObjectExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        org.eclipse.edt.mof.egl.Type eType = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(expr.resolveTypeBinding());
        asExpr.setEType(eType);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ArrayAccess node) {
        node.getArray().accept(this);
        org.eclipse.edt.mof.egl.Expression arrayExpression = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
        ArrayAccess lastAC = null;
        int i = 0;
        while (i < node.getIndices().size()) {
            Expression indexExpr = (Expression)node.getIndices().get(i);
            indexExpr.accept(this);
            org.eclipse.edt.mof.egl.Expression index = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            ITypeBinding exprType = indexExpr.resolveTypeBinding();
            if (!Binding.isValidBinding(exprType)) {
                ArrayAccess ax = this.factory.createArrayAccess();
                ax.setIndex(index);
                ax.setArray(arrayExpression);
                lastAC = ax;
            } else {
                DynamicAccess ax;
                boolean isDynamicAccess = TypeUtils.isTextType((org.eclipse.edt.mof.egl.Type)((org.eclipse.edt.mof.egl.Type)this.mofTypeFor(exprType)));
                if (isDynamicAccess) {
                    ax = this.factory.createDynamicAccess();
                    ax.setAccess(index);
                    ax.setExpression(arrayExpression);
                    lastAC = ax;
                } else {
                    ax = this.factory.createArrayAccess();
                    ax.setIndex((org.eclipse.edt.mof.egl.Expression)IRUtils.createAsExpression((org.eclipse.edt.mof.egl.Expression)index, (org.eclipse.edt.mof.egl.Type)this.mofPrimitiveFor(Primitive.INT)));
                    ax.setArray(arrayExpression);
                    lastAC = ax;
                }
            }
            ++i;
        }
        this.setElementInformation((Node)node, (EObject)lastAC);
        this.stack.push(lastAC);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ArrayLiteral node) {
        ArrayList<org.eclipse.edt.mof.egl.Expression> entries = new ArrayList<org.eclipse.edt.mof.egl.Expression>();
        for (Expression expr : node.getExpressions()) {
            expr.accept(this);
            entries.add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        ArrayLiteral lit = this.factory.createArrayLiteral();
        lit.getEntries().addAll(entries);
        this.setElementInformation((Node)node, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Assignment assignment) {
        Assignment expr = this.factory.createAssignment();
        expr.setOperator(assignment.getOperator().toString());
        this.setElementInformation((Node)assignment, (EObject)expr);
        this.stack.push(expr);
        assignment.getLeftHandSide().accept(this);
        expr.setLHS((LHSExpr)this.eStackPop());
        assignment.getRightHandSide().accept(this);
        expr.setRHS((org.eclipse.edt.mof.egl.Expression)this.eStackPop());
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.BinaryExpression binExpr) {
        BinaryExpression expr = this.factory.createBinaryExpression();
        this.setElementInformation((Node)binExpr, (EObject)expr);
        this.stack.push(expr);
        binExpr.getFirstExpression().accept(this);
        org.eclipse.edt.mof.egl.Expression arg1 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        binExpr.getSecondExpression().accept(this);
        org.eclipse.edt.mof.egl.Expression arg2 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        expr.setLHS(arg1);
        expr.setRHS(arg2);
        expr.setOperator(binExpr.getOperator().toString());
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.BooleanLiteral literal) {
        BooleanLiteral lit = this.factory.createBooleanLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(CharLiteral literal) {
        org.eclipse.edt.mof.egl.CharLiteral lit = this.factory.createCharLiteral();
        lit.setValue(literal.getValue());
        lit.setIsHex(Boolean.valueOf(literal.isHex()));
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.DBCharLiteral literal) {
        DBCharLiteral lit = this.factory.createDBCharLiteral();
        lit.setValue(literal.getValue());
        lit.setIsHex(Boolean.valueOf(literal.isHex()));
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.MBCharLiteral literal) {
        MBCharLiteral lit = this.factory.createMBCharLiteral();
        lit.setValue(literal.getValue());
        lit.setIsHex(Boolean.valueOf(literal.isHex()));
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(FloatLiteral literal) {
        FloatingPointLiteral lit = this.factory.createFloatingPointLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.DecimalLiteral literal) {
        DecimalLiteral lit = this.factory.createDecimalLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(FieldAccess fieldAccess) {
        org.eclipse.edt.mof.egl.Type type = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(fieldAccess.getPrimary().resolveTypeBinding());
        if (TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)type)) {
            DynamicAccess expr = this.factory.createDynamicAccess();
            this.setElementInformation((Node)fieldAccess, (EObject)expr);
            StringLiteral index = this.factory.createStringLiteral();
            index.setValue(fieldAccess.getID());
            expr.setAccess((org.eclipse.edt.mof.egl.Expression)index);
            this.stack.push(expr);
            fieldAccess.getPrimary().accept(this);
            expr.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        } else {
            MemberAccess expr = this.factory.createMemberAccess();
            expr.setId(fieldAccess.getID());
            this.setElementInformation((Node)fieldAccess, (EObject)expr);
            this.stack.push(expr);
            fieldAccess.getPrimary().accept(this);
            expr.setQualifier((org.eclipse.edt.mof.egl.Expression)this.eStackPop());
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        DelegateInvocation fi;
        List functionParmBindings;
        ITypeBinding typeBinding = node.getTarget().resolveTypeBinding();
        if (typeBinding instanceof DelegateBinding) {
            functionParmBindings = ((DelegateBinding)typeBinding).getParemeters();
            fi = this.factory.createDelegateInvocation();
            fi.setId(typeBinding.getCaseSensitiveName());
            node.getTarget().accept(this);
            fi.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        } else {
            ITypeBinding targetBinding = node.getTarget().resolveTypeBinding();
            IFunctionBinding functionBinding = null;
            IPartBinding declarer = null;
            if (Binding.isValidBinding(targetBinding) && targetBinding instanceof IFunctionBinding) {
                functionBinding = (IFunctionBinding)targetBinding;
                functionParmBindings = functionBinding.getParameters();
                declarer = functionBinding.getDeclarer();
            } else {
                functionParmBindings = new ArrayList();
            }
            if (functionBinding instanceof TopLevelFunctionBinding) {
                fi = this.factory.createFunctionPartInvocation();
                String packageName = this.concatWithSeparator(((TopLevelFunctionBinding)functionBinding).getPackageName(), ".");
                ((FunctionPartInvocation)fi).setPackageName(packageName);
                fi.setId(functionBinding.getCaseSensitiveName());
            } else {
                String id;
                Member mbr;
                boolean isStatic;
                boolean bl = isStatic = Binding.isValidBinding(functionBinding) && (functionBinding.isStatic() || declarer instanceof LibraryBinding);
                if ((node.getTarget() instanceof SimpleName || node.getTarget() instanceof org.eclipse.edt.compiler.core.ast.ThisExpression) && !isStatic) {
                    if (functionBinding == null || this.isSuperTypeMember(functionBinding)) {
                        fi = this.factory.createQualifiedFunctionInvocation();
                        fi.setId(node.getTarget().getCanonicalString());
                        ThisExpression thisExpr = this.factory.createThisExpression();
                        thisExpr.setThisObject((Element)this.getCurrentFunctionMember().getContainer());
                        ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)thisExpr);
                    } else {
                        mbr = (Member)this.getEObjectFor(functionBinding);
                        id = null;
                        if (mbr instanceof FunctionMember) {
                            id = ((FunctionMember)mbr).getName();
                        } else if (Binding.isValidBinding(functionBinding)) {
                            id = functionBinding.getCaseSensitiveName();
                        }
                        fi = this.factory.createFunctionInvocation();
                        fi.setId(id);
                        ((org.eclipse.edt.mof.egl.FunctionInvocation)fi).setTarget(mbr);
                    }
                } else if (isStatic && node.getTarget() instanceof org.eclipse.edt.compiler.core.ast.Name) {
                    if (this.mofTypeFor(declarer) == this.currentPart) {
                        mbr = (Member)this.getEObjectFor(functionBinding);
                        id = null;
                        if (mbr instanceof FunctionMember) {
                            id = ((FunctionMember)mbr).getName();
                        } else if (Binding.isValidBinding(functionBinding)) {
                            id = functionBinding.getCaseSensitiveName();
                        }
                        fi = this.factory.createFunctionInvocation();
                        fi.setId(id);
                        ((org.eclipse.edt.mof.egl.FunctionInvocation)fi).setTarget(mbr);
                    } else {
                        fi = this.factory.createQualifiedFunctionInvocation();
                        fi.setId(functionBinding.getCaseSensitiveName());
                        PartName partName = this.factory.createPartName();
                        partName.setId(declarer.getCaseSensitiveName());
                        partName.setPackageName(this.concatWithSeparator(declarer.getPackageName(), "."));
                        this.setElementInformation((Node)node.getTarget(), (EObject)partName);
                        ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)partName);
                    }
                } else if (node.getTarget() instanceof FieldAccess) {
                    FieldAccess fa = (FieldAccess)node.getTarget();
                    if (fa.getPrimary() instanceof org.eclipse.edt.compiler.core.ast.ThisExpression) {
                        if (functionBinding == null || this.isSuperTypeMember(functionBinding)) {
                            fi = this.factory.createQualifiedFunctionInvocation();
                            fi.setId(fa.getID());
                            ThisExpression thisExpr = this.factory.createThisExpression();
                            thisExpr.setThisObject((Element)this.getCurrentFunctionMember().getContainer());
                            ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)thisExpr);
                        } else {
                            Member mbr2 = (Member)this.getEObjectFor(functionBinding);
                            String id2 = null;
                            if (mbr2 instanceof FunctionMember) {
                                id2 = ((FunctionMember)mbr2).getName();
                            } else if (Binding.isValidBinding(functionBinding)) {
                                id2 = functionBinding.getCaseSensitiveName();
                            }
                            fi = this.factory.createFunctionInvocation();
                            fi.setId(id2);
                            ((org.eclipse.edt.mof.egl.FunctionInvocation)fi).setTarget(mbr2);
                        }
                    } else {
                        fi = this.factory.createQualifiedFunctionInvocation();
                        fi.setId(fa.getID());
                        fa.getPrimary().accept(this);
                        ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
                    }
                } else if (node.getTarget() instanceof QualifiedName) {
                    fi = this.factory.createQualifiedFunctionInvocation();
                    QualifiedName name = (QualifiedName)node.getTarget();
                    fi.setId(name.getCaseSensitiveIdentifier());
                    name.getQualifier().accept(this);
                    ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
                } else {
                    fi = this.factory.createFunctionInvocation();
                    fi.setId(node.getTarget().getCanonicalString());
                }
            }
        }
        int index = 0;
        for (Expression argExpr : node.getArguments()) {
            argExpr.accept(this);
            org.eclipse.edt.mof.egl.Expression expr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            if (functionParmBindings.size() > 0) {
                if (functionParmBindings.size() > index) {
                    FunctionParameterBinding cfr_ignored_0 = (FunctionParameterBinding)functionParmBindings.get(index);
                } else {
                    FunctionParameterBinding cfr_ignored_1 = (FunctionParameterBinding)functionParmBindings.get(functionParmBindings.size() - 1);
                }
            }
            fi.getArguments().add(expr);
            ++index;
        }
        this.setElementInformation((Node)node, (EObject)fi);
        this.stack.push(fi);
        return false;
    }

    @Override
    public boolean visit(HexLiteral hexLiteral) {
        org.eclipse.edt.mof.egl.HexLiteral lit = this.factory.createHexLiteral();
        lit.setValue(hexLiteral.getValue());
        this.setElementInformation((Node)hexLiteral, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(InExpression inExpression) {
        TernaryExpression inExpr = this.factory.createTernaryExpression();
        this.setElementInformation((Node)inExpression, (EObject)inExpr);
        this.stack.push(inExpr);
        inExpression.getFirstExpression().accept(this);
        inExpr.setFirst((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        inExpression.getSecondExpression().accept(this);
        inExpr.setSecond((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        inExpr.setOperator("in");
        if (inExpression.getFromExpression() != null) {
            inExpression.getFromExpression().accept(this);
            inExpr.setThird((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(IntegerLiteral literal) {
        org.eclipse.edt.mof.egl.IntegerLiteral lit = this.factory.createIntegerLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.IsAExpression expr) {
        IsAExpression isaExpr = this.factory.createIsAExpression();
        this.setElementInformation((Node)expr, (EObject)isaExpr);
        this.stack.push(isaExpr);
        expr.getExpression().accept(this);
        isaExpr.setObjectExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        org.eclipse.edt.mof.egl.Type type = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(expr.getType().resolveTypeBinding());
        isaExpr.setEType(type);
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression parenExpr) {
        return true;
    }

    private Name createNameForPart(IPartBinding binding) {
        if (binding instanceof TopLevelFunctionBinding) {
            return this.factory.createTopLevelFunctionName();
        }
        if (binding instanceof LibraryBinding || binding instanceof DataTableBinding || binding instanceof ExternalTypeBinding || binding instanceof EnumerationTypeBinding || binding instanceof FormBinding || binding instanceof ProgramBinding) {
            String packageName;
            PartName name = this.factory.createPartName();
            if (binding instanceof FormBinding) {
                FormGroupBinding fg = ((FormBinding)binding).getEnclosingFormGroup();
                packageName = this.concatWithSeparator(fg == null ? binding.getPackageName() : fg.getPackageName(), ".");
            } else {
                packageName = this.concatWithSeparator(binding.getPackageName(), ".");
                if (packageName.equals("egl.core")) {
                    packageName = "egl.lang";
                }
            }
            name.setPackageName(packageName);
            name.setId(binding.getCaseSensitiveName());
            return name;
        }
        return this.factory.createDanglingReference();
    }

    @Override
    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (!Binding.isValidBinding(binding)) {
            Object invalid = this.currentPart instanceof FunctionPart ? this.factory.createDanglingReference() : this.factory.createInvalidName();
            invalid.setId(node.getCanonicalName());
            this.setElementInformation((Node)node, (EObject)invalid);
            this.stack.push(invalid);
            return false;
        }
        Object name = null;
        ITypeBinding part = null;
        if (binding instanceof IDataBinding && ((IDataBinding)binding).isStaticPartDataBinding()) {
            part = ((IDataBinding)binding).getType();
        } else if (binding instanceof IPartBinding) {
            part = (IPartBinding)binding;
        }
        name = part != null ? this.createNameForPart((IPartBinding)part) : this.factory.createMemberName();
        if (part instanceof FormBinding) {
            FormGroupBinding fg = ((FormBinding)part).getEnclosingFormGroup();
            String id = fg == null ? part.getCaseSensitiveName() : String.valueOf(fg.getCaseSensitiveName()) + "#" + part.getCaseSensitiveName();
            name.setId(id);
        } else if (binding instanceof DynamicDataBinding) {
            name.setId(node.getCaseSensitiveIdentifier());
        } else {
            name.setId(binding.getCaseSensitiveName());
        }
        IDataBinding qualifier = (IDataBinding)node.getAttribute(org.eclipse.edt.compiler.core.ast.Name.IMPLICIT_QUALIFIER_DATA_BINDING);
        if (qualifier == null && binding instanceof EnumerationDataBinding) {
            name = (Name)this.addQualifier((Element)this.createNameForPart(((EnumerationDataBinding)binding).getDeclaringPart()), (LHSExpr)name);
        }
        if (qualifier != null) {
            if (qualifier instanceof LibraryDataBinding) {
                name = (Name)this.addQualifier((Element)this.createNameForPart((IPartBinding)qualifier.getType()), (LHSExpr)name);
            } else {
                Element context = (Element)this.getEObjectFor(qualifier);
                name = (Name)this.addQualifier(context, (LHSExpr)name);
            }
        }
        if (name instanceof MemberName) {
            if (this.isSuperTypeMember(binding)) {
                ThisExpression thisExpr = this.factory.createThisExpression();
                thisExpr.setThisObject((Element)((Part)this.currentPart));
                name = (Name)this.addQualifier((Element)thisExpr, (LHSExpr)name);
            } else {
                EObject result = this.getEObjectFor(binding);
                if (result instanceof Member) {
                    Member mbr = (Member)result;
                    name.setMember(mbr);
                }
            }
        }
        this.setElementInformation((Node)node, (EObject)name);
        this.stack.push(name);
        return false;
    }

    @Override
    public boolean visit(QualifiedName name) {
        EObject objType = this.mofTypeFor(name.getQualifier().resolveTypeBinding());
        org.eclipse.edt.mof.egl.Type type = null;
        if (objType instanceof org.eclipse.edt.mof.egl.Type) {
            type = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(name.getQualifier().resolveTypeBinding());
        }
        if (TypeUtils.isDynamicType(type)) {
            DynamicAccess expr = this.factory.createDynamicAccess();
            this.setElementInformation((Node)name, (EObject)expr);
            StringLiteral index = this.factory.createStringLiteral();
            index.setValue(name.getCaseSensitiveIdentifier());
            expr.setAccess((org.eclipse.edt.mof.egl.Expression)index);
            this.stack.push(expr);
            name.getQualifier().accept(this);
            expr.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        } else {
            MemberAccess nameExpr = this.factory.createMemberAccess();
            this.setElementInformation((Node)name, (EObject)nameExpr);
            this.stack.push(nameExpr);
            nameExpr.setId(name.getCaseSensitiveIdentifier());
            IBinding qualBinding = name.getQualifier().resolveBinding();
            if (qualBinding instanceof PartBinding) {
                nameExpr.setQualifier((org.eclipse.edt.mof.egl.Expression)this.createNameForPart((IPartBinding)qualBinding));
            } else {
                name.getQualifier().accept(this);
                nameExpr.setQualifier((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            }
        }
        return false;
    }

    @Override
    public boolean visit(NullLiteral literal) {
        org.eclipse.edt.mof.egl.NullLiteral lit = this.factory.createNullLiteral();
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.StringLiteral literal) {
        StringLiteral lit = this.factory.createStringLiteral();
        lit.setValue(literal.getValue());
        lit.setIsHex(Boolean.valueOf(literal.isHex()));
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.IsNotExpression isNotExpression) {
        IsNotExpression expr = this.factory.createIsNotExpression();
        this.setElementInformation((Node)isNotExpression, (EObject)expr);
        this.stack.push(expr);
        isNotExpression.getFirstExpression().accept(this);
        expr.setExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        expr.setOperation(isNotExpression.getOperator().toString());
        SimpleName mnemonic = (SimpleName)isNotExpression.getSecondExpression();
        expr.setMnemonic(mnemonic.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(LikeMatchesExpression likeMatchesExpression) {
        TernaryExpression expr = this.factory.createTernaryExpression();
        this.setElementInformation((Node)likeMatchesExpression, (EObject)expr);
        this.stack.push(expr);
        likeMatchesExpression.getFirstExpression().accept(this);
        expr.setFirst((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        likeMatchesExpression.getSecondExpression().accept(this);
        expr.setSecond((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        expr.setOperator(likeMatchesExpression.getOperator().toString());
        if (likeMatchesExpression.getEscapeString() != null) {
            StringLiteral lit = this.factory.createStringLiteral();
            lit.setValue(likeMatchesExpression.getEscapeString());
            this.setElementInformation((Node)likeMatchesExpression, (EObject)lit);
            expr.setThird((org.eclipse.edt.mof.egl.Expression)lit);
        }
        return false;
    }

    @Override
    public boolean visit(NewExpression newExpression) {
        org.eclipse.edt.mof.egl.NewExpression expr = this.factory.createNewExpression();
        ITypeBinding type = newExpression.resolveTypeBinding();
        if (!Binding.isValidBinding(type)) {
            this.stack.push(expr);
            return false;
        }
        EObject obj = this.mofTypeFor(type);
        if (!(obj instanceof org.eclipse.edt.mof.egl.Type)) {
            this.stack.push(expr);
            return false;
        }
        org.eclipse.edt.mof.egl.Type mofType = (org.eclipse.edt.mof.egl.Type)obj;
        expr.setId(mofType.getTypeSignature());
        this.setElementInformation((Node)newExpression, (EObject)expr);
        for (Node node : newExpression.getArguments()) {
            node.accept(this);
            expr.getArguments().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        if (type.getKind() == 2) {
            this.processNewArray(newExpression.getType(), expr);
        }
        if (newExpression.getSettingsBlock() != null && newExpression.getSettingsBlock().getSettings().size() > 0) {
            org.eclipse.edt.mof.egl.SetValuesExpression sve = this.processSettings((org.eclipse.edt.mof.egl.Expression)expr, newExpression, mofType, newExpression.getSettingsBlock());
            this.setElementInformation((Node)newExpression, (EObject)sve);
            this.stack.push(sve);
        } else {
            this.stack.push(expr);
        }
        return false;
    }

    private void processNewArray(Type type, org.eclipse.edt.mof.egl.NewExpression expr) {
        if (type.isNullableType()) {
            this.processNewArray(type.getBaseType(), expr);
        }
        if (type.isArrayType()) {
            ArrayType arrType = (ArrayType)type;
            this.processNewArray(arrType.getElementType(), expr);
            if (arrType.hasInitialSize()) {
                arrType.getInitialSize().accept(this);
                expr.getArguments().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            } else {
                org.eclipse.edt.mof.egl.IntegerLiteral lit = this.factory.createIntegerLiteral();
                lit.setValue("0");
                this.setElementInformation((Node)type, (EObject)lit);
                expr.getArguments().add(lit);
            }
        }
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        EObject obj;
        setValuesExpression.getExpression().accept(this);
        org.eclipse.edt.mof.egl.Type targetType = null;
        if (Binding.isValidBinding(setValuesExpression.getExpression().resolveTypeBinding()) && (obj = this.mofTypeFor(setValuesExpression.getExpression().resolveTypeBinding())) instanceof org.eclipse.edt.mof.egl.Type) {
            targetType = (org.eclipse.edt.mof.egl.Type)obj;
        }
        org.eclipse.edt.mof.egl.SetValuesExpression sve = this.processSettings((org.eclipse.edt.mof.egl.Expression)this.stack.pop(), setValuesExpression.getExpression(), targetType, setValuesExpression.getSettingsBlock());
        this.setElementInformation((Node)setValuesExpression, (EObject)sve);
        this.stack.push(sve);
        return false;
    }

    private org.eclipse.edt.mof.egl.SetValuesExpression processSettings(org.eclipse.edt.mof.egl.Expression target, Expression targetNode, org.eclipse.edt.mof.egl.Type targetType, SettingsBlock settings) {
        if (!this.localStack.isEmpty() && target instanceof LHSExpr) {
            if (!this.sveTypeStack.isEmpty() && TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)this.sveTypeStack.peek())) {
                DynamicAccess da = this.factory.createDynamicAccess();
                this.setElementInformation((Node)settings, (EObject)da);
                LHSExpr newLHS = this.setAccessForDynamicAccess(da, target);
                da.setExpression((org.eclipse.edt.mof.egl.Expression)this.localStack.peek());
                target = newLHS;
            } else {
                target = this.addQualifier((Element)this.localStack.peek(), (LHSExpr)target);
            }
        }
        this.sveStack.push(target);
        this.sveTypeStack.push(targetType);
        org.eclipse.edt.mof.egl.SetValuesExpression sve = this.factory.createSetValuesExpression();
        sve.setTarget(target);
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)settings, (Statement)block);
        int arrayIndex = 0;
        MemberName localRef = null;
        Field decl = null;
        if (!(target instanceof LHSExpr)) {
            LocalVariableDeclarationStatement local = this.factory.createLocalVariableDeclarationStatement();
            DeclarationExpression declExpr = this.factory.createDeclarationExpression();
            decl = this.factory.createField();
            decl.setName("eze$SettingTarget" + this.sveStack.size());
            decl.setType(targetType);
            this.setElementInformation((Node)targetNode, (EObject)decl);
            declExpr.getFields().add(decl);
            local.setExpression(declExpr);
            this.setElementInformation((Node)targetNode, (Statement)local);
            Assignment assignExpr = this.factory.createAssignment();
            localRef = this.factory.createMemberName();
            localRef.setId(decl.getName());
            localRef.setMember((Member)decl);
            this.localStack.push((LHSExpr)localRef);
            assignExpr.setLHS((LHSExpr)localRef);
            assignExpr.setRHS(target);
            StatementBlock initializer = this.factory.createStatementBlock();
            AssignmentStatement stmt = this.createAssignmentStatement(assignExpr);
            this.setElementInformation((Node)targetNode, (Statement)stmt);
            initializer.getStatements().add(stmt);
            this.setElementInformation((Node)targetNode, (Statement)initializer);
            decl.setInitializerStatements(initializer);
            decl.setContainer(initializer.getContainer());
            block.getStatements().add(local);
        } else {
            this.localStack.push((LHSExpr)target);
        }
        for (Node setting : settings.getSettings()) {
            setting.accept(this);
            org.eclipse.edt.mof.egl.Expression setexpr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            LHSExpr ref = null;
            if (decl == null) {
                ref = (LHSExpr)target;
            } else {
                ref = this.factory.createMemberName();
                ((MemberName)ref).setId(decl.getName());
                ((MemberName)ref).setMember((Member)decl);
            }
            if (setexpr instanceof Assignment) {
                Assignment assign = (Assignment)setexpr;
                if (TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)targetType)) {
                    DynamicAccess da = this.factory.createDynamicAccess();
                    this.setElementInformation(setting, (EObject)da);
                    LHSExpr newLHS = this.setAccessForDynamicAccess(da, (org.eclipse.edt.mof.egl.Expression)assign.getLHS());
                    da.setExpression((org.eclipse.edt.mof.egl.Expression)ref);
                    assign.setLHS(newLHS);
                } else {
                    LHSExpr lhs = this.addQualifier((Element)ref, assign.getLHS());
                    assign.setLHS(lhs);
                }
                AssignmentStatement stmt = this.createAssignmentStatement(assign);
                this.setElementInformation(setting, (Statement)stmt);
                block.getStatements().add(stmt);
                continue;
            }
            if (setexpr instanceof org.eclipse.edt.mof.egl.SetValuesExpression) {
                org.eclipse.edt.mof.egl.SetValuesExpression ex = (org.eclipse.edt.mof.egl.SetValuesExpression)setexpr;
                for (AssignmentStatement stmt : ex.getSettings().getStatements()) {
                    block.getStatements().add(stmt);
                }
                continue;
            }
            org.eclipse.edt.mof.egl.IntegerLiteral indexExpr = this.factory.createIntegerLiteral();
            indexExpr.setValue(String.valueOf(++arrayIndex));
            QualifiedFunctionInvocation func = this.factory.createQualifiedFunctionInvocation();
            this.setElementInformation(setting, (EObject)func);
            func.setQualifier((org.eclipse.edt.mof.egl.Expression)ref);
            func.setId("appendElement");
            func.getArguments().add(setexpr);
            FunctionStatement stmt = this.factory.createFunctionStatement();
            stmt.setExpr((org.eclipse.edt.mof.egl.Expression)func);
            this.setElementInformation(setting, (Statement)stmt);
            block.getStatements().add(stmt);
        }
        sve.setSettings(block);
        this.sveStack.pop();
        this.sveTypeStack.pop();
        this.localStack.pop();
        return sve;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.SubstringAccess substringAccess) {
        SubstringAccess access = this.factory.createSubstringAccess();
        this.setElementInformation((Node)substringAccess, (EObject)access);
        this.stack.push(access);
        substringAccess.getExpr().accept(this);
        access.setStart((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        substringAccess.getExpr2().accept(this);
        access.setEnd((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        substringAccess.getPrimary().accept(this);
        access.setStringExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ThisExpression thisExpression) {
        ThisExpression expr = this.factory.createThisExpression();
        IBinding binding = thisExpression.resolveDataBinding();
        if (binding == null) {
            binding = thisExpression.resolveTypeBinding();
        }
        Element obj = (Element)this.getEObjectFor(binding);
        expr.setThisObject(obj);
        this.setElementInformation((Node)thisExpression, (EObject)expr);
        this.stack.push(expr);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.UnaryExpression unaryExpression) {
        boolean isBang;
        unaryExpression.getExpression().accept(this);
        org.eclipse.edt.mof.egl.Expression subExpr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
        boolean bl = isBang = unaryExpression.getOperator() == UnaryExpression.Operator.BANG;
        if (subExpr instanceof NumericLiteral && !isBang) {
            if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                ((NumericLiteral)subExpr).setIsNegated(Boolean.valueOf(true));
            }
            this.stack.push(subExpr);
        } else {
            UnaryExpression expr = this.factory.createUnaryExpression();
            this.setElementInformation((Node)unaryExpression, (EObject)expr);
            this.stack.push(expr);
            expr.setExpression(subExpr);
            expr.setOperator(unaryExpression.getOperator().toString());
        }
        return false;
    }

    private boolean isAny(ITypeBinding type) {
        PrimitiveTypeBinding primType;
        return Binding.isValidBinding(type) && type.getKind() == 3 && (primType = (PrimitiveTypeBinding)type).getPrimitive() == Primitive.ANY;
    }

    private boolean isFormBinding(ITypeBinding type) {
        return Binding.isValidBinding(type) && 8 == type.getKind();
    }

    private boolean isFormFieldBinding(IBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        if (!binding.isDataBinding()) {
            return false;
        }
        return ((IDataBinding)binding).getKind() == 7;
    }

    private boolean isNumeric(ITypeBinding type) {
        if (Binding.isValidBinding(type) && type.getKind() == 3) {
            PrimitiveTypeBinding primType = (PrimitiveTypeBinding)type;
            return Primitive.isNumericType(primType.getPrimitive());
        }
        return false;
    }

    private boolean isPartBinding(IBinding binding) {
        if (binding.isFunctionBinding()) {
            return false;
        }
        if (binding.isTypeBinding()) {
            return true;
        }
        if (binding.isDataBinding()) {
            IDataBinding dataBinding = (IDataBinding)binding;
            return dataBinding.getKind() == 10 || dataBinding.getKind() == 27 || dataBinding.getKind() == 11 || dataBinding.getKind() == 18 || dataBinding.getKind() == 8 || dataBinding.getKind() == 26;
        }
        return true;
    }

    private boolean isResourceAssociationBinding(IBinding binding) {
        return Binding.isValidBinding(binding) && binding.isDataBinding() && ((IDataBinding)binding).getKind() == 4 && "resourceAssociation".equalsIgnoreCase(binding.getName());
    }

    private boolean isSizeFunction(IDataBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        IAnnotationBinding ann = binding.getAnnotation(EGLSystemConstantAnnotationTypeBinding.getInstance());
        if (ann == null) {
            return false;
        }
        if (ann.getValue() instanceof Integer) {
            int value = (Integer)ann.getValue();
            return value == 138;
        }
        return false;
    }

    private boolean isStructureItemBinding(IBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        if (!binding.isDataBinding()) {
            return false;
        }
        return ((IDataBinding)binding).getKind() == 5;
    }

    private boolean isSuperTypeMember(IBinding binding) {
        if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        StructPart part = null;
        if (binding.isDataBinding()) {
            part = (StructPart)this.mofTypeFor(((IDataBinding)binding).getDeclaringPart());
        } else if (binding.isFunctionBinding()) {
            part = (StructPart)this.mofTypeFor(((IFunctionBinding)binding).getDeclarer());
        }
        StructPart current = (StructPart)this.currentPart;
        return part != null && current.equals((org.eclipse.edt.mof.egl.Type)part) == false && current.isSubtypeOf(part);
    }

    private boolean isWithPatternFunction(IDataBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        IAnnotationBinding ann = binding.getAnnotation(EGLSystemConstantAnnotationTypeBinding.getInstance());
        if (ann == null) {
            return false;
        }
        if (ann.getValue() instanceof Integer) {
            int value = (Integer)ann.getValue();
            return value == 237 || value == 235;
        }
        return false;
    }
}

