/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ConstantFormFieldBinding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.ProgramParameterBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.VariableFormFieldBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofPart;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.ConstantFormField;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DynamicAccess;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FormField;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.InvalidName;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.Parameter;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartName;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.StringLiteral;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.EList;

class Egl2MofMember
extends Egl2MofPart {
    Egl2MofMember(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(ClassDataDeclaration node) {
        ArrayList<EField> list = new ArrayList<EField>();
        for (org.eclipse.edt.compiler.core.ast.Name name : node.getNames()) {
            EField obj;
            IDataBinding field = name.resolveDataBinding();
            if (!Binding.isValidBinding(field)) {
                this.stack.push(null);
                return false;
            }
            if (this.inMofContext) {
                EField f = this.mof.createEField(true);
                this.setUpMofTypedElement((EMember)f, field);
                this.setInitialValue(node, f);
                obj = f;
            } else {
                EClass fieldClass = this.mofMemberTypeFor(field);
                Field f = (Field)fieldClass.newInstance();
                this.setUpEglTypedElement((TypedElement)f, field);
                if (field instanceof ClassFieldBinding) {
                    f.setIsStatic(java.lang.Boolean.valueOf(((ClassFieldBinding)field).isStatic()));
                }
                if (node.isPrivate()) {
                    f.setAccessKind(AccessKind.ACC_PRIVATE);
                }
                this.addInitializers(node, f, node.getType());
                obj = f;
            }
            this.eObjects.put(field, obj);
            this.setElementInformation(node, (EObject)obj);
            list.add(obj);
        }
        if (list.isEmpty()) {
            this.stack.push(null);
        } else if (list.size() == 1) {
            this.stack.push(list.get(0));
        } else {
            this.stack.push(list);
        }
        return false;
    }

    private void setMetadata(IDataBinding binding, EField field) {
        for (AnnotationBinding annotation : binding.getAnnotations()) {
            field.getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
        }
    }

    @Override
    public boolean visit(StructureItem node) {
        EField obj;
        IDataBinding field;
        IDataBinding iDataBinding = field = node.getName() == null ? (IDataBinding)node.resolveBinding() : node.getName().resolveDataBinding();
        if (!Binding.isValidBinding(field)) {
            this.stack.push(null);
            return false;
        }
        if (this.inMofContext) {
            EField f = this.mof.createEField(true);
            this.setUpMofTypedElement((EMember)f, field);
            this.setInitialValue(node, f);
            this.setMetadata(field, f);
            obj = f;
        } else {
            if (node.isEmbedded()) {
                this.stack.push(null);
                return false;
            }
            EClass fieldClass = this.mofMemberTypeFor(field);
            Field f = (Field)fieldClass.newInstance();
            this.setUpEglTypedElement((TypedElement)f, field);
            this.addInitializers(node, f, node.getType());
            if (f instanceof StructuredField) {
                StructuredField s = (StructuredField)f;
                if (node.getOccurs() == null) {
                    if (field instanceof StructureItemBinding) {
                        s.setOccurs(Integer.valueOf(((StructureItemBinding)field).getOccurs()));
                    } else {
                        s.setOccurs(Integer.valueOf(1));
                    }
                } else {
                    s.setOccurs(Integer.decode(node.getOccurs()));
                }
                StructureItemBinding parentBinding = ((StructureItemBinding)field).getParentItem();
                if (parentBinding != null) {
                    StructuredField parent = (StructuredField)this.getEObjectFor(parentBinding);
                    parent.addChild(s);
                }
                this.createElementAnnotations((StructureItemBinding)field, (StructuredField)f);
            }
            obj = f;
        }
        this.eObjects.put(field, obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ConstantFormField node) {
        ConstantFormFieldBinding binding = (ConstantFormFieldBinding)node.resolveBinding();
        if (!Binding.isValidBinding(binding)) {
            this.stack.push(null);
            return false;
        }
        ConstantFormField field = this.factory.createConstantFormField();
        field.setOccurs(Integer.valueOf(binding.getOccurs() == 0 ? 1 : binding.getOccurs()));
        this.createAnnotations((IBinding)binding, (Element)field);
        this.createElementAnnotations(binding, (FormField)field);
        this.setElementInformation(node, (EObject)field);
        this.stack.push(field);
        return false;
    }

    @Override
    public boolean visit(VariableFormField node) {
        VariableFormFieldBinding binding = (VariableFormFieldBinding)node.getName().resolveDataBinding();
        if (!Binding.isValidBinding(binding)) {
            this.stack.push(null);
            return false;
        }
        org.eclipse.edt.mof.egl.VariableFormField field = this.factory.createVariableFormField();
        field.setOccurs(Integer.valueOf(binding.getOccurs() == 0 ? 1 : binding.getOccurs()));
        this.setUpEglTypedElement((TypedElement)field, binding);
        this.createAnnotations((IBinding)binding, (Element)field);
        this.createElementAnnotations(binding, (FormField)field);
        this.eObjects.put(binding, field);
        this.stack.push(field);
        this.setElementInformation(node, (EObject)field);
        return false;
    }

    @Override
    public boolean visit(NestedFunction node) {
        NestedFunctionBinding function = (NestedFunctionBinding)node.getName().resolveDataBinding();
        if (!Binding.isValidBinding(function)) {
            this.stack.push(null);
            return false;
        }
        EFunction obj = null;
        if (this.inMofContext) {
            EFunction func = this.mof.createEFunction(true);
            this.setUpMofTypedElement((EMember)func, function);
            obj = func;
        } else {
            EClass funcClass = this.mofMemberTypeFor(function);
            Function func = (Function)funcClass.newInstance();
            if (func instanceof Operation) {
                IAnnotationBinding ann = this.getAnnotation(function.getType(), "Operation");
                ((Operation)func).setOpSymbol((String)this.getFieldValue(ann, "opSymbol"));
            }
            this.setUpEglTypedElement((TypedElement)func, function);
            func.setIsStatic(java.lang.Boolean.valueOf(node.isStatic()));
            if (!node.isAbstract() && !this.isEglSystemFunction(function)) {
                StatementBlock stmts = this.factory.createStatementBlock();
                stmts.setContainer((Container)func);
                func.setStatementBlock(stmts);
                this.functionsToProcess.add(node);
            }
            if (!node.getStmts().isEmpty() && node.getStmts().get(0) instanceof SettingsBlock) {
                this.processSettings((Element)func, (SettingsBlock)node.getStmts().get(0));
            }
            if (node.isPrivate()) {
                func.setAccessKind(AccessKind.ACC_PRIVATE);
            }
            obj = func;
        }
        for (FunctionParameter parm : node.getFunctionParameters()) {
            parm.accept(this);
            if (this.inMofContext) {
                obj.addMember((EMember)((EParameter)this.stack.pop()));
                continue;
            }
            ((FunctionMember)obj).addMember((Member)((Parameter)this.stack.pop()));
        }
        this.eObjects.put(function.getType(), obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor node) {
        org.eclipse.edt.compiler.core.ast.Part etAST = (org.eclipse.edt.compiler.core.ast.Part)node.getParent();
        IPartBinding constBinding = (IPartBinding)etAST.getName().resolveBinding();
        if (!Binding.isValidBinding(constBinding)) {
            this.stack.push(null);
            return false;
        }
        ConstructorBinding constructor = node.getBinding();
        Constructor obj = null;
        if (this.inMofContext) {
            obj = null;
        } else {
            EClass constClass = this.mofMemberTypeFor(constructor);
            Constructor cons = (Constructor)constClass.newInstance();
            if (node.getStmts() != null) {
                StatementBlock stmts = this.factory.createStatementBlock();
                stmts.setContainer((Container)cons);
                cons.setStatementBlock(stmts);
                this.functionsToProcess.add(node);
            }
            if (node.isPrivate()) {
                cons.setAccessKind(AccessKind.ACC_PRIVATE);
            }
            this.setUpEglTypedElement((TypedElement)cons, constructor);
            obj = cons;
        }
        for (FunctionParameter parm : node.getParameters()) {
            parm.accept(this);
            if (this.inMofContext) {
                ((EFunction)obj).addMember((EMember)((EParameter)this.stack.pop()));
                continue;
            }
            ((FunctionMember)obj).addMember((Member)((Parameter)this.stack.pop()));
        }
        this.eObjects.put(constructor.getType(), obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(FunctionParameter node) {
        EParameter obj;
        FunctionParameterBinding parameter = (FunctionParameterBinding)node.getName().resolveDataBinding();
        if (!Binding.isValidBinding(parameter)) {
            this.stack.push(null);
            return false;
        }
        if (this.inMofContext) {
            EParameter parm = this.mof.createEParameter(true);
            parm.setName(parameter.getCaseSensitiveName());
            this.setUpMofTypedElement((EMember)parm, parameter);
            obj = parm;
        } else {
            org.eclipse.edt.mof.egl.FunctionParameter parm = this.factory.createFunctionParameter();
            ParameterKind parmKind = parameter.isInput() ? ParameterKind.PARM_IN : (parameter.isInputOutput() ? ParameterKind.PARM_INOUT : (parameter.isOutput() ? ParameterKind.PARM_OUT : ParameterKind.PARM_INOUT));
            parm.setParameterKind(parmKind);
            parm.setIsConst(java.lang.Boolean.valueOf(parameter.isConst()));
            parm.setIsField(java.lang.Boolean.valueOf(parameter.isField()));
            parm.setIsDefinedSqlNullable(java.lang.Boolean.valueOf(parameter.isSQLNullable()));
            this.setUpEglTypedElement((TypedElement)parm, parameter);
            obj = parm;
        }
        this.eObjects.put(parameter, obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(ProgramParameter node) {
        ProgramParameterBinding parameter = (ProgramParameterBinding)node.getName().resolveDataBinding();
        if (!Binding.isValidBinding(parameter)) {
            this.stack.push(null);
            return false;
        }
        org.eclipse.edt.mof.egl.ProgramParameter parm = this.factory.createProgramParameter();
        this.setUpEglTypedElement((TypedElement)parm, parameter);
        this.eObjects.put(parameter, parm);
        this.setElementInformation(node, (EObject)parm);
        this.stack.push(parm);
        return false;
    }

    @Override
    public boolean visit(SettingsBlock node) {
        this.stack.push(null);
        return false;
    }

    @Override
    public boolean visit(EnumerationField enumField) {
        if (Binding.isValidBinding(enumField.getName().resolveDataBinding())) {
            EnumerationDataBinding binding = (EnumerationDataBinding)enumField.getName().resolveDataBinding();
            Integer value = binding.geConstantValue();
            if (this.inMofContext) {
                EEnumLiteral literal = (EEnumLiteral)this.mof.getEEnumLiteralClass().newInstance();
                literal.setName(binding.getCaseSensitiveName());
                literal.setValue(value.intValue());
                this.stack.push(literal);
            } else {
                EnumerationEntry entry = this.factory.createEnumerationEntry();
                entry.setName(binding.getCaseSensitiveName());
                entry.setValue(value.intValue());
                this.eObjects.put(binding, entry);
                this.setElementInformation(enumField, (EObject)entry);
                this.stack.push(entry);
            }
        }
        return false;
    }

    public void setUpMofTypedElement(EMember obj, IDataBinding edtObj) {
        EObject eObj = this.mofTypeFromTypedElement(edtObj);
        if (eObj instanceof EType) {
            IAnnotationBinding mofName;
            EType type = (EType)eObj;
            obj.setEType(type);
            if (edtObj.getType().isNullable()) {
                obj.setIsNullable(true);
            }
            if (obj instanceof EField) {
                IAnnotationBinding ann = this.getAnnotation(edtObj, "transient");
                if (ann != null) {
                    ((EField)obj).setIsTransient(((java.lang.Boolean)this.getValue(edtObj, ann.getValue(), false)).booleanValue());
                }
                if ((ann = this.getAnnotation(edtObj, "containment")) != null) {
                    ((EField)obj).setContainment(((java.lang.Boolean)this.getValue(edtObj, ann.getValue(), false)).booleanValue());
                }
            }
            if ((mofName = this.getAnnotation(edtObj, "mofName")) != null) {
                obj.setName((String)this.getValue(null, mofName.getValue(), false));
            } else {
                obj.setName(edtObj.getCaseSensitiveName());
            }
        }
    }

    protected LHSExpr setAccessForDynamicAccess(DynamicAccess da, org.eclipse.edt.mof.egl.Expression expr) {
        if (expr == null) {
            return da;
        }
        if (expr instanceof MemberName) {
            StringLiteral index = this.factory.createStringLiteral();
            index.setValue(((MemberName)expr).getId());
            da.setAccess((org.eclipse.edt.mof.egl.Expression)index);
            return da;
        }
        if (expr instanceof DynamicAccess) {
            DynamicAccess oldDA = (DynamicAccess)expr;
            this.setAccessForDynamicAccess(da, oldDA.getExpression());
            if (oldDA.getExpression() instanceof MemberName) {
                oldDA.setExpression((org.eclipse.edt.mof.egl.Expression)da);
            }
            return oldDA;
        }
        if (expr instanceof ArrayAccess) {
            ArrayAccess oldAA = (ArrayAccess)expr;
            this.setAccessForDynamicAccess(da, oldAA.getArray());
            if (oldAA.getArray() instanceof MemberName) {
                oldAA.setArray((org.eclipse.edt.mof.egl.Expression)da);
            }
            return oldAA;
        }
        return null;
    }

    public void processSettings(Element context, SettingsBlock settings) {
        StatementBlock block = null;
        int arrayIndex = 0;
        for (Node expr : settings.getSettings()) {
            org.eclipse.edt.mof.egl.Expression qualifier;
            AssignmentStatement stmt;
            if (expr instanceof AnnotationExpression && ((AnnotationExpression)expr).getName().resolveDataBinding() instanceof AnnotationBinding) {
                Annotation value = (Annotation)this.mofValueFrom(((AnnotationExpression)expr).getName().resolveDataBinding());
                context.getAnnotations().add(value);
                continue;
            }
            if (expr instanceof org.eclipse.edt.compiler.core.ast.Assignment) {
                org.eclipse.edt.compiler.core.ast.Assignment assignment = (org.eclipse.edt.compiler.core.ast.Assignment)expr;
                Expression lhsExpr = assignment.getLeftHandSide();
                if (!Binding.isValidBinding(lhsExpr.resolveDataBinding())) continue;
                if (lhsExpr.resolveDataBinding() instanceof IAnnotationBinding) {
                    Annotation value = (Annotation)this.mofValueFrom(lhsExpr.resolveDataBinding());
                    context.getAnnotations().add(value);
                    continue;
                }
                if (context instanceof Part) {
                    if (context.getEClass().getEField(((org.eclipse.edt.compiler.core.ast.Name)lhsExpr).getNameComponents()[0]) == null) continue;
                    EField field = context.getEClass().getEField(((org.eclipse.edt.compiler.core.ast.Name)lhsExpr).getNameComponents()[0]);
                    Object value = this.evaluateExpression(assignment.getRightHandSide());
                    context.eSet(field, value);
                    continue;
                }
                expr.accept(this);
                Assignment assign = (Assignment)this.stack.pop();
                org.eclipse.edt.mof.egl.Type type = null;
                if (context instanceof TypedElement) {
                    type = ((TypedElement)context).getType();
                }
                if (TypeUtils.isDynamicType(type)) {
                    DynamicAccess da = this.factory.createDynamicAccess();
                    this.setElementInformation(expr, (EObject)da);
                    LHSExpr newLHS = this.setAccessForDynamicAccess(da, (org.eclipse.edt.mof.egl.Expression)assign.getLHS());
                    if (context instanceof org.eclipse.edt.mof.egl.Expression) {
                        da.setExpression((org.eclipse.edt.mof.egl.Expression)context);
                    } else if (context instanceof Member) {
                        MemberName exp = this.factory.createMemberName();
                        exp.setId(((Member)context).getName());
                        exp.setMember((Member)context);
                        da.setExpression((org.eclipse.edt.mof.egl.Expression)exp);
                    }
                    assign.setLHS(newLHS);
                } else {
                    assign.setLHS(this.addQualifier(context, assign.getLHS()));
                }
                if (block == null) {
                    block = this.factory.createStatementBlock();
                }
                stmt = this.createAssignmentStatement(assign);
                this.setElementInformation(expr, (EObject)stmt);
                block.getStatements().add(stmt);
                continue;
            }
            if (expr instanceof SetValuesExpression && ((SetValuesExpression)expr).getExpression() instanceof AnnotationExpression) {
                IAnnotationBinding annBinding;
                if (!(((AnnotationExpression)((SetValuesExpression)expr).getExpression()).resolveDataBinding() instanceof IAnnotationBinding) || !Binding.isValidBinding(annBinding = (IAnnotationBinding)((AnnotationExpression)((SetValuesExpression)expr).getExpression()).resolveDataBinding()) || this.isEMetadataObject(annBinding)) continue;
                Annotation value = (Annotation)this.evaluateExpression(expr);
                context.getAnnotations().add(value);
                continue;
            }
            expr.accept(this);
            Element result = (Element)this.stack.pop();
            if (block == null) {
                block = this.factory.createStatementBlock();
            }
            if (result instanceof StatementBlock) {
                for (Statement stmt2 : ((StatementBlock)result).getStatements()) {
                    if (stmt2 instanceof AssignmentStatement) {
                        Assignment assignExpr = ((AssignmentStatement)stmt2).getAssignment();
                        LHSExpr lhs = this.addQualifier(context, assignExpr.getLHS());
                        assignExpr.setLHS(lhs);
                    }
                    block.getStatements().add(stmt2);
                }
                continue;
            }
            if (result instanceof org.eclipse.edt.mof.egl.SetValuesExpression) {
                org.eclipse.edt.mof.egl.SetValuesExpression sve = (org.eclipse.edt.mof.egl.SetValuesExpression)result;
                for (Statement stmt3 : sve.getSettings().getStatements()) {
                    if (stmt3 instanceof AssignmentStatement) {
                        Assignment assignExpr = ((AssignmentStatement)stmt3).getAssignment();
                        org.eclipse.edt.mof.egl.Type type = null;
                        if (context instanceof TypedElement) {
                            type = ((TypedElement)context).getType();
                        }
                        if (TypeUtils.isDynamicType(type)) {
                            DynamicAccess da = this.factory.createDynamicAccess();
                            this.setElementInformation(expr, (EObject)da);
                            LHSExpr newLHS = this.setAccessForDynamicAccess(da, (org.eclipse.edt.mof.egl.Expression)assignExpr.getLHS());
                            if (context instanceof org.eclipse.edt.mof.egl.Expression) {
                                da.setExpression((org.eclipse.edt.mof.egl.Expression)context);
                            } else if (context instanceof Member) {
                                MemberName exp = this.factory.createMemberName();
                                exp.setId(((Member)context).getName());
                                exp.setMember((Member)context);
                                da.setExpression((org.eclipse.edt.mof.egl.Expression)exp);
                            }
                            assignExpr.setLHS(newLHS);
                        } else {
                            LHSExpr lhs = this.addQualifier(context, assignExpr.getLHS());
                            assignExpr.setLHS(lhs);
                        }
                    }
                    block.getStatements().add(stmt3);
                }
                continue;
            }
            ++arrayIndex;
            if (context instanceof Member) {
                qualifier = this.factory.createMemberName();
                ((MemberName)qualifier).setId(((Member)context).getId());
                ((MemberName)qualifier).setMember((Member)context);
            } else {
                qualifier = (org.eclipse.edt.mof.egl.Expression)context;
            }
            org.eclipse.edt.mof.egl.IntegerLiteral indexExpr = this.factory.createIntegerLiteral();
            indexExpr.setValue(String.valueOf(arrayIndex));
            QualifiedFunctionInvocation func = this.factory.createQualifiedFunctionInvocation();
            this.setElementInformation(expr, (EObject)func);
            func.setQualifier(qualifier);
            func.setId("appendElement");
            func.getArguments().add((org.eclipse.edt.mof.egl.Expression)result);
            stmt = this.factory.createFunctionStatement();
            this.setElementInformation(expr, (EObject)stmt);
            stmt.setExpr((org.eclipse.edt.mof.egl.Expression)func);
            block.getStatements().add(stmt);
        }
        if (block != null && !(context instanceof Part) && context instanceof Field) {
            ((Field)context).setInitializerStatements(block);
        }
    }

    public Object evaluateExpression(Node expr) {
        Object value = null;
        if (expr instanceof ArrayLiteral) {
            value = new EList();
            for (Expression ex : ((ArrayLiteral)expr).getExpressions()) {
                ((List)value).add(this.evaluateExpression(ex));
            }
        } else if (expr instanceof BooleanLiteral) {
            value = ((BooleanLiteral)expr).booleanValue() == Boolean.YES ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE;
        } else if (expr instanceof IntegerLiteral) {
            try {
                value = Integer.parseInt(((IntegerLiteral)expr).getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (expr instanceof org.eclipse.edt.compiler.core.ast.StringLiteral) {
            value = ((org.eclipse.edt.compiler.core.ast.StringLiteral)expr).getValue();
        } else if (expr instanceof FloatLiteral) {
            try {
                value = Float.valueOf(Float.parseFloat(((FloatLiteral)expr).getValue()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (expr instanceof AnnotationExpression) {
            ITypeBinding typeBinding = ((AnnotationExpression)expr).resolveTypeBinding();
            EClass annType = (EClass)this.mofTypeFor(typeBinding);
            if (annType != null) {
                value = annType.newInstance();
            }
        } else if (expr instanceof SetValuesExpression) {
            value = this.evaluateExpression(((SetValuesExpression)expr).getExpression());
            if (((SetValuesExpression)expr).getSettingsBlock() != null) {
                this.executeSettings(value, ((SetValuesExpression)expr).getSettingsBlock());
            }
        } else if (expr instanceof org.eclipse.edt.compiler.core.ast.Name) {
            expr.accept(this);
            value = this.stack.pop();
        }
        return value;
    }

    public void executeSettings(Object context, SettingsBlock settings) {
        if (settings == null) {
            return;
        }
        for (Node setting : settings.getSettings()) {
            Object value;
            if (context instanceof List) {
                ((List)context).add(this.evaluateExpression(setting));
                continue;
            }
            if (!(context instanceof Annotation)) continue;
            EObject target = (EObject)context;
            if (setting instanceof org.eclipse.edt.compiler.core.ast.Assignment) {
                org.eclipse.edt.compiler.core.ast.Assignment assignment = (org.eclipse.edt.compiler.core.ast.Assignment)setting;
                org.eclipse.edt.compiler.core.ast.Name nameExpr = (org.eclipse.edt.compiler.core.ast.Name)assignment.getLeftHandSide();
                Object source = null;
                EField field = target.getEClass().getEField(nameExpr.getNameComponents()[0]);
                if (field == null) {
                    source = this.mofValueFrom(nameExpr.resolveBinding());
                    ((Element)target).getAnnotations().add((Annotation)source);
                    continue;
                }
                source = this.evaluateExpression(assignment.getRightHandSide());
                String[] names = nameExpr.getNameComponents();
                if (nameExpr.getNameComponents().length > 1) {
                    int i = 1;
                    while (i < names.length) {
                        target = (EObject)target.eGet(field);
                        field = target.getEClass().getEField(names[i]);
                        ++i;
                    }
                }
                this.eSet(target, field, source);
                continue;
            }
            if (setting instanceof SetValuesExpression) {
                value = (Annotation)this.evaluateExpression(setting);
                ((Element)target).getAnnotations().add(value);
                continue;
            }
            value = this.evaluateExpression(setting);
            this.eSet(target, (EField)target.getEClass().getEFields().get(0), value);
        }
    }

    public void setInitialValue(StructureItem node, EField field) {
        this.setInitialValue(node.getInitializer(), node.getSettingsBlock(), field);
    }

    public void setInitialValue(ClassDataDeclaration node, EField field) {
        this.setInitialValue(node.getInitializer(), node.getSettingsBlockOpt(), field);
    }

    public void setInitialValue(Expression initializer, SettingsBlock settings, EField field) {
        Object value = null;
        if (initializer != null) {
            if (initializer instanceof LiteralExpression && this.inAnnotationTypeContext && !this.inEMetadataTypeContext) {
                initializer.accept(this);
                value = this.stack.pop();
            } else {
                value = this.evaluateExpression(initializer);
            }
        } else if (settings != null && this.isInitializer(settings)) {
            EType type = field.getEType();
            value = type instanceof EClass ? ((EClass)type).newInstance() : new EList();
            this.executeSettings(value, settings);
        }
        field.setInitialValue(value);
    }

    public boolean isInitializer(SettingsBlock settings) {
        for (Node expr : settings.getSettings()) {
            org.eclipse.edt.compiler.core.ast.Assignment assignment;
            org.eclipse.edt.compiler.core.ast.Name nameExpr;
            if (!(expr instanceof org.eclipse.edt.compiler.core.ast.Assignment ? !((nameExpr = (org.eclipse.edt.compiler.core.ast.Name)(assignment = (org.eclipse.edt.compiler.core.ast.Assignment)expr).getLeftHandSide()).resolveDataBinding() instanceof IAnnotationBinding) : !(expr instanceof AnnotationExpression))) continue;
            return true;
        }
        return false;
    }

    public boolean isEglSystemFunction(NestedFunctionBinding func) {
        return func.getAnnotation(AnnotationTypeManager.getAnnotationType(InternUtil.intern((String)"eglSystemConstant"))) != null;
    }

    public void addInitializers(StructureItem node, Field field, Type type) {
        this.addInitializers(node.getInitializer(), node.getSettingsBlock(), field, type);
    }

    public void addInitializers(ClassDataDeclaration node, Field field, Type type) {
        this.addInitializers(node.getInitializer(), node.getSettingsBlockOpt(), field, type);
    }

    public void addInitializers(Expression initializer, SettingsBlock settingsBlock, Field field, Type type) {
        if (field.getType() == null) {
            return;
        }
        if (initializer != null) {
            if (settingsBlock != null) {
                this.processSettings((Element)field, settingsBlock);
            }
            if (field.getInitializerStatements() == null) {
                field.setInitializerStatements(this.factory.createStatementBlock());
            }
            this.setElementInformation(initializer, (EObject)field.getInitializerStatements());
            initializer.accept(this);
            org.eclipse.edt.mof.egl.Expression expr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            AssignmentStatement stmt = this.createAssignmentStatement(field, expr);
            this.setElementInformation(initializer, (EObject)stmt);
            field.getInitializerStatements().getStatements().add(stmt);
            field.setHasSetValuesBlock(java.lang.Boolean.valueOf(true));
        } else if (settingsBlock != null) {
            this.processSettings((Element)field, settingsBlock);
        }
    }

    public AssignmentStatement createAssignmentStatement(Element context, org.eclipse.edt.mof.egl.Expression rhs) {
        if (context instanceof Field) {
            return this.createAssignmentStatement((Field)context, rhs);
        }
        if (context instanceof org.eclipse.edt.mof.egl.Expression) {
            return this.createAssignmentStatement((Element)((org.eclipse.edt.mof.egl.Expression)context), rhs);
        }
        throw new IllegalArgumentException("Context " + context.toString() + " must be a Field or Expression");
    }

    public AssignmentStatement createAssignmentStatement(Field field, org.eclipse.edt.mof.egl.Expression rhs) {
        Assignment assign = this.factory.createAssignment();
        assign.setRHS(rhs);
        MemberName nameExpr = this.factory.createMemberName();
        nameExpr.setMember((Member)field);
        nameExpr.setId(field.getName());
        assign.setLHS((LHSExpr)nameExpr);
        return this.createAssignmentStatement(assign);
    }

    public AssignmentStatement createAssignmentStatement(Assignment assign) {
        AssignmentStatement stmt = this.factory.createAssignmentStatement();
        stmt.setExpr((org.eclipse.edt.mof.egl.Expression)assign);
        return stmt;
    }

    public LHSExpr addQualifier(Element context, LHSExpr expr) {
        if (context instanceof Member) {
            return this.addQualifier((Member)context, expr);
        }
        if (context instanceof org.eclipse.edt.mof.egl.Expression) {
            if (expr instanceof InvalidName) {
                return expr;
            }
            return expr.addQualifier((org.eclipse.edt.mof.egl.Expression)context);
        }
        throw new IllegalArgumentException("Qualifier " + context.toString() + " must be a Member or Expression");
    }

    public LHSExpr addQualifier(Member context, LHSExpr lhsExpr) {
        MemberName qualifier = this.createMemberName(context);
        return lhsExpr.addQualifier((org.eclipse.edt.mof.egl.Expression)qualifier);
    }

    public MemberName createMemberName(Member context) {
        MemberName mbrName = this.factory.createMemberName();
        mbrName.setId(context.getName());
        mbrName.setMember(context);
        return mbrName;
    }

    public LHSExpr addQualifier(Part context, Name nameExpr) {
        PartName qualifier = this.factory.createPartName();
        qualifier.setId(context.getName());
        qualifier.setType((org.eclipse.edt.mof.egl.Type)context);
        qualifier.setPackageName(context.getPackageName());
        return nameExpr.addQualifier((org.eclipse.edt.mof.egl.Expression)qualifier);
    }
}

