/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.services;

import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.egl2mof.AbstractIOStatementGenerator;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.eglx.services.ServicesCallStatement;
import org.eclipse.edt.mof.eglx.services.ServicesFactory;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class ServicesActionStatementGenerator
extends AbstractIOStatementGenerator {
    ServicesFactory factory = ServicesFactory.INSTANCE;
    final ServicesActionStatementGenerator generator = this;

    public ServicesActionStatementGenerator() {
        super(null);
    }

    public ServicesActionStatementGenerator(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        ServicesCallStatement stmt = this.factory.createServicesCallStatement();
        callStatement.getInvocationTarget().accept(this);
        stmt.setInvocationTarget((Expression)this.stack.pop());
        if (callStatement.hasArguments()) {
            for (Node node : callStatement.getArguments()) {
                node.accept(this);
                stmt.getArguments().add((Expression)this.stack.pop());
            }
        }
        if (callStatement.getCallbackTarget() != null) {
            callStatement.getCallbackTarget().accept(this);
            stmt.setCallback((Expression)this.stack.pop());
        }
        if (callStatement.getErrorCallbackTarget() != null) {
            callStatement.getErrorCallbackTarget().accept(this);
            stmt.setErrorCallback((Expression)this.stack.pop());
        }
        this.setElementInformation((Node)callStatement, (Statement)stmt);
        this.stack.push(stmt);
        if (callStatement.hasSettingsBlock()) {
            this.processSettings((Element)stmt, callStatement.getSettingsBlock());
        }
        return false;
    }
}

