/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql;

import java.io.Serializable;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.internal.sql.EGLSQLGenerationTokens;
import org.eclipse.edt.compiler.internal.sql.InputHostVariableToken;
import org.eclipse.edt.compiler.internal.sql.ItemNameToken;
import org.eclipse.edt.compiler.internal.sql.OutputHostVariableToken;
import org.eclipse.edt.compiler.internal.sql.QuotedStringToken;
import org.eclipse.edt.compiler.internal.sql.SelectNameToken;
import org.eclipse.edt.compiler.internal.sql.StringToken;
import org.eclipse.edt.compiler.internal.sql.TableNameHostVariableToken;
import org.eclipse.edt.compiler.internal.sql.WhereCurrentOfToken;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;

public abstract class Token
implements Serializable {
    public String string;
    private int startOffset;
    private int endOffset;

    public Token() {
    }

    public Token(String string) {
        this.string = string;
    }

    public static Token createToken(EGLPrimeToken token, int type, EGLSQLGenerationTokens tokenizer, EGLPrimeToken prevToken) {
        return Token.createToken(token, type, tokenizer, prevToken, 0, 0);
    }

    public static Token createToken(EGLPrimeToken token, int type, EGLSQLGenerationTokens tokenizer, EGLPrimeToken prevToken, int startOff, int endOff) {
        String string = token.getText();
        IDataBinding sqlIOObject = tokenizer.getSQLIOObject();
        tokenizer.isConvertNameTokenToTableNameToken();
        Token newToken = null;
        switch (type) {
            case 3: {
                newToken = new StringToken(token);
                break;
            }
            case 7: {
                newToken = new SelectNameToken(token.getText(), token.getOffset());
                break;
            }
            case 6: {
                newToken = new WhereCurrentOfToken(token);
                break;
            }
            case 1: {
                newToken = new InputHostVariableToken(string, sqlIOObject);
                if (prevToken == null || !prevToken.getText().equalsIgnoreCase("like")) break;
                ((ItemNameToken)newToken).setFollowsLike();
                break;
            }
            case 2: {
                newToken = new OutputHostVariableToken(string, sqlIOObject);
                if (prevToken == null || !prevToken.getText().equalsIgnoreCase("like")) break;
                ((ItemNameToken)newToken).setFollowsLike();
                break;
            }
            case 4: {
                newToken = new TableNameHostVariableToken(string, sqlIOObject);
                if (prevToken == null || !prevToken.getText().equalsIgnoreCase("like")) break;
                ((ItemNameToken)newToken).setFollowsLike();
                break;
            }
            case 5: {
                newToken = new QuotedStringToken(string);
            }
        }
        if (startOff != 0 && endOff != 0) {
            newToken.setStartOffset(startOff);
            newToken.setEndOffset(endOff);
        }
        return newToken;
    }

    public static Token createToken(String string, int type, EGLSQLGenerationTokens tokenizer, EGLPrimeToken prevToken) {
        return Token.createToken(string, type, tokenizer, prevToken, 0, 0);
    }

    public static Token createToken(String string, int type, EGLSQLGenerationTokens tokenizer, EGLPrimeToken prevToken, int startOff, int endOff) {
        IDataBinding sqlIOObject = tokenizer.getSQLIOObject();
        tokenizer.isConvertNameTokenToTableNameToken();
        Token newToken = null;
        switch (type) {
            case 3: {
                newToken = new StringToken(string);
                break;
            }
            case 7: {
                newToken = new SelectNameToken(string, 0);
                break;
            }
            case 6: {
                newToken = new WhereCurrentOfToken(string);
                break;
            }
            case 1: {
                newToken = new InputHostVariableToken(string, sqlIOObject);
                if (prevToken == null || !prevToken.getText().equalsIgnoreCase("like")) break;
                ((ItemNameToken)newToken).setFollowsLike();
                break;
            }
            case 2: {
                newToken = new OutputHostVariableToken(string, sqlIOObject);
                if (prevToken == null || !prevToken.getText().equalsIgnoreCase("like")) break;
                ((ItemNameToken)newToken).setFollowsLike();
                break;
            }
            case 4: {
                newToken = new TableNameHostVariableToken(string, sqlIOObject);
                if (prevToken == null || !prevToken.getText().equalsIgnoreCase("like")) break;
                ((ItemNameToken)newToken).setFollowsLike();
                break;
            }
            case 5: {
                newToken = new QuotedStringToken(string);
            }
        }
        if (startOff != 0 && endOff != 0) {
            newToken.setStartOffset(startOff);
            newToken.setEndOffset(endOff);
        }
        return newToken;
    }

    public boolean isHostVariableToken() {
        return false;
    }

    public boolean isInputHostVariableToken() {
        return false;
    }

    public boolean isNonQuotedStringToken() {
        return false;
    }

    public boolean isOutputHostVariableToken() {
        return false;
    }

    public boolean isQuotedStringToken() {
        return false;
    }

    public boolean isSelectNameToken() {
        return false;
    }

    public boolean isStringToken() {
        return false;
    }

    public boolean isTableNameHostVariableToken() {
        return false;
    }

    public boolean isWhereCurrentOfToken() {
        return false;
    }

    public static boolean tableName(String string, IDataBinding sqlIOObject) {
        if (sqlIOObject != null && sqlIOObject != IBinding.NOT_FOUND_BINDING) {
            IAnnotationBinding annotationBinding = Token.getField(sqlIOObject.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord"), "tableNames");
            if (annotationBinding == null) {
                return false;
            }
            String[][] value = (String[][])annotationBinding.getValue();
            if (value == null) {
                return false;
            }
            int i = 0;
            while (i < value.length) {
                if (string.equalsIgnoreCase(value[i][0])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public abstract String getSQLString();

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setStartOffset(int startOff) {
        this.startOffset = startOff;
    }

    public void setEndOffset(int endOff) {
        this.endOffset = endOff;
    }

    public boolean isItemNameToken() {
        return false;
    }

    private static String stripQuotes(String aString) {
        return aString.substring(1, aString.length() - 1);
    }

    private static boolean isQuotedTableName(String aString) {
        if (aString == null || aString.length() < 5) {
            return false;
        }
        if (!aString.startsWith("\"")) {
            return false;
        }
        if (!aString.endsWith("\"")) {
            return false;
        }
        aString = aString.substring(1, aString.length() - 1);
        boolean colonFound = false;
        boolean atFound = false;
        int atIndex = -1;
        int end = aString.length();
        int i = 0;
        while (i < end) {
            char curChar = aString.charAt(i);
            if (':' == curChar) {
                if (colonFound || i == 0 || i == end - 1 || atIndex == i - 1) {
                    return false;
                }
                colonFound = true;
            } else if ('@' == curChar) {
                if (colonFound || atFound || i == 0) {
                    return false;
                }
                atFound = true;
                atIndex = i;
            } else if (!(curChar >= '0' && curChar <= '9' || curChar >= 'A' && curChar <= 'Z')) {
                return false;
            }
            ++i;
        }
        return colonFound;
    }

    public String getString() {
        return this.string;
    }

    private static IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }
}

