/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLClauseFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLStatementFactory;

public class EGLSQLAddStatementFactory
extends EGLSQLStatementFactory {
    String insertIntoClause = null;
    String columnsClause = null;
    String valuesClause = null;

    public EGLSQLAddStatementFactory(IDataBinding recordBinding, String ioObjectName, ICompilerOptions compilerOptions) {
        super(recordBinding, ioObjectName, compilerOptions);
    }

    @Override
    public String buildDefaultSQLStatement() {
        if (!this.setupSQLInfo()) {
            return null;
        }
        this.insertIntoClause = EGLSQLClauseFactory.createDefaultInsertIntoClause(this.tableNames);
        this.sqlStatement = this.insertIntoClause != null ? this.insertIntoClause : "";
        this.columnsClause = EGLSQLClauseFactory.createDefaultColumnsClause(this.columnNames);
        if (this.columnsClause != null) {
            this.sqlStatement = String.valueOf(this.sqlStatement) + this.columnsClause;
        }
        this.valuesClause = EGLSQLClauseFactory.createDefaultValuesClause(this.itemNames, this.ioObjectName);
        if (this.valuesClause != null) {
            this.sqlStatement = String.valueOf(this.sqlStatement) + this.valuesClause;
        }
        return this.sqlStatement;
    }

    public String getColumnsClause() {
        return this.columnsClause;
    }

    public String getInsertIntoClause() {
        return this.insertIntoClause;
    }

    @Override
    public String getIOType() {
        return "add".toUpperCase();
    }

    public String getValuesClause() {
        return this.valuesClause;
    }

    @Override
    protected boolean isIoObjectValid() {
        boolean isValid = super.isIoObjectValid();
        isValid = this.hasPersistentItems();
        if (!this.validateSQLRecordNotJoinAndContainsReadWriteColumns()) {
            isValid = false;
        }
        return isValid;
    }

    protected boolean hasPersistentItems() {
        boolean isValid = true;
        if (this.numSQLDataItems == 0) {
            this.errorMessages.add(this.getContainsNoItemsMessage());
            isValid = false;
        }
        return isValid;
    }

    @Override
    protected void setupItemColumnAndKeyInfo() {
        this.setupForSQLInsertStatement();
    }

    @Override
    public String getSQLStatementType() {
        return "insert".toUpperCase();
    }

    protected Problem getContainsNoItemsMessage() {
        return new Problem(0, 0, 2, 4530, new String[]{this.ioObjectName});
    }
}

