/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

import java.util.List;
import java.util.Stack;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BooleanLiteral;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.ForStatement;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.LoopStatement;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.egl.utils.ExpressionCloner;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.impl.EObjectImpl;

public class CompoundConditionExpander
extends AbstractVisitor {
    private Stack<StatementBlock> blockStack = new Stack();
    private int[] tempCount = new int[1];
    private Part part;

    public CompoundConditionExpander(Part part) {
        this.disallowRevisit();
        this.allowParentTracking();
        this.part = part;
        part.accept((EVisitor)this);
    }

    private void setAnnotations(Element oldElem, Element newElem) {
        for (Annotation ann : oldElem.getAnnotations()) {
            newElem.addAnnotation(ann);
        }
    }

    private void setNewObjectInParent(EObject obj) {
        if (this.getParent() instanceof List) {
            ((List)this.getParent()).set(this.getParentSlotIndex(), obj);
        } else if (this.getParent() instanceof EObjectImpl) {
            ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)obj);
        }
    }

    public boolean visit(Part part) {
        return this.part == part;
    }

    public boolean visit(StatementBlock block) {
        StatementBlock newBlock = this.createBlock(block, block.getContainer());
        this.setNewObjectInParent(newBlock);
        this.blockStack.push(newBlock);
        return true;
    }

    private StatementBlock createBlock(Element elem, Container container) {
        StatementBlock newBlock = IrFactory.INSTANCE.createStatementBlock();
        newBlock.setContainer(container);
        this.setAnnotations(elem, newBlock);
        return newBlock;
    }

    public boolean visit(ExceptionBlock block) {
        ExceptionBlock newBlock = IrFactory.INSTANCE.createExceptionBlock();
        newBlock.setContainer(block.getContainer());
        newBlock.setException(block.getException());
        this.setAnnotations(block, newBlock);
        this.setNewObjectInParent(newBlock);
        this.blockStack.push(newBlock);
        return true;
    }

    public boolean visit(BinaryExpression exp) {
        if (CompoundConditionExpander.shouldExpand(exp)) {
            this.expand(exp);
        }
        return false;
    }

    private static boolean shouldExpand(BinaryExpression exp) {
        return !(!"&&".equals(exp.getOperator()) && !"||".equals(exp.getOperator()) || !CompoundConditionExpander.hasInvocation(exp.getLHS()) && !CompoundConditionExpander.hasInvocation(exp.getRHS()));
    }

    private static boolean hasInvocation(Expression expr) {
        return InvocationChecker.hasInvocation(expr);
    }

    private void expand(BinaryExpression exp) {
        StatementBlock block = IrFactory.INSTANCE.createStatementBlock();
        Field field = this.createTemporaryField(exp, block, this.getBooleanType(), exp.getLHS(), this.blockStack.peek().getContainer());
        IfStatement ifStmt = IrFactory.INSTANCE.createIfStatement();
        this.setAnnotations(exp, ifStmt);
        this.addStatementToBlock(ifStmt, block);
        StatementBlock ifBlock = this.createBlock(exp, this.blockStack.peek().getContainer());
        ifStmt.setTrueBranch(ifBlock);
        MemberName nameExpression = this.createMemberName(exp, field);
        if ("||".equals(exp.getOperator())) {
            UnaryExpression unExp = IrFactory.INSTANCE.createUnaryExpression();
            this.setAnnotations(exp, unExp);
            unExp.setExpression(nameExpression);
            unExp.setOperator("!");
            ifStmt.setCondition(unExp);
        } else {
            ifStmt.setCondition(nameExpression);
        }
        this.createAssignentStmt(exp, ifBlock, this.createMemberName(exp, field), exp.getRHS());
        Function func = IrFactory.INSTANCE.createFunction();
        func.setStatementBlock(block);
        func.accept((EVisitor)this);
        for (Statement stmt : func.getStatementBlock().getStatements()) {
            this.addStatementToBlock(stmt, this.blockStack.peek());
        }
        this.setNewObjectInParent(this.createMemberName(exp, field));
    }

    private String createTempVarName() {
        this.tempCount[0] = this.tempCount[0] + 1;
        return "eze_compound_" + this.tempCount[0];
    }

    public void endVisit(Statement stmt) {
        this.addStatementToBlock(stmt, this.blockStack.peek());
    }

    private void addStatementToBlock(Statement stmt, StatementBlock block) {
        block.getStatements().add(stmt);
        stmt.setContainer(block.getContainer());
    }

    public void endVisit(StatementBlock block) {
        StatementBlock newBlock = this.blockStack.pop();
        if (this.getParent() instanceof List && this.getGrandParent() instanceof StatementBlock && !this.blockStack.isEmpty()) {
            this.addStatementToBlock(newBlock, this.blockStack.peek());
        }
    }

    private Object getGrandParent() {
        if (this.getParents().size() > 1) {
            return this.getParents().get(this.getParents().size() - 2);
        }
        return null;
    }

    public boolean visit(IfStatement stmt) {
        StatementBlock newBlock;
        if (stmt.getTrueBranch() != null && !(stmt.getTrueBranch() instanceof StatementBlock)) {
            newBlock = this.createBlock(stmt, stmt.getContainer());
            newBlock.getStatements().add(stmt.getTrueBranch());
            stmt.setTrueBranch(newBlock);
        }
        if (stmt.getFalseBranch() != null && !(stmt.getFalseBranch() instanceof StatementBlock)) {
            newBlock = this.createBlock(stmt, stmt.getContainer());
            newBlock.getStatements().add(stmt.getFalseBranch());
            stmt.setFalseBranch(newBlock);
        }
        return true;
    }

    public boolean visit(LoopStatement stmt) {
        if (stmt.getBody() != null && !(stmt.getBody() instanceof StatementBlock)) {
            StatementBlock newBlock = this.createBlock(stmt, stmt.getContainer());
            newBlock.getStatements().add(stmt.getBody());
            stmt.setBody(newBlock);
        }
        return true;
    }

    public boolean visit(WhileStatement stmt) {
        this.visit((LoopStatement)stmt);
        if (CompoundConditionChecker.needsExpanding(stmt.getCondition())) {
            Expression condition = stmt.getCondition();
            Statement oldBody = stmt.getBody();
            StatementBlock newBody = this.createBlock(oldBody, stmt.getContainer());
            stmt.setBody(newBody);
            BooleanLiteral boolLit = IrFactory.INSTANCE.createBooleanLiteral();
            boolLit.setBooleanValue(Boolean.TRUE);
            this.setAnnotations(condition, boolLit);
            Field field = this.createTemporaryField(condition, this.blockStack.peek(), this.getBooleanType(), boolLit, stmt.getContainer());
            stmt.setCondition(this.createMemberName(condition, field));
            this.createAssignentStmt(condition, newBody, this.createMemberName(condition, field), condition);
            IfStatement ifStmt = IrFactory.INSTANCE.createIfStatement();
            this.setAnnotations(condition, ifStmt);
            this.addStatementToBlock(ifStmt, newBody);
            ifStmt.setCondition(this.createMemberName(condition, field));
            ifStmt.setTrueBranch(oldBody);
        }
        return true;
    }

    public boolean visit(ForStatement stmt) {
        this.visit((LoopStatement)stmt);
        Expression toExpr = stmt.getToExpression();
        Expression incExpr = stmt.getDeltaExpression();
        if (CompoundConditionChecker.needsExpanding(toExpr)) {
            Field tempToField = this.createTemporaryField(toExpr, this.blockStack.peek(), toExpr.getType(), toExpr, stmt.getContainer());
            stmt.setToExpression(this.createMemberName(toExpr, tempToField));
            Expression cloneTo = ExpressionCloner.clone(toExpr);
            this.createAssignentStmt(toExpr, (StatementBlock)stmt.getBody(), this.createMemberName(toExpr, tempToField), cloneTo);
        }
        if (CompoundConditionChecker.needsExpanding(incExpr)) {
            Field tempIncField = this.createTemporaryField(incExpr, this.blockStack.peek(), incExpr.getType(), null, stmt.getContainer());
            stmt.setDeltaExpression(this.createMemberName(incExpr, tempIncField));
            this.createAssignentStmt(incExpr, (StatementBlock)stmt.getBody(), this.createMemberName(incExpr, tempIncField), incExpr);
        }
        return true;
    }

    public boolean visit(ForEachStatement stmt) {
        if (stmt.getBody() != null && !(stmt.getBody() instanceof StatementBlock)) {
            StatementBlock newBlock = this.createBlock(stmt, stmt.getContainer());
            newBlock.getStatements().add(stmt.getBody());
            stmt.setBody(newBlock);
        }
        return true;
    }

    private Field createTemporaryField(Element annotationElem, StatementBlock block, Type type, Expression initValue, Container container) {
        LocalVariableDeclarationStatement localDeclaration = IrFactory.INSTANCE.createLocalVariableDeclarationStatement();
        this.setAnnotations(annotationElem, localDeclaration);
        this.addStatementToBlock(localDeclaration, block);
        DeclarationExpression declarationExpression = IrFactory.INSTANCE.createDeclarationExpression();
        this.setAnnotations(annotationElem, declarationExpression);
        Field field = IrFactory.INSTANCE.createField();
        field.setName(this.createTempVarName());
        field.setType(type);
        declarationExpression.getFields().add(field);
        localDeclaration.setExpression(declarationExpression);
        if (initValue != null) {
            field.setInitializerStatements(this.createBlock(annotationElem, container));
            this.createAssignentStmt(annotationElem, field.getInitializerStatements(), this.createMemberName(annotationElem, field), initValue);
        }
        return field;
    }

    private MemberName createMemberName(Element annotationElem, Field field) {
        MemberName nameExpression = IrFactory.INSTANCE.createMemberName();
        this.setAnnotations(annotationElem, nameExpression);
        nameExpression.setMember(field);
        nameExpression.setId(field.getName());
        return nameExpression;
    }

    private AssignmentStatement createAssignentStmt(Element annotationElem, StatementBlock block, LHSExpr lhs, Expression rhs) {
        AssignmentStatement assignStmt = IrFactory.INSTANCE.createAssignmentStatement();
        this.setAnnotations(annotationElem, assignStmt);
        this.addStatementToBlock(assignStmt, block);
        Assignment assign = IrFactory.INSTANCE.createAssignment();
        this.setAnnotations(annotationElem, assign);
        assign.setLHS(lhs);
        assign.setRHS(rhs);
        assign.setOperator("=");
        assignStmt.setAssignment(assign);
        return assignStmt;
    }

    private Type getBooleanType() {
        return IRUtils.getEGLPrimitiveType("eglx.lang.EBoolean");
    }

    public static class CompoundConditionChecker
    extends AbstractVisitor {
        private boolean needsExpanding = false;

        public static boolean needsExpanding(Expression expr) {
            if (expr == null) {
                return false;
            }
            CompoundConditionChecker checker = new CompoundConditionChecker();
            expr.accept((EVisitor)checker);
            return checker.needsExpanding;
        }

        public CompoundConditionChecker() {
            this.disallowRevisit();
        }

        public boolean visit(Expression expr) {
            return true;
        }

        public boolean visit(BinaryExpression exp) {
            if (CompoundConditionExpander.shouldExpand(exp)) {
                this.needsExpanding = true;
                return false;
            }
            return true;
        }

        public boolean visit(EObject obj) {
            return false;
        }
    }

    public static class InvocationChecker
    extends AbstractVisitor {
        private boolean hasInvocation = false;

        public static boolean hasInvocation(Expression expr) {
            InvocationChecker checker = new InvocationChecker();
            expr.accept((EVisitor)checker);
            return checker.hasInvocation;
        }

        public InvocationChecker() {
            this.disallowRevisit();
        }

        public boolean visit(InvocationExpression expr) {
            this.hasInvocation = true;
            return false;
        }

        public boolean visit(Expression expr) {
            return true;
        }

        public boolean visit(EObject obj) {
            return false;
        }
    }
}

