/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.DataItem;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ElementKind;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MofConversion;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.SubType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.lookup.PartEnvironment;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class TypeUtils
implements MofConversion {
    public static final Type Type_NULLTYPE = TypeUtils.getType("egl:eglx.lang.NullType");
    public static final Type Type_ANY = TypeUtils.getType("egl:eglx.lang.EAny");
    public static final Type Type_CHAR = TypeUtils.getType("egl:eglx.lang.AnyChar");
    public static final Type Type_MBCHAR = TypeUtils.getType("egl:eglx.lang.AnyMBChar");
    public static final Type Type_DBCHAR = TypeUtils.getType("egl:eglx.lang.AnyDBChar");
    public static final Type Type_STRING = TypeUtils.getType("egl:eglx.lang.EString");
    public static final Type Type_UNICODE = TypeUtils.getType("egl:eglx.lang.AnyUnicode");
    public static final Type Type_HEX = TypeUtils.getType("egl:eglx.lang.AnyHex");
    public static final Type Type_SMALLINT = TypeUtils.getType("egl:eglx.lang.ESmallint");
    public static final Type Type_INT = TypeUtils.getType("egl:eglx.lang.EInt");
    public static final Type Type_BIGINT = TypeUtils.getType("egl:eglx.lang.EBigint");
    public static final Type Type_DECIMAL = TypeUtils.getType("egl:eglx.lang.EDecimal");
    public static final Type Type_MONEY = TypeUtils.getType("egl:eglx.lang.EDecimal");
    public static final Type Type_PACF = TypeUtils.getType("egl:eglx.lang.AnyPacf");
    public static final Type Type_UNICODENUM = TypeUtils.getType("egl:eglx.lang.AnyUnicodeNum");
    public static final Type Type_NUM = TypeUtils.getType("egl:eglx.lang.AnyNum");
    public static final Type Type_NUMC = TypeUtils.getType("egl:eglx.lang.AnyNumc");
    public static final Type Type_FLOAT = TypeUtils.getType("egl:eglx.lang.EFloat");
    public static final Type Type_SMALLFLOAT = TypeUtils.getType("egl:eglx.lang.ESmallfloat");
    public static final Type Type_BIN = TypeUtils.getType("egl:eglx.lang.AnyBin");
    public static final Type Type_UBIN = TypeUtils.getType("egl:eglx.lang.AnyUBin");
    public static final Type Type_DATE = TypeUtils.getType("egl:eglx.lang.EDate");
    public static final Type Type_TIME = TypeUtils.getType("egl:eglx.lang.ETime");
    public static final Type Type_TIMESTAMP = TypeUtils.getType("egl:eglx.lang.ETimestamp");
    public static final Type Type_MONTHSPANINTERVAL = TypeUtils.getType("egl:eglx.lang.AnyMonthsInterval");
    public static final Type Type_SECONDSPANINTERAL = TypeUtils.getType("egl:eglx.lang.AnySecondsInterval");
    public static final Type Type_LIST = TypeUtils.getType("egl:eglx.lang.EList");
    public static final Type Type_DICTIONARY = TypeUtils.getType("egl:eglx.lang.EDictionary");
    public static final Type Type_ARRAYDICTIONARY = TypeUtils.getType("egl:eglx.lang.EArrayDictionary");
    public static final Type Type_CLOB = TypeUtils.getType("egl:eglx.lang.AnyClob");
    public static final Type Type_BLOB = TypeUtils.getType("egl:eglx.lang.AnyBlob");
    public static final Type Type_BOOLEAN = TypeUtils.getType("egl:eglx.lang.EBoolean");
    public static final int TypeKind_UNDEFINED = -1;
    public static final int TypeKind_VOID = 0;
    public static final int TypeKind_ANY = 1;
    public static final int TypeKind_CHAR = 2;
    public static final int TypeKind_MBCHAR = 3;
    public static final int TypeKind_DBCHAR = 4;
    public static final int TypeKind_STRING = 5;
    public static final int TypeKind_UNICODE = 6;
    public static final int TypeKind_SMALLINT = 7;
    public static final int TypeKind_INT = 8;
    public static final int TypeKind_BIGINT = 9;
    public static final int TypeKind_DECIMAL = 10;
    public static final int TypeKind_MONEY = 11;
    public static final int TypeKind_PACF = 12;
    public static final int TypeKind_NUM = 13;
    public static final int TypeKind_NUMC = 14;
    public static final int TypeKind_BIN = 15;
    public static final int TypeKind_FLOAT = 16;
    public static final int TypeKind_SMALLFLOAT = 17;
    public static final int TypeKind_DATE = 18;
    public static final int TypeKind_TIME = 19;
    public static final int TypeKind_TIMESTAMP = 20;
    public static final int TypeKind_MONTHSPANINTERVAL = 21;
    public static final int TypeKind_SECONDSPANINTERVAL = 22;
    public static final int TypeKind_LIST = 23;
    public static final int TypeKind_DICTIONARY = 24;
    public static final int TypeKind_ARRAYDICTIONARY = 25;
    public static final int TypeKind_LIMITEDSTRING = 26;
    public static final int TypeKind_BOOLEAN = 27;
    public static final int TypeKind_BLOB = 28;
    public static final int TypeKind_CLOB = 29;
    public static final int TypeKind_NUMBER = 30;
    public static final int TypeKind_HEX = 31;
    public static final int TypeKind_REFLECTTYPE = 32;
    public static final int TypeKind_ARRAY = 33;
    public static final int TypeKind_UBIN = 34;
    public static final int TypeKind_UNICODENUM = 35;
    public static final int TypeKind_NULLTYPE = 36;

    public static Type getType(String signature) {
        try {
            return (Type)new PartEnvironment().find(signature);
        }
        catch (MofObjectNotFoundException mofObjectNotFoundException) {
            return null;
        }
        catch (DeserializationException deserializationException) {
            return null;
        }
    }

    public static Type getEGLType(String typeSignature) {
        String mofKey = "egl:" + typeSignature.toUpperCase().toLowerCase();
        return TypeUtils.getType(mofKey);
    }

    public static int getTypeKind(Type type) {
        Classifier classifier = type.getClassifier();
        if ((type = type.getClassifier()) == null) {
            return 0;
        }
        if (classifier == Type_NULLTYPE) {
            return 36;
        }
        if (classifier == Type_ANY) {
            return 1;
        }
        if (classifier == Type_BOOLEAN) {
            return 27;
        }
        if (classifier == Type_CHAR) {
            return 2;
        }
        if (classifier == Type_MBCHAR) {
            return 3;
        }
        if (classifier == Type_DBCHAR) {
            return 4;
        }
        if (classifier == Type_STRING) {
            return 5;
        }
        if (classifier == Type_UNICODE) {
            return 6;
        }
        if (classifier == Type_HEX) {
            return 31;
        }
        if (classifier == Type_SMALLFLOAT) {
            return 17;
        }
        if (classifier == Type_FLOAT) {
            return 16;
        }
        if (classifier == Type_SMALLINT) {
            return 7;
        }
        if (classifier == Type_INT) {
            return 8;
        }
        if (classifier == Type_BIGINT) {
            return 9;
        }
        if (classifier == Type_DECIMAL) {
            return 10;
        }
        if (classifier == Type_MONEY) {
            return 11;
        }
        if (classifier == Type_PACF) {
            return 12;
        }
        if (classifier == Type_NUM) {
            return 13;
        }
        if (classifier == Type_UNICODENUM) {
            return 35;
        }
        if (classifier == Type_NUMC) {
            return 14;
        }
        if (classifier == Type_BIN) {
            return 15;
        }
        if (classifier == Type_UBIN) {
            return 34;
        }
        if (classifier == Type_DATE) {
            return 18;
        }
        if (classifier == Type_TIME) {
            return 19;
        }
        if (classifier == Type_TIMESTAMP) {
            return 20;
        }
        if (classifier == Type_MONTHSPANINTERVAL) {
            return 21;
        }
        if (classifier == Type_SECONDSPANINTERAL) {
            return 22;
        }
        if (classifier == Type_LIST) {
            return 33;
        }
        if (classifier == Type_DICTIONARY) {
            return 24;
        }
        if (classifier == Type_ARRAYDICTIONARY) {
            return 25;
        }
        if (classifier == Type_CLOB) {
            return 29;
        }
        if (classifier == Type_BLOB) {
            return 28;
        }
        if (type instanceof SequenceType && classifier == Type_STRING) {
            return 26;
        }
        return -1;
    }

    public static Type getRootType(Type type) {
        return type;
    }

    public static boolean isReferenceType(Type type) {
        return !TypeUtils.isValueType(type);
    }

    public static boolean isValueType(Type type) {
        if (type.getClassifier() instanceof EGLClass) {
            String key = ((EGLClass)type.getClassifier()).getMofSerializationKey();
            if (key.equalsIgnoreCase("egl:eglx.lang.ENumber")) {
                return false;
            }
            if (key.equalsIgnoreCase("egl:eglx.lang.EDecimal") && type instanceof ParameterizableType) {
                return false;
            }
            if (key.equalsIgnoreCase("egl:eglx.lang.ETimestamp") && type instanceof ParameterizableType) {
                return false;
            }
            return ((EGLClass)type.getClassifier()).isSubtypeOf((EGLClass)TypeUtils.getType("egl:eglx.lang.AnyValue"));
        }
        return false;
    }

    public static boolean isNumericType(Type type) {
        if (type.getClassifier() instanceof EGLClass) {
            return ((EGLClass)type.getClassifier()).isSubtypeOf((EGLClass)TypeUtils.getType("egl:eglx.lang.ENumber"));
        }
        return false;
    }

    public static boolean isTextType(Type type) {
        if (type != null && type.getClassifier() instanceof EGLClass) {
            return ((EGLClass)type.getClassifier()).isSubtypeOf((EGLClass)TypeUtils.getType("egl:eglx.lang.AnyText"));
        }
        return false;
    }

    public static boolean isDynamicType(Type type) {
        return type != null && (type.equals(Type_ANY) != false || type.equals(Type_DICTIONARY) != false);
    }

    public static boolean isSubtypeOf(Classifier subtype, EGLClass superType) {
        return subtype instanceof EGLClass ? ((EGLClass)subtype).isSubtypeOf(superType) : false;
    }

    public static boolean areCompatible(Classifier lhsType, NamedElement rhsType) {
        if (lhsType.equals(rhsType)) {
            return true;
        }
        if (lhsType instanceof StructPart && rhsType instanceof SubType && ((SubType)((Object)rhsType)).isSubtypeOf((StructPart)lhsType)) {
            return true;
        }
        if (lhsType instanceof SubType && rhsType instanceof StructPart && TypeUtils.isReferenceType(lhsType) && ((SubType)((Object)lhsType)).isSubtypeOf((StructPart)rhsType)) {
            return true;
        }
        if (lhsType instanceof StructPart && rhsType instanceof StructPart) {
            return IRUtils.getConversionOperation((StructPart)rhsType, (StructPart)lhsType) != null;
        }
        if (lhsType instanceof Delegate && rhsType instanceof Function) {
            return TypeUtils.areCompatible((Delegate)lhsType, (Function)rhsType);
        }
        return false;
    }

    public static boolean areCompatible(Delegate lhsType, Function rhsType) {
        if (lhsType.getParameters().size() != rhsType.getParameters().size()) {
            return false;
        }
        if (lhsType.getReturnType() != rhsType.getReturnType()) {
            return false;
        }
        if (rhsType.getReturnField() != null && rhsType.getReturnField().isNullable() != lhsType.isNullable().booleanValue()) {
            return false;
        }
        int i = 0;
        while (i < lhsType.getParameters().size()) {
            FunctionParameter lhsParm = lhsType.getParameters().get(i);
            FunctionParameter rhsParm = rhsType.getParameters().get(i);
            if (lhsParm.isNullable() != rhsParm.isNullable()) {
                return false;
            }
            if (lhsParm.getType() != rhsParm.getType()) {
                return false;
            }
            if (lhsParm.getParameterKind() != rhsParm.getParameterKind()) {
                return false;
            }
            if (lhsParm.isConst().booleanValue() != rhsParm.isConst().booleanValue()) {
                return false;
            }
            if (lhsParm.isField().booleanValue() != rhsParm.isField().booleanValue()) {
                return false;
            }
            if (lhsParm.isDefinedSqlNullable().booleanValue() != rhsParm.isDefinedSqlNullable().booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areStructurallyEquivalent(MofSerializable p1, MofSerializable p2) {
        AnnotationType t2;
        AnnotationType t1;
        Element s2;
        Element s1;
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (!p1.getEClass().equals(p2.getEClass())) {
            return false;
        }
        if (!p1.getMofSerializationKey().equalsIgnoreCase(p2.getMofSerializationKey())) {
            return false;
        }
        if (p1 instanceof Part) {
            s1 = ((Part)p1).getStereotype();
            s2 = ((Part)p2).getStereotype();
            if (s1 == null && s2 != null) {
                return false;
            }
            if (s1 != null && s2 == null) {
                return false;
            }
            if (s1 != null && s2 != null && !s1.getEClass().equals(s2.getEClass())) {
                return false;
            }
            if (((Part)p1).hasCompileErrors() != ((Part)p2).hasCompileErrors()) {
                return false;
            }
        }
        if (p1 instanceof Program) {
            Program prog1 = (Program)p1;
            Program prog2 = (Program)p2;
            if (prog1.getParameters().size() != prog2.getParameters().size()) {
                return false;
            }
            int i = 0;
            while (i < prog1.getParameters().size()) {
                Type t22;
                Type t12 = prog1.getParameters().get(i).getType();
                if (!t12.equals(t22 = prog2.getParameters().get(i).getType()).booleanValue()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (p1 instanceof DataItem) {
            return ((DataItem)p1).getBaseType().equals(((DataItem)p2).getBaseType());
        }
        if (p1 instanceof Delegate) {
            Delegate d1 = (Delegate)p1;
            Delegate d2 = (Delegate)p2;
            if (d1.getParameters().size() != d2.getParameters().size()) {
                return false;
            }
            int j = 0;
            while (j < d1.getParameters().size()) {
                FunctionParameter parm1 = d1.getParameters().get(j);
                FunctionParameter parm2 = d2.getParameters().get(j);
                if (!parm1.getType().equals(parm2.getType()).booleanValue()) {
                    return false;
                }
                if (!parm1.getParameterKind().equals((Object)parm2.getParameterKind())) {
                    return false;
                }
                ++j;
            }
            Type rt1 = d1.getReturnType();
            if (rt1 == null) {
                return d2.getReturnType() == null;
            }
            return rt1.equals(d2.getReturnType());
        }
        if (p1 instanceof EGLClass && p2 instanceof EGLClass) {
            int i;
            s1 = (EGLClass)p1;
            s2 = (EGLClass)p2;
            if (s1.getSuperTypes().size() == s2.getSuperTypes().size()) {
                i = 0;
                while (i < s1.getSuperTypes().size()) {
                    if (!s1.getSuperTypes().get(i).equals(s1.getSuperTypes().get(i)).booleanValue()) {
                        return false;
                    }
                    ++i;
                }
            }
            if (s1.getStructuredFields().size() != s2.getStructuredFields().size()) {
                return false;
            }
            i = 0;
            while (i < s1.getStructuredFields().size()) {
                StructuredField f1 = s1.getStructuredFields().get(i);
                StructuredField f2 = s2.getStructuredFields().get(i);
                if (!f1.getName().equalsIgnoreCase(f2.getName())) {
                    return false;
                }
                if (!f1.getType().equals(f2.getType()).booleanValue()) {
                    return false;
                }
                if (f1.getOccurs() == f2.getOccurs()) {
                    return false;
                }
                if (f1.getParent() == null && f2.getParent() != null) {
                    return false;
                }
                if (f1.getParent() != null && f2.getParent() == null) {
                    return false;
                }
                if (!f1.getParent().getName().equalsIgnoreCase(f2.getParent().getName())) {
                    return false;
                }
                ++i;
            }
            List<Field> flds1 = TypeUtils.collectPublicMembers(s1.getFields());
            List<Field> flds2 = TypeUtils.collectPublicMembers(s2.getFields());
            if (flds1.size() != flds2.size()) {
                return false;
            }
            int i2 = 0;
            while (i2 < flds1.size()) {
                Field f1 = flds1.get(i2);
                Field f2 = null;
                if (TypeUtils.isValueType((Type)s1)) {
                    if (flds2.size() < i2) {
                        return false;
                    }
                    f2 = (Field)flds2.get(i2);
                    if (!f1.getName().equalsIgnoreCase(f2.getName())) {
                        return false;
                    }
                } else {
                    f2 = s2.getField(f1.getName());
                }
                if (f2 == null || !f1.getType().equals(f2.getType()).booleanValue() || f1.isNullable() != f2.isNullable()) {
                    return false;
                }
                ++i2;
            }
            if (!TypeUtils.areStructurallyEquivalentFunctionMembers(s1.getConstructors(), s2.getConstructors())) {
                return false;
            }
            if (!TypeUtils.areStructurallyEquivalentFunctionMembers(s1.getFunctions(), s2.getFunctions())) {
                return false;
            }
            if (!TypeUtils.areStructurallyEquivalentFunctionMembers(s1.getOperations(), s2.getOperations())) {
                return false;
            }
        }
        if (p1 instanceof AnnotationType) {
            t1 = (AnnotationType)p1;
            t2 = (AnnotationType)p2;
            if (t1.getTargets().size() != t2.getTargets().size()) {
                return false;
            }
            for (ElementKind e1 : t1.getTargets()) {
                if (t2.getTargets().contains((Object)e1)) continue;
                return false;
            }
        }
        if (p1 instanceof StereotypeType) {
            t1 = (StereotypeType)p1;
            t2 = (StereotypeType)p2;
            MofSerializable s12 = t1.getDefaultSuperType();
            MofSerializable s22 = t2.getDefaultSuperType();
            if (s12 == null && s22 != null || s12 != null && s22 == null) {
                return false;
            }
            if (s12 != null && !s12.equals(s22)) {
                return false;
            }
            if (t1.getMemberAnnotations().size() != t2.getMemberAnnotations().size()) {
                return false;
            }
            for (AnnotationType type : t1.getMemberAnnotations()) {
                if (t2.getMemberAnnotations().contains(type)) continue;
                return false;
            }
            if (t1.getPartType() == null && t2.getPartType() != null) {
                return false;
            }
            if (t1.getPartType() != null && t2.getPartType() == null) {
                return false;
            }
            if (t1.getPartType() != null && !t1.getPartType().equals(t2.getPartType())) {
                return false;
            }
        }
        return true;
    }

    private static <T extends FunctionMember> boolean areStructurallyEquivalentFunctionMembers(List<T> mbrs1, List<T> mbrs2) {
        List<T> funcs1 = TypeUtils.collectPublicMembers(mbrs1);
        List<FunctionMember> funcs2 = TypeUtils.collectPublicMembers(mbrs2);
        if (funcs1.size() != funcs2.size()) {
            return false;
        }
        int i = 0;
        while (i < funcs1.size()) {
            FunctionMember f1 = (FunctionMember)funcs1.get(i);
            Member f2 = null;
            for (FunctionMember func : funcs2) {
                if (!(func instanceof Constructor) && !f1.getName().equalsIgnoreCase(func.getName()) || f1.getParameters().size() != func.getParameters().size()) continue;
                int j = 0;
                while (j < f1.getParameters().size()) {
                    FunctionParameter parm1 = f1.getParameters().get(j);
                    FunctionParameter parm2 = func.getParameters().get(j);
                    if (parm1.getType() == null && parm2.getType() != null || parm1.getType() != null && parm2.getType() == null || parm1.getType() != null && !parm1.getType().equals(parm2.getType()).booleanValue() || !parm1.getParameterKind().equals((Object)parm2.getParameterKind())) break;
                    ++j;
                }
                if (f1.getType() == null && func.getType() != null || f1.getType() != null && func.getType() == null || f1.getType() != null && !f1.getType().equals(func.getType()).booleanValue()) break;
                f2 = func;
                break;
            }
            if (f2 == null || f1.getAccessKind() != f2.getAccessKind() || f1.isStatic() != f2.isStatic()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int getLeastWideType(StructPart type1, StructPart type2) {
        if (type1.equals(type2).booleanValue()) {
            return 0;
        }
        if (TypeUtils.isReferenceType(type1) && type1.isSubtypeOf(type2)) {
            return -1;
        }
        if (TypeUtils.isReferenceType(type2) && type2.isSubtypeOf(type1)) {
            return 1;
        }
        if (TypeUtils.getBestFitWidenConversionOp(type1, type2) != null) {
            return -1;
        }
        if (TypeUtils.getBestFitWidenConversionOp(type2, type1) != null) {
            return 1;
        }
        return 0;
    }

    private static int getLeastNarrowType(StructPart type1, StructPart type2) {
        if (type1.equals(type2).booleanValue()) {
            return 0;
        }
        if (TypeUtils.isReferenceType(type1) && type1.isSubtypeOf(type2)) {
            return 1;
        }
        if (TypeUtils.isReferenceType(type2) && type2.isSubtypeOf(type1)) {
            return -1;
        }
        if (TypeUtils.getWidenConversionOp(type1, type2) != null) {
            return 1;
        }
        if (TypeUtils.getWidenConversionOp(type2, type1) != null) {
            return -1;
        }
        return 0;
    }

    private static boolean requiresNarrow(NamedElement srcType, Classifier type) {
        if (srcType == type) {
            return false;
        }
        if (srcType instanceof StructPart && type instanceof StructPart && TypeUtils.getBestFitWidenConversionOp((StructPart)srcType, (StructPart)type) != null) {
            return false;
        }
        if (srcType instanceof StructPart && type instanceof StructPart) {
            return TypeUtils.getBestFitNarrowConversionOp((StructPart)srcType, (StructPart)type) != null;
        }
        return false;
    }

    public static int getBestFitType(NamedElement srcType, List<Classifier> types) {
        int j;
        int i;
        ArrayList<Classifier> classifierCandidates = new ArrayList<Classifier>();
        for (Classifier type : types) {
            if (type != null && !srcType.equals(type)) continue;
            classifierCandidates.add(type);
        }
        if (classifierCandidates.size() == 1) {
            return types.indexOf(classifierCandidates.get(0));
        }
        if (classifierCandidates.size() > 1) {
            return -1;
        }
        ArrayList<StructPart> candidates = new ArrayList<StructPart>();
        if (srcType instanceof StructPart) {
            for (Classifier type : types) {
                if (!(type instanceof StructPart)) continue;
                if (TypeUtils.isReferenceType((StructPart)srcType) && ((StructPart)srcType).isSubtypeOf((StructPart)type)) {
                    candidates.add((StructPart)type);
                    continue;
                }
                if (TypeUtils.getBestFitWidenConversionOp((StructPart)srcType, (StructPart)type) == null) continue;
                candidates.add((StructPart)type);
            }
        }
        if (candidates.size() == 1) {
            return types.indexOf(candidates.get(0));
        }
        if (candidates.size() > 1) {
            boolean done = false;
            block2: while (!done) {
                int least = 0;
                i = 0;
                while (i < candidates.size()) {
                    j = 0;
                    while (j < candidates.size()) {
                        if (i != j && candidates.get(i) != null && candidates.get(j) != null) {
                            least = TypeUtils.getLeastWideType((StructPart)candidates.get(i), (StructPart)candidates.get(j));
                            if (least == 1) {
                                candidates.remove(i);
                            }
                            if (least == -1) {
                                candidates.remove(j);
                            }
                        }
                        if (least != 0) continue block2;
                        ++j;
                    }
                    ++i;
                }
                if (candidates.size() == 1) {
                    return types.indexOf(candidates.get(0));
                }
                if (candidates.size() <= 1) continue;
                return -1;
            }
        }
        if (candidates.size() == 0 && srcType instanceof StructPart) {
            for (Classifier type : types) {
                if (!(type instanceof StructPart)) continue;
                if (TypeUtils.isReferenceType((StructPart)type) && ((StructPart)type).isSubtypeOf((StructPart)srcType)) {
                    candidates.add((StructPart)type);
                    continue;
                }
                if (TypeUtils.getBestFitNarrowConversionOp((StructPart)srcType, (StructPart)type) == null) continue;
                candidates.add((StructPart)type);
            }
            if (candidates.size() == 1) {
                return types.indexOf(candidates.get(0));
            }
            if (candidates.size() > 1) {
                boolean done = false;
                block6: while (!done) {
                    int least = 0;
                    i = 0;
                    while (i < candidates.size()) {
                        j = 0;
                        while (j < candidates.size()) {
                            if (i != j && candidates.get(i) != null && candidates.get(j) != null) {
                                least = TypeUtils.getLeastNarrowType((StructPart)candidates.get(i), (StructPart)candidates.get(j));
                                if (least == 1) {
                                    candidates.remove(i);
                                }
                                if (least == -1) {
                                    candidates.remove(j);
                                }
                            }
                            if (least != 0) continue block6;
                            ++j;
                        }
                        ++i;
                    }
                    if (candidates.size() == 1) {
                        return types.indexOf(candidates.get(0));
                    }
                    if (candidates.size() <= 1) continue;
                    return -1;
                }
            }
        }
        return -1;
    }

    public static Operation getBinaryOperation(StructPart clazz, String opSymbol, boolean searchSuperTypes) {
        for (Operation op : clazz.getOperations()) {
            if (!op.getOpSymbol().equals(opSymbol) || op.getParameters().size() != 2 || !op.getParameters().get(0).getType().equals(clazz).booleanValue() || !op.getParameters().get(1).getType().equals(clazz).booleanValue()) continue;
            return op;
        }
        if (searchSuperTypes && !clazz.getSuperTypes().isEmpty()) {
            return TypeUtils.getBinaryOperation(clazz.getSuperTypes().get(0), opSymbol, searchSuperTypes);
        }
        return null;
    }

    public static Operation getWidenConversionOp(StructPart src, StructPart target) {
        Type parmType;
        Object result = null;
        for (Operation op : src.getOperations()) {
            if (!op.isWidenConversion() || op.getParameters().size() != 1 || op.getParameters().get(0) == null || !(parmType = op.getParameters().get(0).getType()).equals(src).booleanValue() || !op.getType().equals(target).booleanValue()) continue;
            return op;
        }
        if (result == null) {
            for (Operation op : target.getOperations()) {
                if (!op.isWidenConversion() || op.getParameters().size() != 1 || op.getParameters().get(0) == null || !(parmType = op.getParameters().get(0).getType()).equals(src).booleanValue() || !op.getType().equals(target).booleanValue()) continue;
                return op;
            }
        }
        return null;
    }

    public static Operation getNarrowConversionOp(StructPart src, StructPart target) {
        Type parmType;
        Object result = null;
        for (Operation op : src.getOperations()) {
            if (!op.isNarrowConversion() || op.getParameters().size() != 1 || op.getParameters().get(0) == null || !(parmType = op.getParameters().get(0).getType()).equals(src).booleanValue() || !op.getType().equals(target).booleanValue()) continue;
            return op;
        }
        if (result == null) {
            for (Operation op : target.getOperations()) {
                if (!op.isNarrowConversion() || op.getParameters().size() != 1 || op.getParameters().get(0) == null || !(parmType = op.getParameters().get(0).getType()).equals(src).booleanValue() || !op.getType().equals(target).booleanValue()) continue;
                return op;
            }
        }
        return null;
    }

    public static Operation getBestFitWidenConversionOp(StructPart src, StructPart target) {
        Operation op = TypeUtils.getBestFitWidenConversionOpSearchSource(src, target);
        return op;
    }

    public static Operation getBestFitWidenConversionOpSearchSource(StructPart src, StructPart target) {
        Operation op = TypeUtils.getWidenConversionOp(src, target);
        if (op == null && !src.getSuperTypes().isEmpty()) {
            StructPart superType = src.getSuperTypes().get(0);
            op = TypeUtils.getBestFitWidenConversionOpSearchSource(superType, target);
        }
        return op;
    }

    public static Operation getBestFitNarrowConversionOp(StructPart src, StructPart target) {
        Operation op = TypeUtils.getBestFitNarrowConversionOpSearchSource(src, target);
        return op;
    }

    public static Operation getBestFitNarrowConversionOpSearchSource(StructPart src, StructPart target) {
        Operation op = TypeUtils.getNarrowConversionOp(src, target);
        if (op == null && !src.getSuperTypes().isEmpty()) {
            StructPart superType = src.getSuperTypes().get(0);
            op = TypeUtils.getBestFitNarrowConversionOpSearchSource(superType, target);
        }
        return op;
    }

    public static List<Operation> getBestFitOperation(StructPart container, String opSymbol, NamedElement ... argumentTypes) {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        for (Operation op : container.getOperations()) {
            if (!op.getOpSymbol().equals(opSymbol) || op.getParameters().size() != argumentTypes.length) continue;
            ops.add(op);
        }
        if (ops.size() <= 1) {
            return ops;
        }
        return TypeUtils.getBestFitFunctionMember(ops, argumentTypes);
    }

    public static List<Function> getBestFitFunction(StructPart container, String name, NamedElement ... argumentTypes) {
        ArrayList<Function> ops = new ArrayList<Function>();
        for (Member mbr : container.getAllMembers()) {
            Function op;
            Function function = op = mbr instanceof Function ? (Function)mbr : null;
            if (op == null || !op.getName().equalsIgnoreCase(name) || op.getParameters().size() != argumentTypes.length) continue;
            ops.add(op);
        }
        if (ops.size() <= 1) {
            return ops;
        }
        return TypeUtils.getBestFitFunctionMember(ops, argumentTypes);
    }

    public static <T extends FunctionMember> List<T> getBestFitFunctionMember(List<T> functionMembers, NamedElement ... argumentTypes) {
        boolean isCandidate;
        ArrayList<FunctionMember> candidates = new ArrayList<FunctionMember>();
        for (FunctionMember op : functionMembers) {
            isCandidate = true;
            int n = 0;
            for (FunctionParameter functionParameter : op.getParameters()) {
                if (!functionParameter.isGenericTypeParameter()) {
                    if (!functionParameter.getType().getClassifier().equals(argumentTypes[n])) {
                        isCandidate = false;
                    }
                    if (!isCandidate) break;
                }
                ++n;
            }
            if (!isCandidate) continue;
            candidates.add(op);
            return candidates;
        }
        for (FunctionMember op : functionMembers) {
            isCandidate = true;
            int n = 0;
            for (FunctionParameter functionParameter : op.getParameters()) {
                if (!functionParameter.isGenericTypeParameter()) {
                    if (!TypeUtils.areCompatible(functionParameter.getType().getClassifier(), argumentTypes[n])) {
                        isCandidate = false;
                    }
                    if (!isCandidate) break;
                }
                ++n;
            }
            if (!isCandidate) continue;
            candidates.add(op);
        }
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList<FunctionMember> result = new ArrayList<FunctionMember>();
        if (candidates.size() > 1) {
            int i2 = 0;
            while (i2 < argumentTypes.length) {
                ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
                for (FunctionMember functionMember : candidates) {
                    arrayList.add(functionMember.getParameters().get(i2).getType().getClassifier());
                }
                int idx = TypeUtils.getBestFitType(argumentTypes[i2], arrayList);
                if (idx != -1) {
                    result.add((FunctionMember)candidates.get(idx));
                }
                ++i2;
            }
        }
        if (result.isEmpty()) {
            result = candidates;
        }
        if (result.size() > 1) {
            ArrayList<FunctionMember> noNarrow = new ArrayList<FunctionMember>();
            boolean hasNarrow = false;
            for (FunctionMember functionMember : result) {
                int i3 = 0;
                while (i3 < argumentTypes.length && !hasNarrow) {
                    Classifier type = functionMember.getParameters().get(i3).getType().getClassifier();
                    if (TypeUtils.requiresNarrow(argumentTypes[i3], type)) {
                        hasNarrow = true;
                    }
                    ++i3;
                }
                if (!hasNarrow) {
                    noNarrow.add(functionMember);
                    continue;
                }
                hasNarrow = false;
            }
            if (!noNarrow.isEmpty()) {
                result = noNarrow;
            }
        }
        if (result.size() > 1) {
            StructPart lowestContainer = null;
            for (FunctionMember op : result) {
                if (!(op.getContainer() instanceof StructPart)) continue;
                StructPart structPart = (StructPart)op.getContainer();
                if (lowestContainer == null) {
                    lowestContainer = structPart;
                    continue;
                }
                if (lowestContainer.isSubtypeOf(structPart) || !structPart.isSubtypeOf(lowestContainer)) continue;
                lowestContainer = structPart;
            }
            if (lowestContainer != null) {
                ArrayList<FunctionMember> lowestFuncs = new ArrayList<FunctionMember>();
                for (FunctionMember functionMember : result) {
                    if (functionMember.getContainer() != lowestContainer) continue;
                    lowestFuncs.add(functionMember);
                }
                result = lowestFuncs;
            }
        }
        return result;
    }

    public static <T extends Member> List<T> collectPublicMembers(List<T> source) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member mbr : source) {
            if (mbr.getAccessKind() == AccessKind.ACC_PRIVATE) continue;
            result.add(mbr);
        }
        return result;
    }
}

