/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.wst.server.preview.internal.IMemento;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    private XMLMemento(Document doc, Element el) {
        this.factory = doc;
        this.element = el;
    }

    /*
     * Loose catch block
     */
    private static XMLMemento createReadRoot(InputStream in) {
        block13: {
            block12: {
                Document document = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                document = parser.parse(new InputSource(in));
                Node node = document.getFirstChild();
                if (!(node instanceof Element)) break block12;
                XMLMemento xMLMemento = new XMLMemento(document, (Element)node);
                try {
                    in.close();
                }
                catch (Exception exception) {}
                return xMLMemento;
                catch (Exception exception) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (Exception exception2) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception3) {}
                    break block13;
                }
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                return new XMLMemento(this.factory, element2);
            }
            ++nX;
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                list.add(element2);
            }
            ++nX;
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        int x = 0;
        while (x < size) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
            ++x;
        }
        return results;
    }

    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static IMemento loadMemento(File file) throws IOException {
        XMLMemento xMLMemento;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            xMLMemento = XMLMemento.createReadRoot(in);
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        return xMLMemento;
    }
}

