/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsp.ui.internal.contentassist.BeanInfoProvider;
import org.eclipse.jst.jsp.ui.internal.contentassist.IJavaPropertyDescriptor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPContentAssistHelper;
import org.eclipse.jst.jsp.ui.internal.editor.JSPEditorPluginImageHelper;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JSPPropertyCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        if (node.getNodeName().equals("jsp:setProperty") || node.getNodeName().equals("jsp:getProperty")) {
            boolean existingComplicatedValue;
            IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
            ITextRegionList openRegions = open.getRegions();
            int i = openRegions.indexOf(contentAssistRequest.getRegion());
            if (i < 0) {
                return;
            }
            ITextRegion attrNameRegion = null;
            String attributeName = null;
            while (i >= 0) {
                if ((attrNameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
            }
            if (attrNameRegion != null) {
                attributeName = open.getText(attrNameRegion);
            }
            ITextRegion tagNameRegion = null;
            boolean isGetProperty = true;
            int j = 0;
            while (j < openRegions.size()) {
                tagNameRegion = openRegions.get(j);
                if (tagNameRegion.getType() == "XML_TAG_NAME" && open.getText(tagNameRegion).trim().equals("jsp:setProperty")) {
                    isGetProperty = false;
                    break;
                }
                ++j;
            }
            String currentValue = null;
            currentValue = contentAssistRequest.getRegion().getType() == "XML_TAG_ATTRIBUTE_VALUE" ? contentAssistRequest.getText() : "";
            String matchString = null;
            matchString = currentValue.length() > StringUtils.strip((String)currentValue).length() && (currentValue.startsWith("\"") || currentValue.startsWith("'")) && contentAssistRequest.getMatchString().length() > 0 ? currentValue.substring(1, contentAssistRequest.getMatchString().length()) : currentValue.substring(0, contentAssistRequest.getMatchString().length());
            boolean bl = existingComplicatedValue = contentAssistRequest.getRegion() != null && contentAssistRequest.getRegion() instanceof ITextRegionContainer;
            if (existingComplicatedValue) {
                contentAssistRequest.getProposals().clear();
                contentAssistRequest.getMacros().clear();
            } else if (attributeName.equals("name")) {
                this.addBeanNameProposals(contentAssistRequest, node, matchString);
            } else if (attributeName.equals("property")) {
                this.addBeanPropertyProposals(contentAssistRequest, node, isGetProperty, matchString);
            }
        }
    }

    private void addBeanPropertyProposals(ContentAssistRequest contentAssistRequest, IDOMNode node, boolean isGetProperty, String matchString) {
        NodeList useBeans;
        String useBeanName;
        if (((Element)node).hasAttribute("name") && (useBeanName = ((Element)node).getAttribute("name")).length() > 0 && (useBeans = node.getOwnerDocument().getElementsByTagName("jsp:useBean")) != null) {
            String typeName = null;
            int j = 0;
            while (j < useBeans.getLength()) {
                Element useBean;
                if (useBeans.item(j).getNodeType() == 1 && (useBean = (Element)useBeans.item(j)) instanceof IndexedRegion && ((IndexedRegion)useBean).getStartOffset() < node.getStartOffset() && useBeanName.equals(useBean.getAttribute("id"))) {
                    typeName = useBean.getAttribute("class");
                    if (!useBean.hasAttribute("class") || typeName.length() < 1) {
                        typeName = useBean.getAttribute("type");
                    }
                    if (!useBean.hasAttribute("type") || typeName.length() < 1) {
                        typeName = useBean.getAttribute("beanName");
                    }
                }
                ++j;
            }
            if (typeName != null && typeName.length() > 0) {
                BeanInfoProvider provider = new BeanInfoProvider();
                IResource resource = JSPContentAssistHelper.getResource(contentAssistRequest);
                IJavaPropertyDescriptor[] descriptors = provider.getRuntimeProperties(resource, typeName);
                CustomCompletionProposal proposal = null;
                String displayString = "";
                int j2 = 0;
                while (j2 < descriptors.length) {
                    IJavaPropertyDescriptor pd = descriptors[j2];
                    if ((pd.getReadable() && isGetProperty || pd.getWriteable() && !isGetProperty) && (matchString.length() == 0 || pd.getName().toLowerCase().startsWith(matchString.toLowerCase()))) {
                        displayString = pd.getDisplayName();
                        if (pd.getDeclaredType() != null && pd.getDeclaredType().length() > 0) {
                            displayString = String.valueOf(displayString) + " - " + pd.getDeclaredType();
                        }
                        proposal = new CustomCompletionProposal("\"" + pd.getName() + "\"", contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), pd.getName().length() + 2, SharedXMLEditorPluginImageHelper.getImage((String)"icons/full/obj16/attribute_obj.gif"), displayString, null, pd.getDeclaredType(), 800);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                    ++j2;
                }
            }
        }
    }

    private void addBeanNameProposals(ContentAssistRequest contentAssistRequest, IDOMNode node, String matchString) {
        NodeList useBeans = node.getOwnerDocument().getElementsByTagName("jsp:useBean");
        if (useBeans != null) {
            String id = "";
            String displayString = null;
            String classOrType = null;
            String imageName = "icons/full/obj16/class_obj.gif";
            int j = 0;
            while (j < useBeans.getLength()) {
                Element useBean;
                if (useBeans.item(j).getNodeType() == 1 && (useBean = (Element)useBeans.item(j)) instanceof IndexedRegion && ((IndexedRegion)useBean).getStartOffset() < node.getStartOffset() && useBean.hasAttribute("id")) {
                    id = useBean.hasAttribute("id") ? StringUtils.strip((String)useBean.getAttribute("id")) : null;
                    displayString = null;
                    classOrType = null;
                    imageName = "icons/full/obj16/class_obj.gif";
                    if (useBean.hasAttribute("class")) {
                        classOrType = useBean.getAttribute("class");
                    }
                    if ((classOrType == null || classOrType.length() < 1) && useBean.hasAttribute("type")) {
                        classOrType = useBean.getAttribute("type");
                        imageName = "icons/full/obj16/public.gif";
                    }
                    if ((classOrType == null || classOrType.length() < 1) && useBean.hasAttribute("beanName")) {
                        classOrType = useBean.getAttribute("beanName");
                        imageName = "icons/full/obj16/public.gif";
                    }
                    displayString = classOrType != null && classOrType.length() > 0 ? String.valueOf(id) + " - " + classOrType : id;
                    if (id != null && (matchString.length() == 0 || id.startsWith(matchString))) {
                        CustomCompletionProposal proposal = new CustomCompletionProposal("\"" + id + "\"", contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), id.length() + 2, JSPEditorPluginImageHelper.getInstance().getImage(imageName), displayString, null, null, 800);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                }
                ++j;
            }
        }
    }
}

