/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaThread;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.IVariableAdapter;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionContainerVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class VariableUtil {
    public static final IVariable[] EMPTY_VARIABLES = new IVariable[0];

    private VariableUtil() {
    }

    public static List<IEGLJavaVariable> filterAndWrapVariables(IVariable[] javaVariables, IEGLJavaStackFrame frame, boolean skipLocals, IEGLJavaValue parent) throws DebugException {
        ArrayList<IEGLJavaVariable> newEGLVariables = new ArrayList<IEGLJavaVariable>(javaVariables.length);
        SMAPVariableInfo[] infos = parent == null ? frame.getSMAPVariableInfos() : parent.getSMAPVariableInfos();
        String javaFrameSignature = String.valueOf(frame.getJavaStackFrame().getMethodName()) + ";" + frame.getJavaStackFrame().getSignature();
        int currentLine = frame.getLineNumber();
        int frameStartLine = frame.getSMAPFunctionInfo() == null ? -1 : frame.getSMAPFunctionInfo().lineDeclared;
        int i = 0;
        while (i < javaVariables.length) {
            SMAPVariableInfo info;
            SMAPVariableInfo matchingInfo;
            IJavaVariable javaVar = (IJavaVariable)javaVariables[i];
            String javaName = javaVar.getName();
            if (javaVar.isLocal()) {
                if (!skipLocals) {
                    matchingInfo = null;
                    int j = 0;
                    while (j < infos.length) {
                        info = infos[j];
                        if (info.javaName.equals(javaName) && info.javaMethodSignature != null && info.javaMethodSignature.equals(javaFrameSignature) && (currentLine >= info.lineDeclared || currentLine == frameStartLine) && (matchingInfo == null || matchingInfo.lineDeclared < info.lineDeclared)) {
                            matchingInfo = info;
                        }
                        ++j;
                    }
                    if (matchingInfo != null) {
                        IEGLJavaVariable var = frame.getCorrespondingVariable(VariableUtil.createEGLVariable(javaVar, matchingInfo, frame, parent), parent);
                        newEGLVariables.add(var);
                    }
                }
            } else if ("this".equals(javaName)) {
                IEGLJavaVariable var = frame.getCorrespondingVariable(new EGLJavaFunctionContainerVariable(frame.getDebugTarget(), javaVar, frame), parent);
                newEGLVariables.add(var);
            } else {
                matchingInfo = null;
                int j = 0;
                while (j < infos.length) {
                    info = infos[j];
                    if (info.javaName.equals(javaName) && info.javaMethodSignature == null) {
                        matchingInfo = info;
                        break;
                    }
                    ++j;
                }
                if (matchingInfo != null) {
                    IEGLJavaVariable var = frame.getCorrespondingVariable(VariableUtil.createEGLVariable(javaVar, matchingInfo, frame, parent), parent);
                    newEGLVariables.add(var);
                }
            }
            ++i;
        }
        return newEGLVariables;
    }

    public static IEGLJavaVariable createEGLVariable(IJavaVariable javaVariable, SMAPVariableInfo info, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        IVariableAdapter[] iVariableAdapterArray = EDTDebugCorePlugin.getDefault().getVariableAdapters();
        int n = iVariableAdapterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableAdapter adapter = iVariableAdapterArray[n2];
            IEGLJavaVariable variable = adapter.adapt(javaVariable, frame, info, parent);
            if (variable != null) {
                return variable;
            }
            ++n2;
        }
        return new EGLJavaVariable(frame.getDebugTarget(), javaVariable, info, frame, parent);
    }

    public static String getQualifiedName(IEGLJavaVariable var) throws DebugException {
        if (var == null) {
            return null;
        }
        IEGLJavaValue parent = var.getParentValue();
        if (parent == null || parent.getParentVariable() == null) {
            return var.getName();
        }
        StringBuilder buf = new StringBuilder(100);
        buf.append(VariableUtil.getQualifiedName(parent.getParentVariable()));
        buf.append('|');
        buf.append(var.getName());
        return buf.toString();
    }

    public static boolean isInstanceOf(IJavaVariable variable, String typeName) {
        IJavaValue javaValue = null;
        try {
            IValue value = variable.getValue();
            if (value instanceof IJavaValue) {
                IJavaType javaType;
                javaValue = (IJavaValue)value;
                IJavaType iJavaType = javaType = javaValue.isNull() ? variable.getJavaType() : javaValue.getJavaType();
                if (javaType instanceof IJavaClassType) {
                    return VariableUtil.isInstanceOf((IJavaClassType)javaType, typeName, false);
                }
            }
        }
        catch (DebugException debugException) {}
        try {
            String type = javaValue == null || javaValue.isNull() ? variable.getReferenceTypeName() : javaValue.getReferenceTypeName();
            return typeName.equals(type);
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    private static boolean isInstanceOf(IJavaClassType type, String typeName, boolean skipInterfaces) throws DebugException {
        IJavaClassType superType;
        if (typeName.equals(type.getName())) {
            return true;
        }
        if (!skipInterfaces) {
            IJavaInterfaceType[] iJavaInterfaceTypeArray = type.getAllInterfaces();
            int n = iJavaInterfaceTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaInterfaceType iface = iJavaInterfaceTypeArray[n2];
                if (typeName.equals(iface.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        return (superType = type.getSuperclass()) != null && VariableUtil.isInstanceOf(superType, typeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJavaValue invokeStaticMethod(IEGLJavaThread thread, IJavaStackFrame frame, String className, String methodName, String methodSignature, IJavaValue[] args) {
        Object object = thread.getEvaluationLock();
        synchronized (object) {
            VariableUtil.waitForEvaluation(thread.getJavaThread());
            IJavaDebugTarget target = (IJavaDebugTarget)frame.getDebugTarget();
            try {
                IJavaType instType;
                IJavaClassObject classObj;
                block16: {
                    IJavaObject thisObj = frame.getThis();
                    IJavaReferenceType context = thisObj == null ? frame.getReferenceType() : (IJavaReferenceType)thisObj.getJavaType();
                    IJavaObject classLoader = context.getClassLoaderObject();
                    classObj = null;
                    IJavaType[] types = target.getJavaTypes(className);
                    if (types != null && types.length > 0) {
                        int i = 0;
                        while (i < types.length) {
                            if (types[i] instanceof IJavaReferenceType && VariableUtil.isClassLoaderCompatible(classLoader, ((IJavaReferenceType)types[i]).getClassLoaderObject(), thread)) {
                                classObj = ((IJavaReferenceType)types[i]).getClassObject();
                                break;
                            }
                            ++i;
                        }
                    }
                    if (classObj == null) {
                        IJavaValue name = target.newValue(className);
                        ((IJavaObject)name).disableCollection();
                        try {
                            try {
                                IJavaClassType javaLangClass = VariableUtil.getJavaLangClass(target);
                                if (javaLangClass != null) {
                                    IJavaValue[] forNameArgs = new IJavaValue[]{name, target.newValue(true), classLoader == null ? target.nullValue() : classLoader};
                                    classObj = (IJavaClassObject)VariableUtil.runSendMessage(thread, javaLangClass, forNameArgs, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                                }
                            }
                            catch (CoreException coreException) {
                                ((IJavaObject)name).enableCollection();
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            ((IJavaObject)name).enableCollection();
                            throw throwable;
                        }
                        ((IJavaObject)name).enableCollection();
                    }
                }
                if (classObj != null && (instType = classObj.getInstanceType()) instanceof IJavaClassType) {
                    return VariableUtil.runSendMessage(thread, (IJavaClassType)instType, args, methodName, methodSignature);
                }
            }
            catch (CoreException e) {
                EDTDebugCorePlugin.log(e);
            }
        }
        return null;
    }

    public static IJavaClassType getJavaLangClass(IJavaDebugTarget target) throws CoreException {
        IJavaType[] types = target.getJavaTypes("java.lang.Class");
        if (types == null || types.length != 1) {
            return null;
        }
        return (IJavaClassType)types[0];
    }

    public static boolean isClassLoaderCompatible(IJavaObject cl1, IJavaObject cl2, IEGLJavaThread thread) throws CoreException {
        if (cl1 == null || cl2 == null) {
            return true;
        }
        IJavaObject toTry = cl1;
        while (toTry != null) {
            if (toTry.equals(cl2)) {
                return true;
            }
            toTry = VariableUtil.getParentLoader(toTry, thread);
        }
        return false;
    }

    public static IJavaObject getParentLoader(IJavaObject cl, IEGLJavaThread thread) throws CoreException {
        IJavaFieldVariable parent = cl.getField("parent", false);
        if (parent != null) {
            IJavaValue value = (IJavaValue)parent.getValue();
            return value.isNull() ? null : (IJavaObject)value;
        }
        IJavaValue value = VariableUtil.runSendMessage(thread, cl, null, "getParent", "()Ljava/lang/ClassLoader;", false);
        return value.isNull() ? null : (IJavaObject)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJavaValue runSendMessage(IEGLJavaThread thread, final IJavaObject receiver, final IJavaValue[] args, final String methodName, final String methodSignature, final boolean superSend) throws DebugException {
        final IJavaValue[] result = new IJavaValue[1];
        Object object = thread.getEvaluationLock();
        synchronized (object) {
            IJavaThread javaThread = thread.getJavaThread();
            IEvaluationRunnable eval = new IEvaluationRunnable(){

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    result[0] = receiver.sendMessage(methodName, methodSignature, args, thread, superSend);
                }
            };
            VariableUtil.waitForEvaluation(javaThread);
            javaThread.runEvaluation(eval, null, 128, false);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJavaValue runSendMessage(IEGLJavaThread thread, final IJavaClassType receiver, final IJavaValue[] args, final String methodName, final String methodSignature) throws DebugException {
        final IJavaValue[] result = new IJavaValue[1];
        Object object = thread.getEvaluationLock();
        synchronized (object) {
            IJavaThread javaThread = thread.getJavaThread();
            IEvaluationRunnable eval = new IEvaluationRunnable(){

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    result[0] = receiver.sendMessage(methodName, methodSignature, args, thread);
                }
            };
            VariableUtil.waitForEvaluation(javaThread);
            javaThread.runEvaluation(eval, null, 128, false);
        }
        return result[0];
    }

    private static void waitForEvaluation(IJavaThread thread) {
        while (thread.isPerformingEvaluation() || !thread.isSuspended()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

